/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmModelAssociator
implements IJvmModelAssociations,
IJvmModelAssociator {
    @Inject
    @Named(value="languageName")
    private String languageID;

    @Override
    public void associate(EObject sourceElement, EObject jvmElement) {
        this.associate(sourceElement, jvmElement, false);
    }

    @Override
    public void associatePrimary(EObject sourceElement, EObject jvmElement) {
        this.associate(sourceElement, jvmElement, true);
    }

    @Override
    public void disassociate(EObject rootElement) {
        TreeIterator content = EcoreUtil2.eAll((EObject)rootElement);
        while (content.hasNext()) {
            EObject element = (EObject)content.next();
            AbstractAssociationAdapter associationAdapter = this.getAssociationAdapter(element);
            if (associationAdapter == null) continue;
            element.eAdapters().remove((Object)associationAdapter);
        }
    }

    protected void associate(EObject sourceElement, EObject jvmElement, boolean isPrimary) {
        this.setSourceAdapter(sourceElement, jvmElement);
        this.setJvmAdapter(jvmElement, sourceElement, isPrimary);
    }

    protected void setSourceAdapter(EObject targetElement, EObject associatedElement) {
        AbstractAssociationAdapter adapter = this.getAssociationAdapter(targetElement);
        if (adapter == null) {
            adapter = new SourceAssociationAdapter(this.languageID);
            targetElement.eAdapters().add((Object)adapter);
        } else {
            this.checkAdapter(adapter, false);
        }
        adapter.addAssociation(associatedElement);
    }

    protected void setJvmAdapter(EObject targetElement, EObject associatedElement, boolean isPrimary) {
        AbstractAssociationAdapter adapter = this.getAssociationAdapter(targetElement);
        if (adapter == null) {
            adapter = new JvmAssociationAdapter(this.languageID);
            targetElement.eAdapters().add((Object)adapter);
        } else {
            this.checkAdapter(adapter, true);
        }
        if (isPrimary) {
            ((JvmAssociationAdapter)adapter).setPrimaryAssociatedElement(associatedElement);
        } else {
            adapter.addAssociation(associatedElement);
        }
    }

    @Override
    public Set<EObject> getJvmElements(EObject sourceElement) {
        return this.getAssociatedElements(this.getSourceAdapter(sourceElement));
    }

    @Override
    public Set<EObject> getSourceElements(EObject jvmElement) {
        return this.getAssociatedElements(this.getJvmAdapter(jvmElement));
    }

    @Override
    public EObject getPrimarySourceElement(EObject jvmElement) {
        JvmAssociationAdapter jvmAdapter = this.getJvmAdapter(jvmElement);
        return jvmAdapter != null ? jvmAdapter.getPrimaryAssociatedElement() : null;
    }

    @Override
    public Set<EObject> getAssociatedElements(EObject jvmOrSourceElement) {
        return this.getAssociatedElements(this.getAssociationAdapter(jvmOrSourceElement));
    }

    protected Set<EObject> getAssociatedElements(AbstractAssociationAdapter adapter) {
        return adapter == null ? Collections.emptySet() : adapter.getAssociatedElements();
    }

    protected SourceAssociationAdapter getSourceAdapter(EObject sourceElement) {
        AbstractAssociationAdapter adapter = this.getAssociationAdapter(sourceElement);
        return adapter instanceof SourceAssociationAdapter ? (SourceAssociationAdapter)adapter : null;
    }

    protected JvmAssociationAdapter getJvmAdapter(EObject jvmElement) {
        AbstractAssociationAdapter adapter = this.getAssociationAdapter(jvmElement);
        return adapter instanceof JvmAssociationAdapter ? (JvmAssociationAdapter)adapter : null;
    }

    protected void checkAdapter(AbstractAssociationAdapter adapter, boolean isJvm) {
        if (adapter != null && adapter instanceof JvmAssociationAdapter ^ isJvm) {
            throw new IllegalArgumentException("Wrong association adapter type. It's likely you confused source and jvm element");
        }
    }

    protected AbstractAssociationAdapter getAssociationAdapter(EObject jvmOrSourceElement) {
        AbstractAssociationAdapter adapter = (AbstractAssociationAdapter)EcoreUtil.getAdapter((List)jvmOrSourceElement.eAdapters(), AbstractAssociationAdapter.class);
        return adapter != null && Strings.equal((String)adapter.getLanguageID(), (String)this.languageID) ? adapter : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractAssociationAdapter
    extends AdapterImpl {
        private Set<EObject> associatedElements;
        private String languageID;

        public AbstractAssociationAdapter(String languageID) {
            this.languageID = languageID;
        }

        public String getLanguageID() {
            return this.languageID;
        }

        protected boolean addAssociation(EObject associatedElement) {
            if (this.associatedElements == null) {
                this.associatedElements = Sets.newLinkedHashSet();
            }
            return this.associatedElements.add(associatedElement);
        }

        public Set<EObject> getAssociatedElements() {
            return this.associatedElements == null ? Collections.emptySet() : this.associatedElements;
        }

        public boolean isAdapterForType(Object type) {
            return AbstractAssociationAdapter.class.equals(type);
        }
    }

    protected static class JvmAssociationAdapter
    extends AbstractAssociationAdapter {
        private EObject primaryAssociatedElement;

        public JvmAssociationAdapter(String languageID) {
            super(languageID);
        }

        public EObject getPrimaryAssociatedElement() {
            return this.primaryAssociatedElement;
        }

        public void setPrimaryAssociatedElement(EObject primaryAssociatedElement) {
            this.primaryAssociatedElement = primaryAssociatedElement;
            this.addAssociation(primaryAssociatedElement);
        }
    }

    protected static class SourceAssociationAdapter
    extends AbstractAssociationAdapter {
        public SourceAssociationAdapter(String languageID) {
            super(languageID);
        }
    }
}

