/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ComparableExtensions;
import org.eclipse.xtext.xbase.lib.FunctionExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractStaticMethodsFeatureForTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodsFeatureForTypeProvider
extends AbstractStaticMethodsFeatureForTypeProvider {
    private static final Map<String, String> extensionClasses = Maps.newHashMap();
    private static final Collection<String> literalClasses;
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private Primitives primitives;

    static {
        extensionClasses.put(Boolean.class.getCanonicalName(), BooleanExtensions.class.getCanonicalName());
        extensionClasses.put(String.class.getCanonicalName(), StringExtensions.class.getCanonicalName());
        extensionClasses.put(Integer.class.getCanonicalName(), IntegerExtensions.class.getCanonicalName());
        extensionClasses.put(Comparable.class.getCanonicalName(), ComparableExtensions.class.getCanonicalName());
        extensionClasses.put(Object.class.getCanonicalName(), ObjectExtensions.class.getCanonicalName());
        extensionClasses.put(List.class.getCanonicalName(), ListExtensions.class.getCanonicalName());
        extensionClasses.put(Collection.class.getCanonicalName(), CollectionExtensions.class.getCanonicalName());
        extensionClasses.put(Map.class.getCanonicalName(), CollectionExtensions.class.getCanonicalName());
        extensionClasses.put(Iterable.class.getCanonicalName(), IterableExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function0.class.getName(), FunctionExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function1.class.getName(), FunctionExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function2.class.getName(), FunctionExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function3.class.getName(), FunctionExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function4.class.getName(), FunctionExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function5.class.getName(), FunctionExtensions.class.getCanonicalName());
        extensionClasses.put(Functions.Function6.class.getName(), FunctionExtensions.class.getCanonicalName());
        literalClasses = ImmutableList.of((Object)CollectionLiterals.class.getName(), (Object)InputOutput.class.getName());
    }

    @Override
    protected Iterable<String> getVisibleTypesContainingStaticMethods(JvmTypeReference reference) {
        if (reference == null || reference.getType() == null) {
            return literalClasses;
        }
        reference = this.primitives.asWrapperTypeIfPrimitive(reference);
        ArrayList typeNames = Lists.newArrayList((Object[])new String[]{reference.getType().getIdentifier()});
        typeNames.addAll(this.superTypeCollector.collectSuperTypeNames(reference.getType()));
        Iterable result = Iterables.filter((Iterable)Iterables.transform((Iterable)typeNames, (Function)new Function<String, String>(){

            public String apply(String from) {
                return (String)extensionClasses.get(from);
            }
        }), (Predicate)Predicates.notNull());
        return result;
    }
}

