/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.outline;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.xtend2.jvmmodel.DispatchUtil;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.ui.labeling.Xtend2Images;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;

public class Xtend2OutlineTreeProvider
extends DefaultOutlineTreeProvider {
    @Inject
    private Xtend2Images images;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private DispatchUtil dispatchUtil;

    protected void _createChildren(DocumentRootNode parentNode, XtendFile xtendFile) {
        if (xtendFile.getPackage() != null) {
            this.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)xtendFile, (EStructuralFeature)Xtend2Package.Literals.XTEND_FILE__PACKAGE, this.images.forPackage(), xtendFile.getPackage(), true);
        }
        if (!xtendFile.getImports().isEmpty()) {
            this.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)xtendFile, (EStructuralFeature)Xtend2Package.Literals.XTEND_FILE__IMPORTS, this.images.forImportContainer(), "import declarations", false);
        }
        if (xtendFile.getXtendClass() != null) {
            this.createEObjectNode((IOutlineNode)parentNode, (EObject)xtendFile.getXtendClass());
        }
    }

    protected void _createChildren(IOutlineNode parentNode, XtendClass xtendClass) {
        JvmGenericType inferredType = this.associations.getInferredType(xtendClass);
        if (inferredType != null) {
            HashSet dispatchFunctions = Sets.newHashSet();
            for (XtendMember member : xtendClass.getMembers()) {
                if (dispatchFunctions.contains(member) || !(member instanceof XtendFunction) || !((XtendFunction)member).isDispatch()) continue;
                for (JvmOperation inferredOperation : Iterables.filter((Iterable)this.associations.getJvmElements((EObject)member), JvmOperation.class)) {
                    if (!this.dispatchUtil.isDispatcherFunction(inferredOperation)) continue;
                    this.createEObjectNode(parentNode, (EObject)inferredOperation);
                    dispatchFunctions.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.associations.getSourceElements((EObject)inferredOperation), XtendFunction.class)));
                }
            }
            for (XtendMember member : xtendClass.getMembers()) {
                if (dispatchFunctions.contains(member)) continue;
                this.createEObjectNode(parentNode, (EObject)member);
            }
        } else {
            for (XtendMember member : xtendClass.getMembers()) {
                this.createEObjectNode(parentNode, (EObject)member);
            }
        }
    }

    protected void _createChildren(IOutlineNode parentNode, JvmOperation inferredOperation) {
        ArrayList xtendFunctions = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.associations.getSourceElements((EObject)inferredOperation), XtendFunction.class));
        Collections.sort(xtendFunctions, new Comparator<XtendFunction>(){

            @Override
            public int compare(XtendFunction arg0, XtendFunction arg1) {
                return Xtend2OutlineTreeProvider.this.index(arg0) - Xtend2OutlineTreeProvider.this.index(arg1);
            }
        });
        for (XtendFunction xtendFunction : xtendFunctions) {
            if (!xtendFunction.isDispatch()) continue;
            this.createEObjectNode(parentNode, (EObject)xtendFunction);
        }
    }

    protected boolean _isLeaf(XtendMember function) {
        return true;
    }

    protected int index(XtendFunction f) {
        return ((XtendClass)f.eContainer()).getMembers().indexOf((Object)f);
    }
}

