/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.annotations.scoping.XbaseWithAnnotationsScopeProvider;
import org.eclipse.xtext.xbase.scoping.LocalVariableScopeContext;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IValidatedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.LocalVarDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.XFeatureCallSugarDescriptionProvider;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.scoping.ExtensionMethodsFeaturesProvider;
import org.eclipse.xtext.xtend2.scoping.StaticallyImportedFeaturesProvider;
import org.eclipse.xtext.xtend2.xtend2.CreateExtensionInfo;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2ScopeProvider
extends XbaseWithAnnotationsScopeProvider {
    @Inject
    private IXtend2JvmAssociations xtend2jvmAssociations;
    @Inject
    private Provider<StaticallyImportedFeaturesProvider> staticallyImportedFeaturesProvider;
    @Inject
    private Provider<ExtensionMethodsFeaturesProvider> extensionMethodsFeaturesProvider;
    @Inject
    private TypeReferences typeReferences;

    public IScope getScope(EObject context, EReference reference) {
        IScope parent = super.getScope(context, reference);
        if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType())) {
            XtendClass clazz;
            ArrayList descriptions = null;
            XtendFunction function = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)context, XtendFunction.class);
            if (function != null && !function.getTypeParameters().isEmpty()) {
                descriptions = Lists.newArrayList();
                for (JvmTypeParameter param : function.getTypeParameters()) {
                    QualifiedName qn = QualifiedName.create((String[])new String[]{param.getName()});
                    descriptions.add(EObjectDescription.create((QualifiedName)qn, (EObject)param));
                }
            }
            if ((clazz = (XtendClass)EcoreUtil2.getContainerOfType((EObject)context, XtendClass.class)) != null) {
                JvmGenericType inferredType;
                if (descriptions == null) {
                    descriptions = Lists.newArrayList();
                }
                if ((inferredType = this.xtend2jvmAssociations.getInferredType(clazz)) != null) {
                    QualifiedName inferredDeclaringTypeName = QualifiedName.create((String[])new String[]{inferredType.getSimpleName()});
                    descriptions.add(EObjectDescription.create((QualifiedName)inferredDeclaringTypeName, (EObject)inferredType));
                }
            }
            if (descriptions != null && !descriptions.isEmpty()) {
                return MapBasedScope.createScope((IScope)parent, (Iterable)descriptions);
            }
        }
        return parent;
    }

    protected IScope createLocalVarScope(IScope parent, LocalVariableScopeContext scopeContext) {
        EObject context = scopeContext.getContext();
        if (context instanceof XtendClass) {
            return this.getScopeForXtendClass((XtendClass)context, parent);
        }
        if (context instanceof XtendFunction) {
            XtendFunction func = (XtendFunction)context;
            EList<XtendParameter> parameters = func.getParameters();
            ArrayList descriptions = Lists.newArrayList();
            if (func.getCreateExtensionInfo() != null) {
                CreateExtensionInfo info = func.getCreateExtensionInfo();
                LocalVarDescription description = new LocalVarDescription(QualifiedName.create((String[])new String[]{info.getName()}), (JvmIdentifiableElement)info);
                descriptions.add(description);
            }
            for (XtendParameter parameter : parameters) {
                if (Strings.isEmpty((String)parameter.getName())) continue;
                IValidatedEObjectDescription desc = this.createLocalVarDescription(parameter);
                descriptions.add(desc);
            }
            return new JvmFeatureScope(super.createLocalVarScope(parent, scopeContext), "XtendFunction", (Iterable)descriptions);
        }
        return super.createLocalVarScope(parent, scopeContext);
    }

    protected JvmFeatureScope getScopeForXtendClass(XtendClass context, IScope parent) {
        XFeatureCall receiver = XbaseFactory.eINSTANCE.createXFeatureCall();
        receiver.setFeature((JvmIdentifiableElement)context);
        return new JvmFeatureScope(parent, "XtendClass", (Iterable)Lists.newArrayList((Object[])new LocalVarDescription[]{new LocalVarDescription(THIS, (JvmIdentifiableElement)context), new LocalVarDescription(QualifiedName.create((String[])new String[]{"super"}), (JvmIdentifiableElement)context.getSuperCallReferable())}));
    }

    protected List<IJvmFeatureDescriptionProvider> getStaticFeatureDescriptionProviders(Resource context, JvmDeclaredType contextType) {
        List result = super.getStaticFeatureDescriptionProviders(context, contextType);
        DefaultJvmFeatureDescriptionProvider defaultProvider = this.newDefaultFeatureDescProvider();
        StaticallyImportedFeaturesProvider staticProvider = (StaticallyImportedFeaturesProvider)((Object)this.staticallyImportedFeaturesProvider.get());
        staticProvider.setContext(context);
        defaultProvider.setContextType(contextType);
        defaultProvider.setFeaturesForTypeProvider((IFeaturesForTypeProvider)staticProvider);
        result.add(0, defaultProvider);
        return result;
    }

    protected List<IJvmFeatureDescriptionProvider> getFeatureDescriptionProviders(JvmTypeReference type, EObject expression, JvmDeclaredType currentContext, XExpression implicitReceiver) {
        List result = super.getFeatureDescriptionProviders(type, expression, currentContext, implicitReceiver);
        StaticallyImportedFeaturesProvider staticProvider = (StaticallyImportedFeaturesProvider)((Object)this.staticallyImportedFeaturesProvider.get());
        staticProvider.setContext(expression.eResource());
        staticProvider.setExtensionProvider(true);
        this.insertDescriptionProviders((IFeaturesForTypeProvider)staticProvider, currentContext, implicitReceiver, result);
        if (implicitReceiver == null) {
            XtendClass xtendClass = ((XtendFile)expression.eResource().getContents().get(0)).getXtendClass();
            XFeatureCall callToThis = XbaseFactory.eINSTANCE.createXFeatureCall();
            callToThis.setFeature((JvmIdentifiableElement)xtendClass);
            Iterable<XtendField> iterable = this.getExtensionDependencies(xtendClass);
            for (XtendField XtendField2 : iterable) {
                JvmIdentifiableElement dependencyImplicitReceiver = this.findImplicitReceiverFor(XtendField2);
                XMemberFeatureCall callToDependency = XbaseFactory.eINSTANCE.createXMemberFeatureCall();
                callToDependency.setMemberCallTarget((XExpression)EcoreUtil2.clone((EObject)callToThis));
                callToDependency.setFeature(dependencyImplicitReceiver);
                if (dependencyImplicitReceiver == null) continue;
                ExtensionMethodsFeaturesProvider extensionFeatureProvider = (ExtensionMethodsFeaturesProvider)((Object)this.extensionMethodsFeaturesProvider.get());
                extensionFeatureProvider.setContext(XtendField2.getType());
                this.insertDescriptionProviders((IFeaturesForTypeProvider)extensionFeatureProvider, currentContext, (XExpression)callToDependency, result);
            }
            JvmGenericType type2 = this.xtend2jvmAssociations.getInferredType(xtendClass);
            JvmParameterizedTypeReference typeRef = this.typeReferences.createTypeRef((JvmType)type2, new JvmTypeReference[0]);
            ExtensionMethodsFeaturesProvider featureProvider = (ExtensionMethodsFeaturesProvider)((Object)this.extensionMethodsFeaturesProvider.get());
            featureProvider.setContext((JvmTypeReference)typeRef);
            this.insertDescriptionProviders((IFeaturesForTypeProvider)featureProvider, currentContext, (XExpression)callToThis, result);
        }
        return result;
    }

    protected JvmIdentifiableElement findImplicitReceiverFor(XtendField XtendField2) {
        Set elements = this.xtend2jvmAssociations.getJvmElements(XtendField2);
        if (!elements.isEmpty()) {
            JvmIdentifiableElement field = (JvmIdentifiableElement)elements.iterator().next();
            return field;
        }
        return null;
    }

    protected Iterable<XtendField> getExtensionDependencies(XtendClass context) {
        return Iterables.filter((Iterable)EcoreUtil2.typeSelect(context.getMembers(), XtendField.class), (Predicate)new Predicate<XtendField>(){

            public boolean apply(XtendField input) {
                return input.isExtension();
            }
        });
    }

    protected void insertDescriptionProviders(IFeaturesForTypeProvider staticProvider, JvmDeclaredType currentContext, XExpression implicitReceiver, List<IJvmFeatureDescriptionProvider> result) {
        DefaultJvmFeatureDescriptionProvider defaultProvider = this.newDefaultFeatureDescProvider();
        defaultProvider.setFeaturesForTypeProvider(staticProvider);
        XFeatureCallSugarDescriptionProvider sugaredProvider = this.newSugarDescriptionProvider();
        sugaredProvider.setFeaturesForTypeProvider(staticProvider);
        defaultProvider.setContextType(currentContext);
        defaultProvider.setImplicitReceiver(implicitReceiver);
        sugaredProvider.setContextType(currentContext);
        sugaredProvider.setImplicitReceiver(implicitReceiver);
        result.add(2, (IJvmFeatureDescriptionProvider)defaultProvider);
        result.add(3, (IJvmFeatureDescriptionProvider)sugaredProvider);
    }

    protected IValidatedEObjectDescription createLocalVarDescription(XtendParameter jvmFormalParameter) {
        return new LocalVarDescription(QualifiedName.create((String[])new String[]{jvmFormalParameter.getName()}), (JvmIdentifiableElement)jvmFormalParameter);
    }

    protected JvmDeclaredType getContextType(EObject call) {
        if (call == null) {
            return null;
        }
        XtendClass containerClass = (XtendClass)EcoreUtil2.getContainerOfType((EObject)call, XtendClass.class);
        if (containerClass != null) {
            return this.xtend2jvmAssociations.getInferredType(containerClass);
        }
        return super.getContextType(call);
    }
}

