/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.handler;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class ValidateActionHandler
extends AbstractHandler {
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private MarkerTypeProvider markerTypeProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor(event);
        if (xtextEditor != null) {
            MarkerIssueProcessor markerIssueProcessor = new MarkerIssueProcessor(xtextEditor.getResource(), this.markerCreator, this.markerTypeProvider);
            IXtextDocument xtextDocument = xtextEditor.getDocument();
            ValidationJob validationJob = new ValidationJob(this.resourceValidator, xtextDocument, markerIssueProcessor, CheckMode.ALL);
            validationJob.schedule();
        }
        return this;
    }
}

