/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDelayedInputChangeProvider;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.hover.html.IXtextBrowserInformationControl;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverConfiguration;
import org.eclipse.xtext.xbase.ui.hover.XbaseInformationControlInput;

public class XbaseInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IDelayedInputChangeProvider,
IXtextBrowserInformationControl {
    private XtextBrowserInformationControlInput fInput;
    private Composite detailPaneComposite;
    private XbaseHoverConfiguration xbaseHoverConfiguration;
    private EmbeddedEditorModelAccess embeddedEditorAccess;
    private HoverEditedResourceProvider resourceProvider;
    private EmbeddedEditor embeddedEditor;
    private SashForm fSashForm;
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 50;
    private static boolean fgIsAvailable = false;
    private static boolean fgAvailabilityChecked = false;
    private static Point fgScrollBarSize;
    private Browser fBrowser;
    private boolean fBrowserHasContent;
    private TextLayout fTextLayout;
    private TextStyle fBoldStyle;
    private boolean fCompleted = false;
    private IInputChangedListener fDelayedInputChangeListener;
    private ListenerList fInputChangeListeners = new ListenerList(1);
    private final String fSymbolicFontName;

    public XbaseInformationControl(Shell parent, String symbolicFontName, String statusFieldText, XbaseHoverConfiguration xbaseHoverConfiguration) {
        super(parent, statusFieldText);
        this.fSymbolicFontName = symbolicFontName;
        this.xbaseHoverConfiguration = xbaseHoverConfiguration;
        this.create();
    }

    public XbaseInformationControl(Shell parent, String symbolicFontName, ToolBarManager toolBarManager, XbaseHoverConfiguration xbaseHoverConfiguration) {
        super(parent, toolBarManager);
        this.fSymbolicFontName = symbolicFontName;
        this.xbaseHoverConfiguration = xbaseHoverConfiguration;
        this.create();
    }

    protected void createContent(Composite parent) {
        this.fSashForm = new SashForm(parent, parent.getStyle());
        this.fSashForm.setOrientation(512);
        this.fBrowser = new Browser((Composite)this.fSashForm, 0);
        this.fBrowser.setJavascriptEnabled(false);
        Display display = this.getShell().getDisplay();
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                XbaseInformationControl.this.fCompleted = true;
            }
        });
        this.fBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.required = true;
            }
        });
        this.fSashForm.setMenu(new Menu((Decorations)this.getShell(), 0));
        this.detailPaneComposite = SWTFactory.createComposite((Composite)this.fSashForm, (int)1, (int)1, (int)1808);
        Layout layout = this.detailPaneComposite.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gl = (GridLayout)layout;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.numColumns = 1;
        }
        this.detailPaneComposite.setForeground(display.getSystemColor(28));
        this.detailPaneComposite.setBackground(display.getSystemColor(29));
        this.resourceProvider = new HoverEditedResourceProvider();
        this.embeddedEditor = this.xbaseHoverConfiguration.getEditorFactory().newEditor((IEditedResourceProvider)this.resourceProvider).readOnly().processIssuesBy(new IValidationIssueProcessor(){

            public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
            }
        }).withParent(this.detailPaneComposite);
        Control viewerControl = this.embeddedEditor.getViewer().getControl();
        viewerControl.setBackground(display.getSystemColor(29));
        viewerControl.setForeground(display.getSystemColor(28));
        this.embeddedEditorAccess = this.embeddedEditor.createPartialEditor("", "a", "", false);
        this.embeddedEditor.getDocument().setValidationJob(null);
        this.createTextLayout();
    }

    public void setInput(Object input) {
        XbaseInformationControlInput castedInput;
        Assert.isLegal((input == null || input instanceof String || input instanceof XtextBrowserInformationControlInput ? 1 : 0) != 0);
        if (input instanceof String) {
            this.setInformation((String)input);
            return;
        }
        if (input instanceof XtextBrowserInformationControlInput) {
            this.fInput = (XtextBrowserInformationControlInput)input;
        }
        String content = null;
        if (this.fInput != null) {
            content = this.fInput.getHtml();
        }
        boolean bl = this.fBrowserHasContent = content != null && content.length() > 0;
        if (!this.fBrowserHasContent) {
            content = "<html><body ></html>";
        }
        boolean RTL = (this.getShell().getStyle() & 0x4000000) != 0;
        boolean resizable = this.isResizable();
        String[] styles = null;
        styles = RTL && resizable ? new String[]{"direction:rtl;", "overflow:scroll;", "word-wrap:break-word;"} : (RTL && !resizable ? new String[]{"direction:rtl;", "overflow:hidden;", "word-wrap:break-word;"} : (!resizable ? new String[]{"overflow:hidden;"} : new String[]{"overflow:scroll;"}));
        StringBuffer buffer = new StringBuffer(content);
        HTMLPrinter.insertStyles((StringBuffer)buffer, (String[])styles);
        content = buffer.toString();
        this.fCompleted = false;
        this.fBrowser.setText(content);
        String unsugaredExpression = "";
        if (this.fInput != null && this.fInput instanceof XbaseInformationControlInput && (unsugaredExpression = (castedInput = (XbaseInformationControlInput)this.fInput).getUnsugaredExpression()) != null && unsugaredExpression.length() > 0) {
            EObject element = this.fInput.getElement();
            if (element == null || element.eResource() == null || element.eResource().getResourceSet() == null) {
                return;
            }
            this.resourceProvider.setContext(((XtextResourceSet)element.eResource().getResourceSet()).getClasspathURIContext());
            this.embeddedEditorAccess.updateModel("", "a", "");
            this.embeddedEditorAccess.updateModel(castedInput.getPrefix(), unsugaredExpression, castedInput.getSuffix());
        }
        if (unsugaredExpression != null && unsugaredExpression.length() > 0) {
            this.fSashForm.setWeights(new int[]{7, 3});
        } else {
            int[] nArray = new int[2];
            nArray[0] = 10;
            this.fSashForm.setWeights(nArray);
        }
        Object[] listeners = this.fInputChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IInputChangedListener)listeners[i]).inputChanged((Object)this.fInput);
            ++i;
        }
    }

    public Point computeSizeHint() {
        String unsugaredExpression;
        String text;
        Point sizeConstraints = this.getSizeConstraints();
        Rectangle trim = this.computeTrim();
        int height = trim.height;
        TextPresentation presentation = new TextPresentation();
        HTML2TextReader reader = new HTML2TextReader((Reader)new StringReader(this.fInput.getHtml()), presentation);
        try {
            text = reader.getString();
        }
        catch (IOException e) {
            text = "";
        }
        Rectangle bounds = this.computeBounds(sizeConstraints, trim, presentation, text);
        int minWidth = bounds.width;
        height += bounds.height;
        if (this.fInput instanceof XbaseInformationControlInput && (unsugaredExpression = ((XbaseInformationControlInput)this.fInput).getUnsugaredExpression()) != null && unsugaredExpression.length() > 0) {
            Rectangle detailBounds = this.computeBounds(sizeConstraints, trim, null, unsugaredExpression);
            minWidth = Math.max(minWidth, detailBounds.width);
            height += detailBounds.height + 30;
        }
        height += 15;
        minWidth += 70;
        if (sizeConstraints != null) {
            if (sizeConstraints.x != -1) {
                minWidth = Math.min(sizeConstraints.x, minWidth + trim.width);
            }
            if (sizeConstraints.y != -1) {
                height = Math.min(sizeConstraints.y, height);
            }
        }
        int width = Math.max(80, minWidth);
        height = Math.max(50, height);
        return new Point(width, height);
    }

    private Rectangle computeBounds(Point sizeConstraints, Rectangle trim, TextPresentation presentation, String text) {
        this.fTextLayout.setText(text);
        this.fTextLayout.setWidth(sizeConstraints == null ? -1 : sizeConstraints.x - trim.width);
        if (presentation != null) {
            Iterator iter = presentation.getAllStyleRangeIterator();
            while (iter.hasNext()) {
                StyleRange sr = (StyleRange)iter.next();
                if (sr.fontStyle != 1) continue;
                this.fTextLayout.setStyle(this.fBoldStyle, sr.start, sr.start + sr.length - 1);
            }
        }
        Rectangle bounds = this.fTextLayout.getBounds();
        int lineCount = this.fTextLayout.getLineCount();
        int textWidth = 0;
        int i = 0;
        while (i < lineCount) {
            Rectangle rect = this.fTextLayout.getLineBounds(i);
            int lineWidth = rect.x + rect.width;
            if (i == 0) {
                lineWidth += this.fInput.getLeadingImageWidth();
            }
            textWidth = Math.max(textWidth, lineWidth);
            ++i;
        }
        bounds.width = textWidth;
        this.fTextLayout.setText("");
        return bounds;
    }

    public XtextBrowserInformationControlInput getInput() {
        return this.fInput;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        if (this.fSymbolicFontName == null) {
            return null;
        }
        GC gc = new GC((Drawable)this.fBrowser);
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        gc.setFont(font);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public static boolean isAvailable(Composite parent) {
        if (!fgAvailabilityChecked) {
            try {
                try {
                    Browser browser = new Browser(parent, 0);
                    browser.dispose();
                    fgIsAvailable = true;
                    Slider sliderV = new Slider(parent, 512);
                    Slider sliderH = new Slider(parent, 256);
                    int width = sliderV.computeSize((int)-1, (int)-1).x;
                    int height = sliderH.computeSize((int)-1, (int)-1).y;
                    fgScrollBarSize = new Point(width, height);
                    sliderV.dispose();
                    sliderH.dispose();
                }
                catch (SWTError er) {
                    fgIsAvailable = false;
                    fgAvailabilityChecked = true;
                }
            }
            finally {
                fgAvailabilityChecked = true;
            }
        }
        return fgIsAvailable;
    }

    public void setVisible(boolean visible) {
        Shell shell = this.getShell();
        if (shell.isVisible() == visible) {
            return;
        }
        if (!visible) {
            super.setVisible(false);
            this.setInput(null);
            return;
        }
        Display display = shell.getDisplay();
        display.timerExec(100, new Runnable(){

            public void run() {
                XbaseInformationControl.this.fCompleted = true;
            }
        });
        while (!this.fCompleted) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if ("win32".equals(SWT.getPlatform())) {
            shell.moveAbove(null);
        }
        super.setVisible(true);
    }

    public void setSize(int width, int height) {
        this.fSashForm.setRedraw(false);
        try {
            super.setSize(width, height);
        }
        finally {
            this.fSashForm.setRedraw(true);
        }
    }

    private void createTextLayout() {
        this.fTextLayout = new TextLayout((Device)this.fSashForm.getDisplay());
        String symbolicFontName = this.fSymbolicFontName == null ? "org.eclipse.jface.dialogfont" : this.fSymbolicFontName;
        Font font = JFaceResources.getFont((String)symbolicFontName);
        this.fTextLayout.setFont(font);
        this.fTextLayout.setWidth(-1);
        font = JFaceResources.getFontRegistry().getBold(symbolicFontName);
        this.fBoldStyle = new TextStyle(font, null, null);
        this.fTextLayout.setText("    ");
        int tabWidth = this.fTextLayout.getBounds().width;
        this.fTextLayout.setTabs(new int[]{tabWidth});
        this.fTextLayout.setText("");
    }

    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        if (this.isResizable()) {
            boolean RTL;
            boolean bl = RTL = (this.getShell().getStyle() & 0x4000000) != 0;
            if (RTL) {
                trim.x -= XbaseInformationControl.fgScrollBarSize.x;
            }
            trim.width += XbaseInformationControl.fgScrollBarSize.x;
            trim.height += XbaseInformationControl.fgScrollBarSize.y;
        }
        return trim;
    }

    public void addLocationListener(LocationListener listener) {
        this.fBrowser.addLocationListener(listener);
    }

    public boolean hasContents() {
        return this.fBrowserHasContent;
    }

    public void addInputChangeListener(IInputChangedListener inputChangeListener) {
        Assert.isNotNull((Object)inputChangeListener);
        this.fInputChangeListeners.add((Object)inputChangeListener);
    }

    public void removeInputChangeListener(IInputChangedListener inputChangeListener) {
        this.fInputChangeListeners.remove((Object)inputChangeListener);
    }

    public void setDelayedInputChangeListener(IInputChangedListener inputChangeListener) {
        this.fDelayedInputChangeListener = inputChangeListener;
    }

    public boolean hasDelayedInputChangeListener() {
        return this.fDelayedInputChangeListener != null;
    }

    public void notifyDelayedInputChange(Object newInput) {
        if (this.fDelayedInputChangeListener != null) {
            this.fDelayedInputChangeListener.inputChanged(newInput);
        }
    }

    public String toString() {
        String style = (this.getShell().getStyle() & 0x10) == 0 ? "fixed" : "resizeable";
        return String.valueOf(super.toString()) + " -  style: " + style;
    }

    public class HoverEditedResourceProvider
    implements IEditedResourceProvider {
        private XtextResourceSet xtextResourceSet;

        public XtextResource createResource() {
            String SYNTHETIC_SCHEME = "synthetic";
            this.xtextResourceSet = new XtextResourceSet();
            if (XbaseInformationControl.this.fInput != null) {
                XtextResourceSet resourceSet = (XtextResourceSet)XbaseInformationControl.this.fInput.getElement().eResource().getResourceSet();
                this.xtextResourceSet.setClasspathURIContext(resourceSet.getClasspathURIContext());
            }
            URI uri = URI.createURI((String)("synthetic:/unsugaredExpression." + XbaseInformationControl.this.xbaseHoverConfiguration.getFileExtension()));
            XtextResource resource = (XtextResource)this.xtextResourceSet.createResource(uri);
            this.xtextResourceSet.getResources().add((Object)resource);
            return resource;
        }

        public void setContext(Object object) {
            this.xtextResourceSet.setClasspathURIContext(object);
        }
    }
}

