/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.releng;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xtext.ui.wizard.releng.DialogCatalog;
import org.eclipse.xtext.xtext.ui.wizard.releng.Messages;
import org.eclipse.xtext.xtext.ui.wizard.releng.P2DirectorLaunch;
import org.eclipse.xtext.xtext.ui.wizard.releng.ProjectInfoBinder;
import org.eclipse.xtext.xtext.ui.wizard.releng.RelengProjectInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardNewRelengProjectCreationPage
extends WizardPage {
    private final IStructuredSelection selection;
    private final RelengProjectInfo projectInfo;
    private DataBindingContext dbc;

    public WizardNewRelengProjectCreationPage(String pageName, IStructuredSelection selection, RelengProjectInfo projectInfo) {
        super(pageName);
        this.selection = selection;
        this.projectInfo = projectInfo;
        this.setTitle(Messages.WizardNewRelengProjectCreationPage_pageTitle);
        this.setDescription(Messages.WizardNewRelengProjectCreationPage_pageDescr);
    }

    public void createControl(Composite parent) {
        Composite pageMain = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        pageMain.setLayout((Layout)new GridLayout(3, false));
        Text featureProjectField = this.createFeatureSelectionControl(pageMain);
        Group prjGroup = this.createTreeRowGroup(pageMain, Messages.WizardNewRelengProjectCreationPage_prjGroupLbl, 10);
        Text prjField = this.createProjectControl((Composite)prjGroup);
        Text sitePrjField = this.createSiteFeatureControl((Composite)prjGroup);
        Group buckyGroup = this.createTreeRowGroup(pageMain, Messages.WizardNewRelengProjectCreationPage_buckyGroupLbl, 0);
        Text buckyField = this.createBuckyControl((Composite)buckyGroup);
        this.createInstallationText((Composite)buckyGroup, Messages.WizardNewRelengProjectCreationPage_buckminsteInstallText, buckyField);
        ListViewer testsList = this.createTestsControl((Composite)buckyGroup);
        this.dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        ProjectInfoBinder binder = new ProjectInfoBinder(this.dbc, this.projectInfo);
        IObservableValue featPrjObserv = binder.bindFeatureProjectField((Control)featureProjectField);
        binder.bindProjectField(prjField, featPrjObserv);
        binder.bindSiteProjectField(sitePrjField, featPrjObserv);
        binder.bindBuckyLocationField(buckyField);
        binder.bindTestLaunchers((StructuredViewer)testsList);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)pageMain);
        Dialog.applyDialogFont((Control)this.getControl());
        this.loadInitialValues(this.selection, featureProjectField, buckyField);
    }

    private Group createTreeRowGroup(Composite pageMain, String name, int vertIdent) {
        Group prjGroup = new Group(pageMain, 0);
        prjGroup.setFont(pageMain.getFont());
        prjGroup.setText(name);
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.verticalIndent = vertIdent;
        layoutData.horizontalSpan = 3;
        prjGroup.setLayoutData((Object)layoutData);
        prjGroup.setLayout((Layout)new GridLayout(3, false));
        return prjGroup;
    }

    private Text createFeatureSelectionControl(final Composite parent) {
        Triple<Label, Text, Button> selectionControl = this.createSelectionControl(parent, Messages.WizardNewRelengProjectCreationPage_featFieldLbl);
        final Text featureProjectField = (Text)selectionControl.getSecond();
        featureProjectField.setEditable(true);
        ((Button)selectionControl.getThird()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAcceptor<IProject> acceptor = new IAcceptor<IProject>(){

                    public void accept(IProject project) {
                        if (project != null) {
                            featureProjectField.setText(project.getName());
                        }
                    }
                };
                DialogCatalog.openFeatureSelectionDialog(parent.getShell(), acceptor);
            }
        });
        return featureProjectField;
    }

    private Text createProjectControl(Composite parent) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText(Messages.WizardNewRelengProjectCreationPage_relPrjFieldLbl);
        projectLabel.setFont(parent.getFont());
        Text relengProjectField = new Text(parent, 2048);
        GridData grData = new GridData(768);
        grData.horizontalSpan = 2;
        relengProjectField.setLayoutData((Object)grData);
        relengProjectField.setFont(parent.getFont());
        relengProjectField.setEnabled(false);
        return relengProjectField;
    }

    private Text createSiteFeatureControl(Composite parent) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText(Messages.WizardNewRelengProjectCreationPage_sitePrjFieldLbl);
        projectLabel.setFont(parent.getFont());
        projectLabel.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2048);
        GridData grData = new GridData(768);
        grData.horizontalSpan = 2;
        text.setLayoutData((Object)grData);
        text.setFont(parent.getFont());
        text.setEnabled(false);
        return text;
    }

    private Link createInstallationText(final Composite parent, String text, final Text buckyField) {
        Link link = new Link(parent, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        link.setLayoutData((Object)layoutData);
        link.setText(text);
        link.setToolTipText("Click here to install buckminster headless from http://download.eclipse.org/tools/buckminster/headless-4.2/");
        link.setFont(parent.getFont());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String destinationPath;
                super.widgetSelected(e);
                final ILaunchConfigurationType configurationType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.pde.ui.RuntimeWorkbench");
                if (!Strings.isNullOrEmpty((String)buckyField.getText())) {
                    destinationPath = buckyField.getText();
                } else {
                    destinationPath = P2DirectorLaunch.DESTINATION_JAVA;
                    buckyField.setText(destinationPath);
                }
                try {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Installing Buckminster", (int)200);
                            try {
                                ILaunchConfigurationWorkingCopy workingCopy = configurationType.newInstance(null, "Install buckminster headless");
                                P2DirectorLaunch.setupLaunchConfiguration(workingCopy, destinationPath);
                                ILaunch launch = workingCopy.launch("run", (IProgressMonitor)localmonitor.newChild(20));
                                while (!localmonitor.isCanceled() && !launch.isTerminated()) {
                                    localmonitor.worked(5);
                                    localmonitor.setWorkRemaining(180);
                                    Thread.sleep(200L);
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    public void run() {
                                        WizardNewRelengProjectCreationPage.this.dbc.updateModels();
                                    }
                                });
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    new ProgressMonitorDialog(parent.getShell()).run(true, true, runnable);
                }
                catch (InvocationTargetException e2) {
                    e2.printStackTrace();
                }
                catch (InterruptedException e3) {
                    e3.printStackTrace();
                }
            }
        });
        return link;
    }

    private Text createBuckyControl(final Composite parent) {
        Triple<Label, Text, Button> selectionControl = this.createSelectionControl(parent, Messages.WizardNewRelengProjectCreationPage_buckyInstallFieldLbl);
        final Text buckyField = (Text)selectionControl.getSecond();
        buckyField.setEditable(true);
        ControlDecoration dec = new ControlDecoration((Control)buckyField, 17408, parent);
        FieldDecoration infoIndication = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        dec.setImage(infoIndication.getImage());
        dec.setDescriptionText(NLS.bind((String)Messages.WizardNewRelengProjectCreationPage_buckyControlInfo, (Object)"build.ant"));
        Button button = (Button)selectionControl.getThird();
        button.setText(Messages.WizardNewRelengProjectCreationPage_browseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String folder = DialogCatalog.openOSFolderSelectionDialog(parent.getShell());
                if (folder != null) {
                    buckyField.setText(folder);
                }
            }
        });
        return buckyField;
    }

    private ListViewer createTestsControl(final Composite parent) {
        Label projectLabel = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        projectLabel.setLayoutData((Object)gridData);
        projectLabel.setText(Messages.WizardNewRelengProjectCreationPage_testsListLbl);
        projectLabel.setFont(parent.getFont());
        final ListViewer listViewer = new ListViewer(parent, 2816);
        listViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        listViewer.getControl().setLayoutData((Object)new GridData(1808));
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new RowLayout(512));
        Button button = new Button(buttons, 8);
        button.setFont(parent.getFont());
        button.setText(Messages.WizardNewRelengProjectCreationPage_addTestButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile testLauncherFile = DialogCatalog.openJunitLaunchSelectionDialog(parent.getShell());
                if (testLauncherFile != null) {
                    listViewer.add((Object)testLauncherFile);
                    IObservableList input = (IObservableList)listViewer.getInput();
                    input.add((Object)testLauncherFile);
                    listViewer.setInput((Object)input);
                }
            }
        });
        Button remove = new Button(buttons, 8);
        remove.setFont(parent.getFont());
        remove.setText(Messages.WizardNewRelengProjectCreationPage_removeTestButton);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection iSelection = listViewer.getSelection();
                if (!iSelection.isEmpty()) {
                    List list;
                    IObservableList input = (IObservableList)listViewer.getInput();
                    if (input.containsAll((Collection)(list = ((IStructuredSelection)iSelection).toList()))) {
                        input.removeAll((Collection)list);
                    }
                    listViewer.setInput((Object)input);
                }
            }
        });
        return listViewer;
    }

    private Triple<Label, Text, Button> createSelectionControl(Composite composite, String controlLabel) {
        Label projectLabel = new Label(composite, 0);
        projectLabel.setText(controlLabel);
        projectLabel.setFont(composite.getFont());
        Text text = new Text(composite, 2048);
        GridData grData = new GridData(768);
        text.setLayoutData((Object)grData);
        text.setFont(composite.getFont());
        text.setEditable(false);
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(Messages.WizardNewRelengProjectCreationPage_selectButton);
        return Tuples.create((Object)projectLabel, (Object)text, (Object)button);
    }

    private String calculateFeatureSelection(IStructuredSelection structSelection) {
        Object firstElement;
        String initialSelection = null;
        if (structSelection != null && (firstElement = structSelection.getFirstElement()) instanceof IProject) {
            IProject project = (IProject)firstElement;
            initialSelection = project.getName();
        }
        return initialSelection;
    }

    private void loadInitialValues(IStructuredSelection structSelection, Text featureProjectField, Text buckyField) {
        String initialValue = this.calculateFeatureSelection(structSelection);
        if (initialValue != null) {
            featureProjectField.setText(initialValue);
        }
        buckyField.setText(P2DirectorLaunch.DESTINATION_JAVA);
    }
}

