/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedOperations;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.StandardTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@NonNullByDefault
public class OverrideHelper {
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private OverrideTester overrideTester;

    @Nullable
    public LightweightTypeReference getReturnTypeOfOverriddenOperation(JvmOperation operation, ITypeReferenceOwner owner, IVisibilityHelper visibilityHelper) {
        OwnedConverter converter;
        TypeParameterSubstitutor<?> substitutor;
        if (operation.getVisibility() == JvmVisibility.PRIVATE || !InferredTypeIndicator.isInferred(operation.getReturnType())) {
            return null;
        }
        ParameterizedTypeReference declaringType = new ParameterizedTypeReference(owner, (JvmType)operation.getDeclaringType());
        JvmOperation overriddenOperation = this.findOverriddenOperation(operation, declaringType, substitutor = this.createSubstitutor(owner, declaringType), converter = new OwnedConverter(owner), visibilityHelper);
        if (overriddenOperation != null) {
            return substitutor.substitute(converter.toLightweightReference(overriddenOperation.getReturnType()));
        }
        return null;
    }

    @Nullable
    public LightweightTypeReference getReturnTypeOfOverriddenOperation(JvmOperation operation, LightweightTypeReference context) {
        if (operation.getVisibility() == JvmVisibility.PRIVATE || !InferredTypeIndicator.isInferred(operation.getReturnType())) {
            return null;
        }
        BottomResolvedOperation resolvedOperation = new BottomResolvedOperation(operation, context, this.overrideTester);
        List<IResolvedOperation> overriddenMethods = resolvedOperation.getOverriddenAndImplementedMethods();
        if (overriddenMethods.isEmpty()) {
            return null;
        }
        LightweightTypeReference result = overriddenMethods.get(0).getResolvedReturnType();
        return result;
    }

    @Nullable
    protected JvmOperation findOverriddenOperation(JvmOperation operation, LightweightTypeReference declaringType, TypeParameterSubstitutor<?> substitutor, OwnedConverter converter, IVisibilityHelper visibilityHelper) {
        int parameterSize = operation.getParameters().size();
        List<LightweightTypeReference> superTypes = declaringType.getSuperTypes();
        for (LightweightTypeReference superType : superTypes) {
            JvmDeclaredType declaredSuperType = (JvmDeclaredType)superType.getType();
            if (declaredSuperType == null) continue;
            Iterable equallyNamedFeatures = declaredSuperType.findAllFeaturesByName(operation.getSimpleName());
            for (JvmFeature feature : equallyNamedFeatures) {
                JvmOperation candidate;
                if (!(feature instanceof JvmOperation) || parameterSize != (candidate = (JvmOperation)feature).getParameters().size() || !visibilityHelper.isVisible((JvmMember)feature)) continue;
                boolean matchesSignature = true;
                int i = 0;
                while (i < parameterSize && matchesSignature) {
                    JvmFormalParameter candidateParameter;
                    LightweightTypeReference candidateParameterType;
                    JvmFormalParameter parameter = (JvmFormalParameter)operation.getParameters().get(i);
                    String identifier = parameter.getParameterType().getIdentifier();
                    if (!identifier.equals((candidateParameterType = substitutor.substitute(converter.toLightweightReference((candidateParameter = (JvmFormalParameter)candidate.getParameters().get(i)).getParameterType()))).getJavaIdentifier())) {
                        matchesSignature = false;
                    }
                    ++i;
                }
                if (!matchesSignature) continue;
                return candidate;
            }
        }
        return null;
    }

    protected TypeParameterSubstitutor<?> createSubstitutor(ITypeReferenceOwner owner, LightweightTypeReference declaringType) {
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> parameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(declaringType);
        StandardTypeParameterSubstitutor substitutor = new StandardTypeParameterSubstitutor(parameterMapping, owner);
        return substitutor;
    }

    @Nullable
    public JvmOperation findOverriddenOperation(JvmOperation operation) {
        if (operation.getVisibility() == JvmVisibility.PRIVATE) {
            return null;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, operation.eResource().getResourceSet());
        ParameterizedTypeReference declaringType = new ParameterizedTypeReference(owner, (JvmType)operation.getDeclaringType());
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor(owner, declaringType);
        OwnedConverter converter = new OwnedConverter(owner);
        return this.findOverriddenOperation(operation, declaringType, substitutor, converter, new ContextualVisibilityHelper(this.visibilityHelper, declaringType));
    }

    public ResolvedOperations getResolvedOperations(JvmDeclaredType type) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, type.eResource().getResourceSet());
        ParameterizedTypeReference contextType = new ParameterizedTypeReference(owner, (JvmType)type);
        if (type instanceof JvmGenericType) {
            for (JvmTypeParameter typeParameter : ((JvmGenericType)type).getTypeParameters()) {
                contextType.addTypeArgument(new ParameterizedTypeReference(owner, (JvmType)typeParameter));
            }
        }
        return this.getResolvedOperations(contextType);
    }

    public ResolvedOperations getResolvedOperations(JvmTypeReference contextType) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, contextType.eResource().getResourceSet());
        return this.getResolvedOperations(new OwnedConverter(owner).toLightweightReference(contextType));
    }

    public ResolvedOperations getResolvedOperations(LightweightTypeReference contextType) {
        return new ResolvedOperations(contextType, this.overrideTester);
    }

    public List<JvmOperation> getAllOperations(JvmDeclaredType type, ITypeReferenceOwner owner, IVisibilityHelper visibilityHelper) {
        ParameterizedTypeReference declaringType = new ParameterizedTypeReference(owner, (JvmType)type);
        return this.getAllOperations(declaringType, visibilityHelper);
    }

    public List<JvmOperation> getAllOperations(LightweightTypeReference declaringType, IVisibilityHelper visibilityHelper) {
        if (!(declaringType.getType() instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        Iterable allFeatures = ((JvmDeclaredType)declaringType.getType()).getAllFeatures();
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor(declaringType.getOwner(), declaringType);
        OwnedConverter converter = new OwnedConverter(declaringType.getOwner());
        ArrayList result = Lists.newArrayList();
        HashSet signatures = Sets.newHashSet();
        for (JvmFeature feature : allFeatures) {
            JvmOperation operation;
            if (!(feature instanceof JvmOperation) || !visibilityHelper.isVisible((JvmMember)(operation = (JvmOperation)feature))) continue;
            if (!operation.isStatic()) {
                EList parameters = operation.getParameters();
                StringBuilder signature = new StringBuilder(operation.getSimpleName());
                if (parameters.isEmpty()) {
                    signature.append("()");
                } else {
                    signature.append("(");
                    for (JvmFormalParameter parameter : parameters) {
                        JvmTypeReference pType = parameter.getParameterType();
                        if (pType != null) {
                            LightweightTypeReference parameterType = substitutor.substitute(converter.toLightweightReference(pType));
                            signature.append(parameterType.getJavaIdentifier());
                        } else {
                            signature.append("<Unknown>");
                        }
                        signature.append(",");
                    }
                    signature.replace(signature.length() - 1, signature.length(), ")");
                }
                if (!signatures.add(signature.toString())) continue;
                result.add(operation);
                continue;
            }
            result.add(operation);
        }
        return result;
    }
}

