/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import org.eclipse.xtext.xbase.lib.Pure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Pair<K, V> {
    private final K k;
    private final V v;

    @Pure
    public static <K, V> Pair<K, V> of(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    @Pure
    public Pair(K k, V v) {
        this.k = k;
        this.v = v;
    }

    @Pure
    public K getKey() {
        return this.k;
    }

    @Pure
    public V getValue() {
        return this.v;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair e = (Pair)o;
        return Objects.equal(this.k, e.getKey()) && Objects.equal(this.v, e.getValue());
    }

    public int hashCode() {
        return (this.k == null ? 0 : this.k.hashCode()) ^ (this.v == null ? 0 : this.v.hashCode());
    }

    public String toString() {
        return this.k + "->" + this.v;
    }
}

