/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractImplicitFeature;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ImplicitReceiver
extends AbstractImplicitFeature {
    public ImplicitReceiver(XAbstractFeatureCall featureCall, XAbstractFeatureCall implicit, ExpressionTypeComputationState state) {
        super(featureCall, implicit, state);
    }

    @Override
    public void applyToComputationState() {
        super.applyToComputationState();
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            XExpression target = ((XMemberFeatureCall)featureCall).getMemberCallTarget();
            if (target == null || !(target instanceof XAbstractFeatureCall)) {
                throw new IllegalStateException();
            }
            XAbstractFeatureCall targetFeatureCall = (XAbstractFeatureCall)target;
            ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
            LightweightTypeReference targetType = resolvedTypes.getActualType(targetFeatureCall.getFeature());
            if (targetType == null) {
                throw new IllegalStateException();
            }
            TypeExpectation expectation = new TypeExpectation(null, this.getState(), false);
            resolvedTypes.acceptType(targetFeatureCall, expectation, targetType.copyInto(resolvedTypes.getReferenceOwner()), false, ConformanceHint.UNCHECKED);
        }
    }

    @Override
    public void applyToModel() {
        this.getOwner().setImplicitReceiver(this.getFeatureCall());
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        if (!this.getState().isInstanceContext()) {
            JvmIdentifiableElement implicitFeature = this.getFeature();
            if (implicitFeature instanceof JvmType && !this.getState().isInstanceContext()) {
                JvmIdentifiableElement feature = this.getState().getResolvedTypes().getLinkedFeature(this.getOwner());
                if (feature == null || feature.eIsProxy() || !(feature instanceof JvmFeature)) {
                    return true;
                }
                String typeName = this.getFeatureTypeName(feature);
                String message = String.format("Cannot make a static reference to the non-static %s %s from the type %s", typeName, feature.getSimpleName(), this.getFeature().getSimpleName());
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, (EObject)this.getOwner(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
            if (implicitFeature instanceof JvmFeature && !((JvmFeature)implicitFeature).isStatic()) {
                JvmIdentifiableElement feature = this.getState().getResolvedTypes().getLinkedFeature(this.getOwner());
                if (feature == null || feature.eIsProxy() || !(feature instanceof JvmFeature)) {
                    return true;
                }
                String message = String.format("Cannot make an implicit static reference to the non-static extension %s", feature.getSimpleName());
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, (EObject)this.getOwner(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
        }
        return super.validate(result);
    }

    protected String getFeatureTypeName(JvmIdentifiableElement feature) {
        if (feature instanceof JvmFormalParameter) {
            return "parameter";
        }
        if (feature instanceof XVariableDeclaration) {
            return "local variable";
        }
        if (feature instanceof JvmField) {
            return "field";
        }
        if (feature instanceof JvmOperation) {
            return "method";
        }
        if (feature instanceof JvmConstructor) {
            return "constructor";
        }
        throw new IllegalStateException();
    }
}

