/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ArrayTypeReference
extends LightweightTypeReference {
    private LightweightTypeReference component;

    public ArrayTypeReference(ITypeReferenceOwner owner, LightweightTypeReference component) {
        super(owner);
        this.component = (LightweightTypeReference)Preconditions.checkNotNull((Object)component, (Object)"component");
        if (component.isAny()) {
            throw new IllegalArgumentException("component is invalid: type <any> is not allowed");
        }
        if (component.isWildcard()) {
            throw new IllegalArgumentException("component is invalid: " + component);
        }
        if (!component.isOwnedBy(owner)) {
            throw new IllegalArgumentException("component is not valid in current context");
        }
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmGenericArrayTypeReference result = this.getTypesFactory().createJvmGenericArrayTypeReference();
        result.setComponentType(this.component.toTypeReference());
        return result;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        return this.component.isVisible(visibilityHelper);
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        JvmGenericArrayTypeReference result = this.getTypesFactory().createJvmGenericArrayTypeReference();
        result.setComponentType(this.component.toJavaCompliantTypeReference(visibilityHelper));
        return result;
    }

    public JvmArrayType getType() {
        JvmType componentType = this.component.getType();
        if (componentType instanceof JvmComponentType) {
            return (JvmArrayType)Preconditions.checkNotNull((Object)((JvmComponentType)componentType).getArrayType());
        }
        throw new IllegalStateException("component type seems to be invalid");
    }

    @Override
    public boolean isUnknown() {
        return this.component.isUnknown();
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        List<LightweightTypeReference> componentSuperTypes = this.component.getSuperTypes(substitutor);
        if (!componentSuperTypes.isEmpty()) {
            ArrayList result = Lists.newArrayListWithCapacity((int)componentSuperTypes.size());
            for (LightweightTypeReference componentSuperType : componentSuperTypes) {
                result.add(new ArrayTypeReference(this.getOwner(), componentSuperType));
            }
            return result;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)2);
        result.add(new ParameterizedTypeReference(this.getOwner(), this.findNonNullType(Cloneable.class)));
        result.add(new ParameterizedTypeReference(this.getOwner(), this.findNonNullType(Serializable.class)));
        return result;
    }

    @Override
    @Nullable
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (rawType instanceof JvmArrayType) {
            JvmComponentType rawComponentType = ((JvmArrayType)rawType).getComponentType();
            LightweightTypeReference result = this.component.getSuperType((JvmType)rawComponentType);
            if (result == null) {
                return null;
            }
            return new ArrayTypeReference(this.getOwner(), result);
        }
        String identifier = rawType.getIdentifier();
        if (Cloneable.class.getCanonicalName().equals(identifier) || Serializable.class.getCanonicalName().equals(identifier) || Object.class.getCanonicalName().equals(identifier)) {
            return new ParameterizedTypeReference(this.getOwner(), rawType);
        }
        return null;
    }

    @Override
    public boolean isResolved() {
        return this.component.isResolved();
    }

    @Override
    protected boolean isRawType(Set<JvmType> seenTypes) {
        return this.component.isRawType(seenTypes);
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        return super.isOwnedBy(owner) && this.component.isOwnedBy(owner);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ParameterizedTypeReference tryConvertToListType() {
        ArrayTypes arrayTypes = this.getServices().getArrayTypes();
        return arrayTypes.convertToList(this);
    }

    @Override
    @Nullable
    public ArrayTypeReference tryConvertToArray() {
        return this;
    }

    @Override
    protected LightweightTypeReference doCopyInto(ITypeReferenceOwner owner) {
        LightweightTypeReference copiedComponent = this.component.copyInto(owner);
        return new ArrayTypeReference(owner, copiedComponent);
    }

    @Override
    public String getSimpleName() {
        return String.valueOf(this.component.getSimpleName()) + "[]";
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.component.getIdentifier()) + "[]";
    }

    @Override
    public String getJavaIdentifier() {
        return String.valueOf(this.component.getJavaIdentifier()) + "[]";
    }

    @Override
    public boolean isType(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.component.isType(clazz.getComponentType());
        }
        return false;
    }

    @Override
    public LightweightTypeReference getComponentType() {
        return this.component;
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitArrayTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitArrayTypeReference(this, param);
    }

    @Override
    @Nullable
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitArrayTypeReference(this);
    }

    @Override
    @Nullable
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitArrayTypeReference(this, param);
    }
}

