/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopiedResourceDescription
extends AbstractResourceDescription {
    private static final Logger log = Logger.getLogger(CopiedResourceDescription.class);
    private URI uri;
    private ImmutableList<IEObjectDescription> exported;

    public CopiedResourceDescription(IResourceDescription original) {
        this.uri = original.getURI();
        this.exported = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)original.getExportedObjects(), (Function)new Function<IEObjectDescription, IEObjectDescription>(){

            public IEObjectDescription apply(IEObjectDescription from) {
                if (from.getEObjectOrProxy().eIsProxy()) {
                    return from;
                }
                InternalEObject result = (InternalEObject)EcoreUtil.create((EClass)from.getEClass());
                result.eSetProxyURI(from.getEObjectURI());
                HashMap userData = null;
                String[] stringArray = from.getUserDataKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (userData == null) {
                        userData = Maps.newHashMapWithExpectedSize((int)2);
                    }
                    userData.put(key, from.getUserData(key));
                    ++n2;
                }
                return EObjectDescription.create((QualifiedName)from.getName(), (EObject)result, userData);
            }
        }));
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        return this.exported;
    }

    public Iterable<QualifiedName> getImportedNames() {
        IllegalStateException exception = new IllegalStateException("getImportedNames " + this.getURI());
        log.error((Object)exception, (Throwable)exception);
        return Collections.emptyList();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        IllegalStateException exception = new IllegalStateException("getReferenceDescriptions " + this.getURI());
        log.error((Object)exception, (Throwable)exception);
        return Collections.emptyList();
    }

    public URI getURI() {
        return this.uri;
    }
}

