/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit.serializer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.serializer.acceptor.DelegatingSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.util.EmfFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSequenceAcceptor
extends DelegatingSequenceAcceptor {
    protected static final int COLS = 5;
    protected static final ICompositeNode NO_NODE = new CompositeNode();
    protected boolean hideHidden = false;
    protected int indentation = 0;
    protected boolean printInstantly;
    protected List<List<String>> table = Lists.newArrayList();
    protected GrammarElementTitleSwitch titles = new GrammarElementTitleSwitch().showAssignments();

    public DebugSequenceAcceptor() {
        this(null, false);
    }

    public DebugSequenceAcceptor(boolean printInstantly) {
        this(null, printInstantly);
    }

    public DebugSequenceAcceptor(ISemanticSequenceAcceptor delegate) {
        this(delegate, false);
    }

    public DebugSequenceAcceptor(ISemanticSequenceAcceptor delegate, boolean printInstantly) {
        super(delegate);
        this.printInstantly = printInstantly;
    }

    public void acceptAssignedCrossRefDatatype(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)rc), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
        super.acceptAssignedCrossRefDatatype(rc, token, value, index, node);
    }

    public void acceptAssignedCrossRefEnum(RuleCall enumRC, String token, EObject value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)enumRC), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
        super.acceptAssignedCrossRefEnum(enumRC, token, value, index, node);
    }

    public void acceptAssignedCrossRefKeyword(Keyword kw, String token, EObject value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)kw), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
        super.acceptAssignedCrossRefKeyword(kw, token, value, index, node);
    }

    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)rc), token, EmfFormatter.objPath((EObject)value), index, (INode)node);
        super.acceptAssignedCrossRefTerminal(rc, token, value, index, node);
    }

    public void acceptAssignedDatatype(RuleCall datatypeRC, String token, Object value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)datatypeRC), token, "'" + value + "'", index, (INode)node);
        super.acceptAssignedDatatype(datatypeRC, token, value, index, node);
    }

    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)enumRC), token, "'" + value + "'", index, (INode)node);
        super.acceptAssignedEnum(enumRC, token, value, index, node);
    }

    public void acceptAssignedKeyword(Keyword keyword, String token, Boolean value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), token, String.valueOf(value), index, (INode)node);
        super.acceptAssignedKeyword(keyword, token, (Object)value, index, node);
    }

    public void acceptAssignedKeyword(Keyword keyword, String token, Object value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), token, String.valueOf(value), index, (INode)node);
        super.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    public void acceptAssignedKeyword(Keyword keyword, String token, String value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), token, "'" + value + "'", index, (INode)node);
        super.acceptAssignedKeyword(keyword, token, (Object)value, index, node);
    }

    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)terminalRC), token, "'" + value + "'", index, (INode)node);
        super.acceptAssignedTerminal(terminalRC, token, value, index, node);
    }

    public void acceptComment(AbstractRule rule, String token, ILeafNode node) {
        if (!this.hideHidden) {
            this.add(this.titles.doSwitch((EObject)rule), token, "", -1, (INode)node);
        }
        super.acceptComment(rule, token, node);
    }

    public void acceptUnassignedAction(Action action) {
        this.add(this.titles.doSwitch((EObject)action), "", "", -1, (INode)NO_NODE);
        super.acceptUnassignedAction(action);
    }

    public void acceptUnassignedDatatype(RuleCall datatypeRC, String value, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)datatypeRC), "'" + value + "'", "", -1, (INode)node);
        super.acceptUnassignedDatatype(datatypeRC, value, node);
    }

    public void acceptUnassignedEnum(RuleCall enumRC, String value, ICompositeNode node) {
        this.add(this.titles.doSwitch((EObject)enumRC), "'" + value + "'", "", -1, (INode)node);
        super.acceptUnassignedEnum(enumRC, value, node);
    }

    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)keyword), "'" + token + "'", "", -1, (INode)node);
        super.acceptUnassignedKeyword(keyword, token, node);
    }

    public void acceptUnassignedTerminal(RuleCall terminalRC, String value, ILeafNode node) {
        this.add(this.titles.doSwitch((EObject)terminalRC), "'" + value + "'", "", -1, (INode)node);
        super.acceptUnassignedTerminal(terminalRC, value, node);
    }

    public void acceptWhitespace(AbstractRule rule, String token, ILeafNode node) {
        if (!this.hideHidden) {
            this.add(this.titles.doSwitch((EObject)rule), token, "", -1, (INode)node);
        }
        super.acceptWhitespace(rule, token, node);
    }

    protected void add(String grammar, String token, String value, int index, INode node) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.indentation) {
            buf.append("  ");
            ++i;
        }
        buf.append(grammar);
        ArrayList row = Lists.newArrayList();
        row.add(buf.toString());
        row.add(token);
        row.add(value);
        row.add(index < 0 ? "" : String.valueOf(index));
        row.add(node == NO_NODE ? "" : this.node2text(node));
        this.table.add(row);
        if (this.printInstantly) {
            System.out.println(Joiner.on((char)'\t').join((Iterable)row));
        }
    }

    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        this.add(String.valueOf(this.titles.doSwitch((EObject)action)) + " {", semanticChild.eClass().getName(), "", -1, (INode)node);
        ++this.indentation;
        return super.enterAssignedAction(action, semanticChild, node);
    }

    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject newCurrent, ICompositeNode node) {
        this.add(String.valueOf(this.titles.doSwitch((EObject)rc)) + " {", newCurrent.eClass().getName(), "", -1, (INode)node);
        ++this.indentation;
        return super.enterAssignedParserRuleCall(rc, newCurrent, node);
    }

    public void enterUnassignedParserRuleCall(RuleCall rc) {
        this.add(String.valueOf(this.titles.doSwitch((EObject)rc)) + " {", "", "", -1, (INode)NO_NODE);
        ++this.indentation;
        super.enterUnassignedParserRuleCall(rc);
    }

    public void finish() {
        super.finish();
    }

    public List<String> getColumn(int i) {
        ArrayList result = Lists.newArrayList();
        for (List<String> line : this.table) {
            if (line.size() <= i || line.get(i) == null || line.get(i).length() <= 0) continue;
            result.add(line.get(i));
        }
        return result;
    }

    public List<String> getList() {
        int columns = 5;
        Object[] width = new Integer[columns - 1];
        Arrays.fill(width, (Object)1);
        for (List<String> line : this.table) {
            int i = 0;
            while (i < line.size() && i < width.length) {
                width[i] = Math.max((Integer)width[i], line.get(i).length());
                ++i;
            }
        }
        String format = "%-" + Joiner.on((String)"s %-").join(width) + "s %s";
        ArrayList lines = Lists.newArrayList();
        for (List<String> line : this.table) {
            lines.add(String.format(format, line.toArray()));
        }
        return lines;
    }

    public List<List<String>> getTable() {
        return this.table;
    }

    public DebugSequenceAcceptor hideHiddenTokens() {
        this.hideHidden = true;
        return this;
    }

    public void leaveAssignedAction(Action action, EObject semanticChild) {
        --this.indentation;
        this.add("}", "", "", -1, (INode)NO_NODE);
        super.leaveAssignedAction(action, semanticChild);
    }

    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        --this.indentation;
        this.add("}", "", "", -1, (INode)NO_NODE);
        super.leaveAssignedParserRuleCall(rc, semanticChild);
    }

    public void leaveUnssignedParserRuleCall(RuleCall rc) {
        --this.indentation;
        this.add("}", "", "", -1, (INode)NO_NODE);
        super.leaveUnssignedParserRuleCall(rc);
    }

    protected String node2text(INode node) {
        if (node == null) {
            return "(node is null)";
        }
        if (node instanceof ILeafNode) {
            return String.valueOf(this.titles.doSwitch(node.getGrammarElement())) + " -> " + node.getText();
        }
        if (node instanceof ICompositeNode) {
            return this.titles.doSwitch(node.getGrammarElement());
        }
        return "(unknown node)";
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.getList());
    }
}

