/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hierarchy;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.JavaElementProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.ui.hierarchy.AbstractHierarchyHandler;

public class QuickTypeHierarchyHandler
extends AbstractHierarchyHandler {
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    protected void openPresentation(XtextEditor editor, IJavaElement javaElement, EObject selectedElement) {
        ISourceViewer sourceViewer = editor.getInternalSourceViewer();
        HierarchyInformationPresenter presenter = new HierarchyInformationPresenter(this.getHierarchyPresenterControlCreator(), sourceViewer, javaElement, selectedElement);
        presenter.setDocumentPartitioning("__dftl_partitioning");
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)editor, false);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(50, 20, true, false);
        presenter.install((ITextViewer)sourceViewer);
        presenter.showInformation();
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                HierarchyInformationControl hierarchyInformationControl = new HierarchyInformationControl(parent, shellStyle, treeStyle);
                return hierarchyInformationControl;
            }
        };
    }

    protected final class HierarchyInformationPresenter
    extends InformationPresenter {
        private final ISourceViewer sourceViewer;
        private final IJavaElement javaElement;
        private final EObject selectedElement;

        protected HierarchyInformationPresenter(IInformationControlCreator creator, ISourceViewer sourceViewer, IJavaElement javaElement, EObject selectedElement) {
            super(creator);
            this.sourceViewer = sourceViewer;
            this.javaElement = javaElement;
            this.selectedElement = selectedElement;
        }

        protected void computeInformation() {
            this.setCustomInformationControlCreator(null);
            ITextRegion significantRegion = QuickTypeHierarchyHandler.this.locationInFileProvider.getSignificantTextRegion(this.selectedElement);
            this.setInformation(this.javaElement, this.computeArea((IRegion)new Region(significantRegion.getOffset(), significantRegion.getLength())));
            this.presentInformation();
        }

        protected Rectangle computeArea(IRegion region) {
            Rectangle bounds;
            int start = 0;
            int end = 0;
            IRegion widgetRegion = this.modelRange2WidgetRange(region);
            if (widgetRegion != null) {
                start = widgetRegion.getOffset();
                end = widgetRegion.getOffset() + widgetRegion.getLength();
            }
            StyledText styledText = this.sourceViewer.getTextWidget();
            if (end > 0 && start < end) {
                bounds = styledText.getTextBounds(start, end - 1);
            } else {
                Point loc = styledText.getLocationAtOffset(start);
                bounds = new Rectangle(loc.x, loc.y, 0, styledText.getLineHeight(start));
            }
            return bounds;
        }

        protected IRegion modelRange2WidgetRange(IRegion region) {
            if (this.sourceViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)this.sourceViewer;
                return extension.modelRange2WidgetRange(region);
            }
            IRegion visibleRegion = this.sourceViewer.getVisibleRegion();
            int start = region.getOffset() - visibleRegion.getOffset();
            int end = start + region.getLength();
            if (end > visibleRegion.getLength()) {
                end = visibleRegion.getLength();
            }
            return new Region(start, end - start);
        }
    }
}

