/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractStaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescription;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticExtensionImportsScope
extends AbstractStaticImportsScope {
    private final OperatorMapping operatorMapping;
    private final XExpression receiver;
    private final LightweightTypeReference receiverType;
    private final boolean implicit;

    public StaticExtensionImportsScope(IScope parent, IFeatureScopeSession session, XExpression receiver, LightweightTypeReference receiverType, boolean implicit, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.implicit = implicit;
        this.operatorMapping = operatorMapping;
    }

    @Override
    protected List<TypeBucket> getBuckets() {
        return this.getSession().getStaticallyImportedExtensionTypes();
    }

    @Override
    protected void processFeatureNames(QualifiedName name, AbstractSessionBasedScope.NameAcceptor acceptor) {
        QualifiedName methodName = this.operatorMapping.getMethodName(name);
        if (methodName != null) {
            acceptor.accept(methodName.toString(), 2);
        } else {
            super.processFeatureNames(name, acceptor);
        }
    }

    @Override
    protected BucketedEObjectDescription createDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        LightweightTypeReference rawReceiverType;
        if (!(feature instanceof JvmOperation)) {
            return null;
        }
        EList parameters = ((JvmExecutable)feature).getParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        JvmFormalParameter firstParameter = (JvmFormalParameter)parameters.get(0);
        JvmTypeReference type = firstParameter.getParameterType();
        if (type == null) {
            return null;
        }
        JvmType rawParameterType = type.getType();
        if (!(rawParameterType instanceof JvmTypeParameter) && (rawReceiverType = this.receiverType.getRawTypeReference()).isResolved()) {
            LightweightTypeReference parameterTypeReference = new OwnedConverter(rawReceiverType.getOwner()).toRawLightweightReference(rawParameterType);
            if (parameterTypeReference.isResolved() && !parameterTypeReference.isAssignableFrom(rawReceiverType)) {
                return null;
            }
            if (parameterTypeReference.isArray() && !rawReceiverType.isArray() && !rawReceiverType.isSubtypeOf(Iterable.class)) {
                return null;
            }
        }
        if (this.implicit) {
            return new StaticExtensionFeatureDescriptionWithImplicitFirstArgument(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        return new StaticExtensionFeatureDescription(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    @Override
    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        QualifiedName featureName = QualifiedName.create((String)feature.getSimpleName());
        result.add(this.createDescription(featureName, feature, bucket));
        QualifiedName operator = this.operatorMapping.getOperator(featureName);
        if (operator != null) {
            result.add(this.createDescription(operator, feature, bucket));
        }
    }
}

