/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.VisibilityService;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.featurecalls.DefaultFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureSignatureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefaultJvmFeatureDescriptionProvider
implements IJvmFeatureDescriptionProvider,
IFeaturesForTypeProvider {
    @Inject
    protected VisibilityService visibilityService;
    @Inject
    protected IFeaturesForTypeProvider featuresForTypeProvider = new DefaultFeaturesForTypeProvider();
    @Inject
    protected JvmFeatureSignatureProvider signatureProvider = new JvmFeatureSignatureProvider();
    protected JvmDeclaredType contextType;
    protected XExpression implicitReceiver;
    protected XExpression implicitArgument;
    protected int priority;
    protected boolean preferStatics;

    public void setVisibilityService(VisibilityService visibilityService) {
        this.visibilityService = visibilityService;
    }

    @Override
    public Iterable<IEObjectDescription> getDescriptionsByName(String name, IFeaturesForTypeProvider featureProvider, JvmTypeReference typeReference, Function<? super JvmFeatureDescription, ? extends ITypeArgumentContext> genericContextFactory, ITypeArgumentContext rawTypeContext, Iterable<JvmTypeReference> hierarchy) {
        LinkedHashMap descriptions = Maps.newLinkedHashMap();
        ShadowingAwareAcceptor acceptor = new ShadowingAwareAcceptor(descriptions, genericContextFactory);
        this.doCollectDescriptions(name, featureProvider, typeReference, rawTypeContext, hierarchy, acceptor);
        return descriptions.values();
    }

    @Override
    public Iterable<IEObjectDescription> getAllDescriptions(IFeaturesForTypeProvider featureProvider, JvmTypeReference typeReference, Function<? super JvmFeatureDescription, ? extends ITypeArgumentContext> genericContextFactory, ITypeArgumentContext context, Iterable<JvmTypeReference> hierarchy) {
        LinkedHashMap descriptions = Maps.newLinkedHashMap();
        ShadowingAwareAcceptor acceptor = new ShadowingAwareAcceptor(descriptions, genericContextFactory);
        this.doCollectDescriptions(featureProvider, typeReference, context, hierarchy, acceptor);
        return descriptions.values();
    }

    protected void doCollectDescriptions(String name, IFeaturesForTypeProvider featureProvider, JvmTypeReference typeReference, ITypeArgumentContext rawTypeContext, Iterable<JvmTypeReference> hierarchy, IAcceptor<JvmFeatureDescription> acceptor) {
        Iterable<JvmFeature> features = featureProvider.getFeaturesByName(name, typeReference, hierarchy);
        for (JvmFeature jvmFeature : features) {
            this.addFeatureDescriptions(jvmFeature, rawTypeContext, acceptor);
        }
    }

    protected void doCollectDescriptions(IFeaturesForTypeProvider featureProvider, JvmTypeReference typeReference, ITypeArgumentContext context, Iterable<JvmTypeReference> hierarchy, IAcceptor<JvmFeatureDescription> acceptor) {
        Iterable<JvmFeature> features = featureProvider.getAllFeatures(typeReference, hierarchy);
        for (JvmFeature jvmFeature : features) {
            this.addFeatureDescriptions(jvmFeature, context, acceptor);
        }
    }

    @Override
    public Iterable<JvmFeature> getFeaturesByName(String name, JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        return this.featuresForTypeProvider.getFeaturesByName(name, declarator, hierarchy);
    }

    @Override
    public Iterable<JvmFeature> getAllFeatures(JvmTypeReference typeReference, Iterable<JvmTypeReference> hierarchy) {
        return this.featuresForTypeProvider.getAllFeatures(typeReference, hierarchy);
    }

    public void setFeaturesForTypeProvider(IFeaturesForTypeProvider featuresForTypeProvider) {
        this.featuresForTypeProvider = featuresForTypeProvider;
    }

    public void setPreferStatics(boolean preferStatics) {
        this.preferStatics = preferStatics;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setContextType(JvmDeclaredType contextType) {
        this.contextType = contextType;
    }

    public void setImplicitReceiver(XExpression implicitReceiver) {
        this.implicitReceiver = implicitReceiver;
    }

    public XExpression getImplicitReceiver() {
        return this.implicitReceiver;
    }

    public void setImplicitArgument(XExpression implicitArgument) {
        this.implicitArgument = implicitArgument;
    }

    public XExpression getImplicitArgument() {
        return this.implicitArgument;
    }

    protected JvmFeatureDescription createJvmFeatureDescription(QualifiedName name, JvmFeature jvmFeature, ITypeArgumentContext rawTypeContext, String shadowingString, boolean isValid, boolean isValidStaticState) {
        return new JvmFeatureDescription(name, jvmFeature, rawTypeContext, shadowingString, isValid, isValidStaticState, this.implicitReceiver, this.implicitArgument, this.getNumberOfIrrelevantArguments());
    }

    protected JvmFeatureDescription createJvmFeatureDescription(QualifiedName name, JvmFeature jvmFeature, ITypeArgumentContext rawTypeContext, Provider<String> shadowingStringProvider, boolean isVisible, boolean isValidStaticState) {
        return new JvmFeatureDescription(name, jvmFeature, rawTypeContext, shadowingStringProvider, isVisible, isValidStaticState, this.implicitReceiver, this.implicitArgument, this.getNumberOfIrrelevantArguments());
    }

    protected int getNumberOfIrrelevantArguments() {
        if (this.isExtensionProvider() || this.implicitArgument != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isExtensionProvider() {
        return this.featuresForTypeProvider != null ? this.featuresForTypeProvider.isExtensionProvider() : false;
    }

    protected JvmFeatureDescription createJvmFeatureDescription(JvmFeature jvmFeature, ITypeArgumentContext rawTypeContext, Provider<String> shadowingStringProvider, boolean isValid, boolean isValidStaticState) {
        return this.createJvmFeatureDescription(QualifiedName.create((String)jvmFeature.getSimpleName()), jvmFeature, rawTypeContext, shadowingStringProvider, isValid, isValidStaticState);
    }

    public void addFeatureDescriptions(JvmFeature feature, ITypeArgumentContext rawTypeContext, IAcceptor<JvmFeatureDescription> acceptor) {
        Provider<String> signatureProvider = this.getSignature(feature, rawTypeContext);
        acceptor.accept((Object)this.createJvmFeatureDescription(feature, rawTypeContext, signatureProvider, this.isVisible(feature), this.isValidStaticState(feature)));
    }

    protected Provider<String> getSignature(final JvmFeature feature, final ITypeArgumentContext context) {
        return new Provider<String>(){

            public String get() {
                return DefaultJvmFeatureDescriptionProvider.this.signatureProvider.getSignature(feature, context, DefaultJvmFeatureDescriptionProvider.this.getNumberOfIrrelevantArguments());
            }
        };
    }

    protected boolean isVisible(JvmFeature feature) {
        return this.visibilityService.isVisible((JvmMember)feature, this.contextType);
    }

    protected boolean isValidStaticState(JvmFeature feature) {
        return !(feature instanceof JvmOperation ? this.preferStatics != ((JvmOperation)feature).isStatic() : feature instanceof JvmField && this.preferStatics != ((JvmField)feature).isStatic());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [featuresForTypeProvider=" + this.featuresForTypeProvider + ", contextType=" + this.getContextIdentifier() + ", implicitReceiver=" + this.implicitReceiver + ", implicitArgument=" + this.implicitArgument + ", priority=" + this.priority + "]";
    }

    private String getContextIdentifier() {
        return this.contextType == null ? null : this.contextType.getIdentifier();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ShadowingAwareAcceptor
    implements IAcceptor<JvmFeatureDescription> {
        private final Map<String, IEObjectDescription> descriptions;
        private final Function<? super JvmFeatureDescription, ? extends ITypeArgumentContext> genericContextFactory;

        protected ShadowingAwareAcceptor(Map<String, IEObjectDescription> descriptions, Function<? super JvmFeatureDescription, ? extends ITypeArgumentContext> genericContextFactory) {
            this.descriptions = descriptions;
            this.genericContextFactory = genericContextFactory;
        }

        public void accept(JvmFeatureDescription t) {
            IEObjectDescription old;
            String key = t.getKey();
            if (this.useOldDescription(key, old = this.descriptions.put(key, t), t)) {
                this.descriptions.put(key, old);
            } else {
                t.setGenericTypeContext((ITypeArgumentContext)this.genericContextFactory.apply((Object)t));
            }
        }

        protected boolean useOldDescription(String key, IEObjectDescription oldDescription, IEObjectDescription newDescription) {
            if (oldDescription == null) {
                return false;
            }
            if (!(oldDescription instanceof JvmFeatureDescription)) {
                return true;
            }
            String oldFeatureName = ((JvmFeatureDescription)oldDescription).getJvmFeature().getSimpleName();
            if (Strings.equal((String)key, (String)oldFeatureName)) {
                return true;
            }
            String newFeatureName = ((JvmFeatureDescription)newDescription).getJvmFeature().getSimpleName();
            if (Strings.equal((String)key, (String)newFeatureName)) {
                return false;
            }
            if (oldFeatureName.startsWith("get") && newFeatureName.startsWith("is")) {
                return true;
            }
            return !oldFeatureName.startsWith("is") || !newFeatureName.startsWith("old");
        }
    }
}

