/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;
import org.eclipse.xtext.xbase.validation.XbaseSeverityConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XbaseConfigurableIssueCodes
extends ConfigurableIssueCodesProvider {
    private Map<String, PreferenceKey> issueCodes;

    public XbaseConfigurableIssueCodes() {
        final LinkedHashMap map = Maps.newLinkedHashMap();
        this.initialize(new IAcceptor<PreferenceKey>(){

            public void accept(PreferenceKey prefKey) {
                map.put(prefKey.getId(), prefKey);
            }
        });
        this.issueCodes = ImmutableMap.copyOf((Map)map);
    }

    protected void initialize(IAcceptor<PreferenceKey> iAcceptor) {
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature", "warning"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", "ignore"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null", "ignore"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", "org.eclipse.jdt.core.compiler.problem.forbiddenReference"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference", "org.eclipse.jdt.core.compiler.problem.discouragedReference"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated", "warning"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof", "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast", "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued", "org.eclipse.jdt.core.compiler.problem.unusedImport"));
        iAcceptor.accept((Object)this.createDelegate("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable", "org.eclipse.jdt.core.compiler.problem.unusedLocal"));
        iAcceptor.accept((Object)this.create("org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate", "warning"));
    }

    protected final PreferenceKey create(String id, String defaultValue) {
        return new PreferenceKey(id, defaultValue);
    }

    protected PreferenceKey createDelegate(String id, String delegationKey) {
        return this.createDelegate(id, delegationKey, "warning");
    }

    protected PreferenceKey createDelegate(String id, String delegationKey, String defaultSeverity) {
        String encodedDelegation = XbaseSeverityConverter.encodeDefaultSeverity(delegationKey, defaultSeverity);
        return this.create(id, encodedDelegation);
    }

    public Map<String, PreferenceKey> getConfigurableIssueCodes() {
        return this.issueCodes;
    }
}

