/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerResourceSetBasedResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions.IContextAware {
    @Inject
    private IResourceServiceProvider.Registry registry;
    public ResourceSet resourceSet;

    private Descriptions getDescriptions(ResourceSet rs) {
        for (Adapter a : rs.eAdapters()) {
            if (!(a instanceof Descriptions)) continue;
            return (Descriptions)a;
        }
        return null;
    }

    private Map<URI, IResourceDescription> getDescriptionsMap() {
        Descriptions descriptions = this.getDescriptions(this.getResourceSet());
        if (descriptions == null) {
            descriptions = new Descriptions();
            this.getResourceSet().eAdapters().add((Object)descriptions);
            ArrayList list = new ArrayList(this.getResourceSet().getResources());
            for (Resource resource : list) {
                IResourceDescription description = this.computeResourceDescription(resource.getURI());
                if (description == null) continue;
                descriptions.map.put(resource.getURI(), description);
            }
        }
        return descriptions.map;
    }

    private IResourceDescription computeResourceDescription(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, false);
        if (resource == null) {
            return null;
        }
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
        if (manager == null) {
            return null;
        }
        return manager.getResourceDescription(resource);
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Collections.unmodifiableCollection(this.getDescriptionsMap().values());
    }

    public void setRegistry(IResourceServiceProvider.Registry registry) {
        this.registry = registry;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    protected Iterable<? extends ISelectable> getSelectables() {
        return this.getAllResourceDescriptions();
    }

    @Override
    public boolean isEmpty() {
        return this.getDescriptionsMap().isEmpty();
    }

    protected boolean hasDescription(URI uri) {
        return this.getDescriptionsMap().containsKey(uri);
    }

    @Override
    public void setContext(Notifier ctx) {
        this.resourceSet = EcoreUtil2.getResourceSet(ctx);
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "\n  " + Joiner.on((String)"\n  ").join(this.getAllResourceDescriptions()) + "\n]";
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        return this.getDescriptionsMap().get(uri);
    }

    static class Descriptions
    extends AdapterImpl {
        Map<URI, IResourceDescription> map = Maps.newHashMap();

        Descriptions() {
        }
    }
}

