/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.inject.Inject;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.label.ILabelProviderImageDescriptorExtension;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.hover.HoverUiStrings;
import org.eclipse.xtext.xbase.validation.UIStrings;

public class XbaseDeclarativeHoverSignatureProvider {
    @Inject
    protected HoverUiStrings hoverUiStrings;
    @Inject
    protected UIStrings uiStrings;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private ILabelProvider labelProvider;
    @Inject
    private ITypeProvider typeProvider;

    public String getSignature(EObject object) {
        return this.internalGetSignature(object, false);
    }

    public String getDerivedOrSourceSignature(EObject object) {
        return this.internalGetSignature(object, true);
    }

    protected String internalGetSignature(EObject object, boolean typeAtEnd) {
        PolymorphicDispatcher polymorphicDispatcher = new PolymorphicDispatcher("_signature", 2, 2, Collections.singletonList(this), (PolymorphicDispatcher.ErrorHandler)new PolymorphicDispatcher.ErrorHandler<String>(){

            public String handle(Object[] params, Throwable throwable) {
                return null;
            }
        });
        String result = (String)polymorphicDispatcher.invoke(new Object[]{object, typeAtEnd});
        if (result != null) {
            return result;
        }
        if (object instanceof JvmIdentifiableElement) {
            return this.getLabel(object);
        }
        return this.getLabelForNonXbaseElement(object);
    }

    private String getLabelForNonXbaseElement(EObject object) {
        String label = this.getLabel(object);
        return String.valueOf(object.eClass().getName()) + (label != null ? " " + label : "");
    }

    protected String _signature(JvmGenericType clazz, boolean typeAtEnd) {
        return String.valueOf(clazz.getSimpleName()) + this.hoverUiStrings.typeParameters((Iterable)clazz.getTypeParameters());
    }

    protected String _signature(JvmOperation jvmOperation, boolean typeAtEnd) {
        String returnTypeString = "void";
        JvmTypeReference returnType = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)jvmOperation);
        if (returnType != null) {
            returnTypeString = returnType instanceof JvmAnyTypeReference ? "Object" : returnType.getSimpleName();
        }
        String signature = String.valueOf(jvmOperation.getSimpleName()) + this.hoverUiStrings.parameters((JvmIdentifiableElement)jvmOperation) + this.getThrowsDeclaration((JvmExecutable)jvmOperation);
        String typeParameter = this.uiStrings.typeParameters((Iterable)jvmOperation.getTypeParameters());
        if (typeParameter != null && typeParameter.length() > 0) {
            if (typeAtEnd) {
                return String.valueOf(signature) + " " + typeParameter + " : " + returnTypeString;
            }
            return String.valueOf(typeParameter) + " " + returnTypeString + " " + signature;
        }
        if (typeAtEnd) {
            return String.valueOf(signature) + " : " + returnTypeString;
        }
        return String.valueOf(returnTypeString) + " " + this.enrichWithDeclarator(signature, (EObject)jvmOperation);
    }

    protected String _signature(JvmField jvmField, boolean typeAtEnd) {
        JvmTypeReference type = jvmField.getType();
        if (type != null) {
            String signature = jvmField.getSimpleName();
            if (typeAtEnd) {
                return String.valueOf(signature) + " : " + type.getSimpleName();
            }
            return String.valueOf(type.getSimpleName()) + " " + this.enrichWithDeclarator(signature, (EObject)jvmField);
        }
        return "";
    }

    protected String enrichWithDeclarator(String signature, EObject o) {
        EObject object = o.eContainer();
        if (object instanceof JvmMember) {
            String parentsName = ((JvmMember)object).getSimpleName();
            return String.valueOf(parentsName) + "." + signature;
        }
        return signature;
    }

    protected String _signature(JvmConstructor contructor, boolean typeAtEnd) {
        return String.valueOf(this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)contructor).getSimpleName()) + this.hoverUiStrings.parameters((JvmIdentifiableElement)contructor) + this.getThrowsDeclaration((JvmExecutable)contructor);
    }

    protected String _signature(JvmFormalParameter parameter, boolean typeAtEnd) {
        EObject container = parameter.eContainer();
        JvmTypeReference type = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)parameter);
        if (type != null) {
            String signature = parameter.getName();
            String signatureOfFather = this.getSimpleSignature(container);
            if (signatureOfFather != null) {
                signature = String.valueOf(signature) + JavaElementLabels.CONCAT_STRING + signatureOfFather;
            }
            if (typeAtEnd) {
                return String.valueOf(signature) + " : " + type.getSimpleName();
            }
            return String.valueOf(type.getSimpleName()) + " " + signature;
        }
        return parameter.getName();
    }

    protected String _signature(JvmTypeParameter parameter, boolean typeAtEnd) {
        EObject container = parameter.eContainer();
        String signature = parameter.getName();
        String signatureOfFather = this.getSimpleSignature(container);
        if (signatureOfFather != null) {
            signature = String.valueOf(signature) + JavaElementLabels.CONCAT_STRING + signatureOfFather;
        }
        return signature;
    }

    protected String _signature(JvmEnumerationType jvmEnumerationType, boolean typeAtEnd) {
        return jvmEnumerationType.getSimpleName();
    }

    protected String _signature(JvmAnnotationType jvmAnnotationType, boolean typeAtEnd) {
        return jvmAnnotationType.getSimpleName();
    }

    protected String getThrowsDeclaration(JvmExecutable executable) {
        String result = "";
        EList exceptions = executable.getExceptions();
        if (exceptions.size() > 0) {
            result = String.valueOf(result) + " throws ";
            Iterator iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                JvmTypeReference next = (JvmTypeReference)iterator.next();
                result = String.valueOf(result) + next.getSimpleName();
                if (!iterator.hasNext()) continue;
                result = String.valueOf(result) + ", ";
            }
        }
        return result;
    }

    protected String getSimpleSignature(EObject container) {
        if (container instanceof JvmOperation) {
            return this.getSimpleSignature((JvmOperation)container);
        }
        if (container instanceof JvmConstructor) {
            return this.getSimpleSignature((JvmConstructor)container);
        }
        return this.labelProvider.getText((Object)container);
    }

    protected String getSimpleSignature(JvmConstructor contructor) {
        return String.valueOf(contructor.getSimpleName()) + " " + this.uiStrings.parameters((JvmIdentifiableElement)contructor);
    }

    protected String getSimpleSignature(JvmOperation jvmOperation) {
        return String.valueOf(jvmOperation.getSimpleName()) + this.uiStrings.parameters((JvmIdentifiableElement)jvmOperation);
    }

    public String getImageTag(EObject object) {
        ILabelProviderImageDescriptorExtension extension;
        ImageDescriptor descriptor;
        if (this.labelProvider instanceof ILabelProviderImageDescriptorExtension && (descriptor = (extension = (ILabelProviderImageDescriptorExtension)this.labelProvider).getImageDescriptor((Object)object)) != null) {
            return this.getImageTagLink(descriptor);
        }
        return null;
    }

    protected String getImageTagLink(ImageDescriptor imageDescriptor) {
        URL url = this.getURL(imageDescriptor);
        if (url != null) {
            return "<image src='" + url.toExternalForm() + "'/>";
        }
        return "";
    }

    protected URL getURL(ImageDescriptor descriptor) {
        return JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(descriptor);
    }

    protected String getLabel(EObject object) {
        return this.labelProvider.getText((Object)object);
    }
}

