/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ExtendedEarlyExitComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class RootResolvedTypes
extends ResolvedTypes {
    private Set<XExpression> toBeInferredRootExpressions;
    private IssueSeverities issueSeverities;

    protected RootResolvedTypes(DefaultReentrantTypeResolver resolver) {
        super(resolver);
        this.issueSeverities = resolver.getIssueSeverities();
    }

    public void resolveUnboundTypeParameters() {
        for (UnboundTypeReference unbound : this.basicGetTypeParameters().values()) {
            unbound.resolve();
        }
    }

    public void resolveProxies() {
        Map<XExpression, ILinkingCandidate> candidates = this.basicGetLinkingCandidates();
        for (ILinkingCandidate iLinkingCandidate : candidates.values()) {
            iLinkingCandidate.applyToModel();
        }
        for (Map.Entry entry : this.basicGetTypes().entrySet()) {
            JvmIdentifiableElement identifiable = (JvmIdentifiableElement)entry.getKey();
            if (!(identifiable instanceof JvmFormalParameter) || identifiable.eContainingFeature() != XbasePackage.Literals.XCLOSURE__IMPLICIT_PARAMETER) continue;
            JvmFormalParameter implicitLambdaParameter = (JvmFormalParameter)identifiable;
            JvmTypeReference typeReference = ((LightweightTypeReference)entry.getValue()).toTypeReference();
            implicitLambdaParameter.setParameterType(typeReference);
        }
    }

    @Override
    @Nullable
    protected LightweightTypeReference getExpectedTypeForAssociatedExpression(JvmMember member, XExpression expression) {
        if (this.toBeInferredRootExpressions != null && this.toBeInferredRootExpressions.contains(expression)) {
            return null;
        }
        return this.getActualType((JvmIdentifiableElement)member);
    }

    @Override
    protected void markToBeInferred(XExpression expression) {
        if (this.toBeInferredRootExpressions == null) {
            this.toBeInferredRootExpressions = Sets.newHashSet();
        }
        this.toBeInferredRootExpressions.add(expression);
    }

    public void addDiagnostics(Resource resource) {
        if (resource instanceof XtextResource && ((XtextResource)resource).isValidationDisabled()) {
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DiagnosticAcceptor
        implements IAcceptor<AbstractDiagnostic> {
            private final /* synthetic */ Resource val$resource;

            DiagnosticAcceptor(Resource resource) {
                this.val$resource = resource;
            }

            public void accept(@Nullable AbstractDiagnostic diagnostic) {
                if (diagnostic instanceof EObjectDiagnosticImpl) {
                    Severity severity = ((EObjectDiagnosticImpl)diagnostic).getSeverity();
                    if (severity == Severity.ERROR) {
                        this.val$resource.getErrors().add((Object)diagnostic);
                    } else if (severity == Severity.WARNING) {
                        this.val$resource.getWarnings().add((Object)diagnostic);
                    }
                } else {
                    this.val$resource.getErrors().add((Object)diagnostic);
                }
            }
        }
        DiagnosticAcceptor acceptor = new DiagnosticAcceptor(resource);
        this.addQueuedDiagnostics(acceptor);
        this.addLinkingDiagnostics(acceptor);
        this.addTypeDiagnostics(acceptor);
    }

    protected void addTypeDiagnostics(IAcceptor<? super AbstractDiagnostic> acceptor) {
        for (Map.Entry<XExpression, List<TypeData>> entry : this.basicGetExpressionTypes().entrySet()) {
            XExpression expression = entry.getKey();
            if (this.isPropagatedType(expression)) continue;
            this.addTypeDiagnostic(expression, this.mergeTypeData(expression, (Collection<TypeData>)entry.getValue(), false, false), acceptor);
        }
    }

    protected void addTypeDiagnostic(XExpression expression, @Nullable TypeData typeData, IAcceptor<? super AbstractDiagnostic> acceptor) {
        if (typeData != null) {
            LightweightTypeReference actualType = typeData.getActualType();
            ITypeExpectation expectation = typeData.getExpectation();
            if (!typeData.getConformanceHints().contains((Object)ConformanceHint.NO_IMPLICIT_RETURN) && !typeData.getConformanceHints().contains((Object)ConformanceHint.PROPAGATED_TYPE)) {
                if (actualType.isPrimitiveVoid() && this.isIntentionalEarlyExit(expression)) {
                    return;
                }
                LightweightTypeReference expectedType = expectation.getExpectedType();
                if (expectedType != null) {
                    EnumSet<ConformanceHint> conformanceHints;
                    if (!expectedType.isPrimitiveVoid() && !this.isSuccess(conformanceHints = this.getConformanceHints(typeData, false))) {
                        AbstractDiagnostic diagnostic = this.createTypeDiagnostic(expression, actualType, expectedType);
                        if (diagnostic == null) {
                            typeData.getConformanceHints().add(ConformanceHint.UNCHECKED);
                        } else {
                            acceptor.accept((Object)diagnostic);
                        }
                    }
                } else if (!expectation.isVoidTypeAllowed() && actualType.isPrimitiveVoid()) {
                    EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", "Type mismatch: type void is not applicable at this location", (EObject)expression, null, -1, null);
                    acceptor.accept((Object)diagnostic);
                }
            }
        }
    }

    protected boolean isIntentionalEarlyExit(@Nullable XExpression expression) {
        ExtendedEarlyExitComputer earlyExitComputer = this.getReferenceOwner().getServices().getEarlyExitComputer();
        return earlyExitComputer.isIntentionalEarlyExit(expression);
    }

    protected AbstractDiagnostic createTypeDiagnostic(XExpression expression, LightweightTypeReference actualType, LightweightTypeReference expectedType) {
        if (!expectedType.isAny()) {
            String expectedName;
            String actualName = actualType.getSimpleName();
            if (actualName.equals(expectedName = expectedType.getSimpleName()) && expectedType.isAssignableFrom(actualType)) {
                return null;
            }
            if (expression.eContainingFeature() == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__IMPLICIT_FIRST_ARGUMENT) {
                return new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert implicit first argument from %s to %s", actualType.getSimpleName(), expectedType.getSimpleName()), (EObject)expression, null, -1, null);
            }
            return new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: cannot convert from %s to %s", actualType.getSimpleName(), expectedType.getSimpleName()), (EObject)expression, null, -1, null);
        }
        return new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", String.format("Type mismatch: type %s is not applicable at this location", actualType.getSimpleName()), (EObject)expression, null, -1, null);
    }

    protected boolean isSuccess(EnumSet<ConformanceHint> conformanceHints) {
        if (!conformanceHints.contains((Object)ConformanceHint.SUCCESS)) {
            return false;
        }
        if (conformanceHints.contains((Object)ConformanceHint.NO_IMPLICIT_RETURN)) {
            return true;
        }
        return true;
    }

    protected void addLinkingDiagnostics(IAcceptor<? super AbstractDiagnostic> acceptor) {
        Map<XExpression, ILinkingCandidate> candidates = this.basicGetLinkingCandidates();
        for (ILinkingCandidate candidate : candidates.values()) {
            candidate.validate(acceptor);
        }
    }

    protected void addQueuedDiagnostics(IAcceptor<? super AbstractDiagnostic> acceptor) {
        for (AbstractDiagnostic diagnostic : this.getQueuedDiagnostics()) {
            acceptor.accept((Object)diagnostic);
        }
    }

    @Override
    protected IssueSeverities getSeverities() {
        return this.issueSeverities;
    }
}

