/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.interpreter.SwitchConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithNonNullResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.util.TypesOrderUtil;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.util.XSwitchExpressions;
import org.eclipse.xtext.xbase.util.XbaseUsageCrossReferencer;
import org.eclipse.xtext.xbase.validation.AbstractXbaseJavaValidator;
import org.eclipse.xtext.xbase.validation.EarlyExitValidator;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComposedChecks(validators={EarlyExitValidator.class})
public class XbaseJavaValidator
extends AbstractXbaseJavaValidator {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private IEarlyExitComputer earlyExitComputer;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private XSwitchExpressions switchExpressions;
    @Inject
    private TypesOrderUtil typesOrderUtil;
    @Inject
    private SwitchConstantExpressionsInterpreter switchConstantExpressionsInterpreter;

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected LightweightTypeReference getActualType(EObject context, JvmIdentifiableElement element) {
        return this.typeResolver.resolveTypes(context).getActualType(element);
    }

    protected LightweightTypeReference getActualType(XExpression expression) {
        return this.typeResolver.resolveTypes(expression).getActualType(expression);
    }

    protected LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
        return this.typeResolver.resolveTypes((EObject)identifiable).getActualType(identifiable);
    }

    protected LightweightTypeReference getExpectedType(XExpression expression) {
        return this.typeResolver.resolveTypes(expression).getExpectedType(expression);
    }

    protected void checkCast(JvmTypeReference concreteSyntax, LightweightTypeReference toType, LightweightTypeReference fromType) {
        if (toType == null || fromType == null) {
            return;
        }
        if (fromType.getType() instanceof JvmDeclaredType || fromType.isPrimitive()) {
            if ((!this.isInterface(fromType) || this.isFinal(toType)) && (!this.isInterface(toType) || this.isFinal(fromType)) && !toType.isAssignableFrom(fromType) && (this.isFinal(fromType) || this.isFinal(toType) || this.isClass(fromType) && this.isClass(toType)) && !fromType.isAssignableFrom(toType)) {
                this.error("Cannot cast from " + this.getNameOfTypes(fromType) + " to " + this.canonicalName(toType), (EObject)concreteSyntax, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
            }
        } else if (fromType.isPrimitiveVoid()) {
            this.error("Cannot cast from void to " + this.canonicalName(toType), (EObject)concreteSyntax, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
        }
        if (toType.isPrimitive() && !fromType.isPrimitive() && !fromType.isWrapper()) {
            this.error("Cannot cast from " + this.getNameOfTypes(fromType) + " to " + this.canonicalName(toType), (EObject)concreteSyntax, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
        }
        if (toType.getIdentifier().equals(fromType.getIdentifier())) {
            this.addIssue("Unnecessary cast from " + fromType.getSimpleName() + " to " + toType.getSimpleName(), (EObject)concreteSyntax, "org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast");
        }
    }

    private boolean isInterface(LightweightTypeReference typeRef) {
        return this.isInterface(typeRef.getType());
    }

    private boolean isClass(LightweightTypeReference typeRef) {
        return typeRef.getType() instanceof JvmGenericType && !((JvmGenericType)typeRef.getType()).isInterface();
    }

    @Check
    protected void checkNumberFormat(XNumberLiteral literal) {
        try {
            this.numberLiterals.numberValue(literal, this.numberLiterals.getJavaType(literal));
        }
        catch (Exception e) {
            this.error("Invalid number format: " + e.getMessage(), (EStructuralFeature)XbasePackage.Literals.XNUMBER_LITERAL__VALUE, "org.eclipse.xtext.xbase.validation.IssueCodes.invalidNumberFormat", new String[0]);
        }
    }

    @Check
    public void checkTypeReferenceIsNotVoid(XExpression expression) {
        for (EObject eObject : expression.eContents()) {
            JvmTypeReference typeRef;
            if (!(eObject instanceof JvmTypeReference) || !this.isPrimitiveVoid(typeRef = (JvmTypeReference)eObject)) continue;
            this.error("Primitive void cannot be used here.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    protected boolean isPrimitiveVoid(JvmTypeReference typeReference) {
        return typeReference != null && typeReference.getType() != null && !typeReference.getType().eIsProxy() && typeReference.getType() instanceof JvmVoid;
    }

    @Check
    public void checkVariableIsNotInferredAsVoid(XVariableDeclaration declaration) {
        if (declaration.getType() != null) {
            return;
        }
        LightweightTypeReference variableType = this.typeResolver.resolveTypes(declaration).getActualType(declaration);
        if (variableType != null && variableType.isPrimitiveVoid()) {
            this.error("void is an invalid type for the variable " + declaration.getName(), declaration, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkClosureParameterTypes(XClosure closure) {
        if (closure.getFormalParameters().isEmpty()) {
            return;
        }
        LightweightTypeReference closureType = this.getActualType(closure);
        if (closureType != null && closureType.isUnknown()) {
            return;
        }
        boolean checkedClosure = false;
        for (JvmFormalParameter p : closure.getFormalParameters()) {
            LightweightTypeReference parameterType;
            if (p.getParameterType() != null) continue;
            if (!checkedClosure) {
                LightweightTypeReference type = this.getExpectedType(closure);
                if (type == null) {
                    this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or put the closures into a typed context.", closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
                    return;
                }
                JvmOperation operation = this.getServices().getFunctionTypes().findImplementingOperation(type);
                if (operation == null) {
                    this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context.", closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
                    return;
                }
                checkedClosure = true;
            }
            if ((parameterType = this.getActualType(closure, (JvmIdentifiableElement)p)) != null) continue;
            this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context.", closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
            return;
        }
    }

    @Check
    public void checkTypeArguments(XAbstractFeatureCall expression) {
        for (JvmTypeReference typeRef : expression.getTypeArguments()) {
            this.ensureNotPrimitiveNorWildcard(typeRef);
        }
    }

    @Check
    public void checkTypeArguments(XConstructorCall expression) {
        for (JvmTypeReference typeRef : expression.getTypeArguments()) {
            this.ensureNotPrimitiveNorWildcard(typeRef);
        }
    }

    protected void ensureNotPrimitiveNorWildcard(JvmTypeReference typeRef) {
        LightweightTypeReference reference = this.toLightweightTypeReference(typeRef);
        if (reference.isPrimitive()) {
            this.error("Primitives cannot be used as type arguments.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
        if (reference.isWildcard()) {
            this.error("Wildcard types are not allowed in this context", (EObject)typeRef, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_wild_card", new String[0]);
        }
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        return this.toLightweightTypeReference(typeRef, false);
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, boolean keepUnboundWildcardInformation) {
        OwnedConverter converter = new OwnedConverter(new StandardTypeReferenceOwner(this.getServices(), (EObject)typeRef), keepUnboundWildcardInformation);
        LightweightTypeReference reference = converter.toLightweightReference(typeRef);
        return reference;
    }

    @Check
    public void checkTypeReferenceIsNotVoid(XCasePart expression) {
        if (expression.getTypeGuard() != null && this.toLightweightTypeReference(expression.getTypeGuard()).isPrimitiveVoid()) {
            this.error("Primitive void cannot be used here.", (EObject)expression.getTypeGuard(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkReturn(XReturnExpression expr) {
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(expr);
        LightweightTypeReference expectedReturnType = resolvedTypes.getExpectedReturnType(expr);
        if (expectedReturnType == null) {
            return;
        }
        if (expectedReturnType.isPrimitiveVoid()) {
            if (expr.getExpression() != null) {
                this.error("Void functions cannot return a value.", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return", new String[0]);
            }
        } else if (expr.getExpression() == null) {
            this.error("The function must return a result of type " + expectedReturnType.getSimpleName() + ".", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return", new String[0]);
        } else {
            LightweightTypeReference expressionType = this.getActualType(expr.getExpression());
            if (expressionType.isPrimitiveVoid()) {
                this.error("Incompatible types. Expected " + this.getNameOfTypes(expectedReturnType) + " but was " + this.canonicalName(expressionType), expr.getExpression(), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            }
        }
    }

    protected boolean isImplicitReturn(XExpression expr) {
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getLogicalContainer(expr);
        return (logicalContainer instanceof JvmExecutable || logicalContainer instanceof JvmField || expr.eContainer() instanceof XClosure) && !this.earlyExitComputer.isEarlyExit(expr);
    }

    protected String getNameOfTypes(LightweightTypeReference expectedType) {
        final StringBuilder result = new StringBuilder(this.canonicalName(expectedType));
        this.getServices().getSynonymTypesProvider().collectSynonymTypes(expectedType, new SynonymTypesProvider.Acceptor(){

            @Override
            @NonNullByDefault
            protected boolean accept(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints) {
                result.append(" or ").append(XbaseJavaValidator.this.canonicalName(synonym));
                return true;
            }
        });
        return result.toString();
    }

    @Check
    public void checkTypes(XCatchClause catchClause) {
        LightweightTypeReference parameterType = this.getActualType(catchClause, (JvmIdentifiableElement)catchClause.getDeclaredParam());
        if (parameterType != null && !parameterType.isSubtypeOf(Throwable.class)) {
            this.error("No exception of type " + parameterType.getSimpleName() + " can be thrown; an exception type must be a subclass of Throwable", (EObject)catchClause.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
        }
    }

    @Check
    public void checkTypeParameterNotUsedInStaticContext(JvmTypeReference ref) {
        if (ref.getType() instanceof JvmTypeParameter) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)ref.getType();
            JvmIdentifiableElement currentParent = this.logicalContainerProvider.getNearestLogicalContainer((EObject)ref);
            while (currentParent != null) {
                if (currentParent == typeParameter.eContainer()) {
                    return;
                }
                if (this.isStaticContext((EObject)currentParent)) {
                    this.error("Cannot make a static reference to the non-static type " + typeParameter.getName(), (EObject)ref, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", new String[0]);
                }
                currentParent = currentParent.eContainer();
            }
        }
    }

    protected boolean isStaticContext(EObject element) {
        if (element instanceof JvmConstructor) {
            return false;
        }
        if (element instanceof JvmFeature) {
            return ((JvmFeature)element).isStatic();
        }
        if (element instanceof JvmDeclaredType) {
            return ((JvmDeclaredType)element).isStatic() || ((JvmDeclaredType)element).getDeclaringType() == null;
        }
        return false;
    }

    @Check
    public void checkTypeParameterConstraintIsValid(JvmTypeParameter typeParameter) {
        if (!typeParameter.getConstraints().isEmpty()) {
            for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                JvmTypeReference typeReference = constraint.getTypeReference();
                if (!(typeReference instanceof JvmGenericArrayTypeReference)) continue;
                this.error(String.format("The array type %s cannot be used as a type parameter bound", typeReference.getSimpleName()), (EObject)typeReference, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_parameter_bounds", new String[0]);
            }
        }
    }

    public void doCheckTypeParameterForwardReference(List<JvmTypeParameter> sourceTypeParameters) {
        if (sourceTypeParameters.size() > 1) {
            HashSet forbidden = Sets.newHashSet();
            int i = sourceTypeParameters.size() - 2;
            while (i >= 0) {
                JvmTypeParameter current = sourceTypeParameters.get(i);
                for (EObject jvmElement : this.associations.getJvmElements((EObject)sourceTypeParameters.get(i + 1))) {
                    if (!(jvmElement instanceof JvmTypeParameter)) continue;
                    forbidden.add((JvmTypeParameter)jvmElement);
                }
                for (JvmTypeConstraint constraint : current.getConstraints()) {
                    EcoreUtil2.findCrossReferences((EObject)constraint.getTypeReference(), (Set)forbidden, (EcoreUtil2.ElementReferenceAcceptor)new EcoreUtil2.ElementReferenceAcceptor(){

                        public void accept(EObject referrer, EObject referenced, EReference reference, int index) {
                            XbaseJavaValidator.this.error("Illegal forward reference to type parameter " + ((JvmTypeParameter)referenced).getSimpleName(), referrer, (EStructuralFeature)reference, index, "org.eclipse.xtext.xbase.validation.IssueCodes.type_parameter_forward_reference", new String[0]);
                        }
                    });
                }
                --i;
            }
        }
    }

    @Check
    public void checkAssignment(XAssignment assignment) {
        JvmIdentifiableElement assignmentFeature = assignment.getFeature();
        if (assignmentFeature instanceof XVariableDeclaration && !((XVariableDeclaration)assignmentFeature).isWriteable()) {
            this.error("Assignment to final variable", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (assignmentFeature instanceof JvmFormalParameter) {
            this.error("Assignment to final parameter", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (assignmentFeature instanceof JvmField && ((JvmField)assignmentFeature).isFinal()) {
            JvmField field = (JvmField)assignmentFeature;
            JvmIdentifiableElement container = this.logicalContainerProvider.getNearestLogicalContainer(assignment);
            if (container != null && container instanceof JvmConstructor) {
                JvmConstructor constructor = (JvmConstructor)container;
                if (field.getDeclaringType() == constructor.getDeclaringType()) {
                    return;
                }
            }
            this.error("Assignment to final field", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        }
    }

    protected void checkFinalFieldInitialization(JvmGenericType type) {
        LinkedHashSet finalFields = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)type.getDeclaredFields(), (Predicate)new Predicate<JvmField>(){

            public boolean apply(JvmField input) {
                return input.isFinal();
            }
        }));
        if (finalFields.isEmpty()) {
            return;
        }
        LinkedHashSet initializedFields = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)finalFields, (Predicate)new Predicate<JvmField>(){

            public boolean apply(JvmField input) {
                return XbaseJavaValidator.this.isInitialized(input);
            }
        }));
        for (JvmConstructor constr : type.getDeclaredConstructors()) {
            LinkedHashSet localInitializedFields = Sets.newLinkedHashSet((Iterable)initializedFields);
            XExpression expression = this.logicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)constr);
            if (expression != null) {
                this.checkInitializationRec(expression, finalFields, localInitializedFields, Sets.newLinkedHashSet((Iterable)localInitializedFields), Sets.newHashSet((Object[])new JvmConstructor[]{constr}));
            }
            for (JvmField field : finalFields) {
                if (localInitializedFields.contains(field)) continue;
                this.reportUninitializedField(field);
            }
        }
        if (Iterables.isEmpty((Iterable)type.getDeclaredConstructors())) {
            finalFields.removeAll(initializedFields);
            for (JvmField jvmField : finalFields) {
                this.reportUninitializedField(jvmField);
            }
        }
    }

    protected boolean isInitialized(JvmField input) {
        return this.logicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)input) != null;
    }

    protected void reportUninitializedField(JvmField field) {
    }

    protected void reportFieldAlreadyInitialized(XAssignment assignment, JvmField field) {
        this.error("The final field " + field.getSimpleName() + " may already have been assigned", assignment, null, "org.eclipse.xtext.xbase.validation.IssueCodes.field_already_initialized", new String[0]);
    }

    protected void checkInitializationRec(EObject expr, Set<JvmField> fields, Set<JvmField> initializedForSure, Set<JvmField> initializedMaybe, Set<JvmConstructor> visited) {
        block18: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                if (!(expr instanceof XAssignment)) break block17;
                                XAssignment assignment = (XAssignment)expr;
                                if (assignment.getAssignable() != null) {
                                    this.checkInitializationRec(assignment.getAssignable(), fields, initializedForSure, initializedMaybe, visited);
                                }
                                if (!fields.contains(assignment.getFeature())) break block18;
                                JvmField field = (JvmField)assignment.getFeature();
                                if (fields.contains(field) && (initializedForSure.contains(field) || initializedMaybe.contains(field))) {
                                    this.reportFieldAlreadyInitialized(assignment, field);
                                }
                                initializedForSure.add(field);
                                initializedMaybe.add(field);
                                break block18;
                            }
                            if (!(expr instanceof XForLoopExpression)) break block19;
                            XForLoopExpression loopExpression = (XForLoopExpression)expr;
                            this.checkInitializationRec(loopExpression.getForExpression(), fields, initializedForSure, initializedMaybe, visited);
                            this.checkInitializationRec(loopExpression.getEachExpression(), fields, initializedMaybe, Sets.newLinkedHashSet(fields), visited);
                            break block18;
                        }
                        if (!(expr instanceof XAbstractWhileExpression)) break block20;
                        XAbstractWhileExpression loopExpression = (XAbstractWhileExpression)expr;
                        this.checkInitializationRec(loopExpression.getPredicate(), fields, initializedForSure, Sets.newLinkedHashSet(fields), visited);
                        this.checkInitializationRec(loopExpression.getBody(), fields, initializedMaybe, Sets.newLinkedHashSet(fields), visited);
                        break block18;
                    }
                    if (!(expr instanceof XTryCatchFinallyExpression)) break block21;
                    XTryCatchFinallyExpression tryExpr = (XTryCatchFinallyExpression)expr;
                    this.checkInitializationRec(tryExpr.getExpression(), fields, initializedForSure, initializedMaybe, visited);
                    this.checkInitializationRec(tryExpr.getFinallyExpression(), fields, initializedForSure, initializedMaybe, visited);
                    break block18;
                }
                if (!(expr instanceof XIfExpression)) break block22;
                XIfExpression ifExpr = (XIfExpression)expr;
                this.checkInitializationRec(ifExpr.getIf(), fields, initializedForSure, initializedMaybe, visited);
                LinkedHashSet initializedThenForSure = Sets.newLinkedHashSet(initializedForSure);
                LinkedHashSet initializedThenMaybe = Sets.newLinkedHashSet(initializedMaybe);
                this.checkInitializationRec(ifExpr.getThen(), fields, initializedThenForSure, initializedThenMaybe, visited);
                if (ifExpr.getElse() == null) break block18;
                LinkedHashSet initializedElseForSure = Sets.newLinkedHashSet(initializedForSure);
                LinkedHashSet initializedElseMaybe = Sets.newLinkedHashSet(initializedMaybe);
                this.checkInitializationRec(ifExpr.getElse(), fields, initializedElseForSure, initializedElseMaybe, visited);
                initializedThenForSure.retainAll(initializedElseForSure);
                initializedForSure.addAll(initializedThenForSure);
                initializedMaybe.addAll(initializedThenMaybe);
                initializedMaybe.addAll(initializedElseMaybe);
                break block18;
            }
            if (expr instanceof XSwitchExpression) {
                XSwitchExpression switchExpr = (XSwitchExpression)expr;
                this.checkInitializationRec(switchExpr.getSwitch(), fields, initializedForSure, initializedMaybe, visited);
                LinkedHashSet initializedAllCasesForSure = null;
                LinkedHashSet initializedAllCasesMaybe = Sets.newLinkedHashSet(initializedMaybe);
                for (XCasePart casepart : switchExpr.getCases()) {
                    if (casepart.getCase() != null) {
                        this.checkInitializationRec(casepart.getCase(), fields, initializedForSure, initializedMaybe, visited);
                    }
                    LinkedHashSet initializedInCaseForSure = Sets.newLinkedHashSet(initializedForSure);
                    LinkedHashSet initializedInCaseMaybe = Sets.newLinkedHashSet(initializedMaybe);
                    this.checkInitializationRec(casepart.getThen(), fields, initializedInCaseForSure, initializedInCaseMaybe, visited);
                    if (initializedAllCasesForSure == null) {
                        initializedAllCasesForSure = initializedInCaseForSure;
                    } else {
                        initializedAllCasesForSure.retainAll(initializedInCaseForSure);
                    }
                    initializedAllCasesMaybe.addAll(initializedInCaseMaybe);
                }
                if (switchExpr.getDefault() != null) {
                    LinkedHashSet initializedInCaseForSure = Sets.newLinkedHashSet(initializedForSure);
                    LinkedHashSet initializedInCaseMaybe = Sets.newLinkedHashSet(initializedMaybe);
                    this.checkInitializationRec(switchExpr.getDefault(), fields, initializedInCaseForSure, initializedInCaseMaybe, visited);
                    if (initializedAllCasesForSure == null) {
                        initializedAllCasesForSure = initializedInCaseForSure;
                    } else {
                        initializedAllCasesForSure.retainAll(initializedInCaseForSure);
                    }
                    initializedAllCasesMaybe.addAll(initializedInCaseMaybe);
                    initializedForSure.addAll(initializedAllCasesForSure);
                }
                initializedMaybe.addAll(initializedAllCasesMaybe);
            } else if (expr instanceof XFeatureCall) {
                HashSet visitedCopy;
                XExpression expression;
                JvmConstructor constructor;
                XFeatureCall xFeatureCall = (XFeatureCall)expr;
                if (xFeatureCall.getFeature() instanceof JvmConstructor && (constructor = (JvmConstructor)xFeatureCall.getFeature()).getDeclaringType() == fields.iterator().next().getDeclaringType() && (expression = this.logicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)constructor)) != null && (visitedCopy = Sets.newHashSet(visited)).add(constructor)) {
                    this.checkInitializationRec(expression, fields, initializedForSure, initializedMaybe, visitedCopy);
                }
                for (EObject child : expr.eContents()) {
                    this.checkInitializationRec(child, fields, initializedForSure, initializedMaybe, visited);
                }
            } else {
                if (expr instanceof XClosure) {
                    return;
                }
                for (EObject child : expr.eContents()) {
                    this.checkInitializationRec(child, fields, initializedForSure, initializedMaybe, visited);
                }
            }
        }
    }

    @Check
    public void checkVariableDeclaration(XVariableDeclaration declaration) {
        if (declaration.getRight() == null) {
            if (!declaration.isWriteable()) {
                this.error("Value must be initialized", (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__WRITEABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_initialization", new String[0]);
            }
            if (declaration.getType() == null) {
                this.error("Type cannot be derived", (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_type", new String[0]);
            }
        }
    }

    @Check
    public void checkInnerExpressions(XExpression expr) {
        if (!this.expressionHelper.hasSideEffects(expr) && !this.isValueExpectedRecursive(expr)) {
            this.mustBeJavaStatementExpression(expr);
        }
    }

    protected boolean isValueExpectedRecursive(XExpression expr) {
        XBlockExpression blockExpression;
        EList<XExpression> expressions;
        EStructuralFeature feature = expr.eContainingFeature();
        EObject container = expr.eContainer();
        if (container instanceof XBlockExpression && (expressions = (blockExpression = (XBlockExpression)container).getExpressions()).get(expressions.size() - 1) != expr) {
            return false;
        }
        if (feature == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__FINALLY_EXPRESSION || feature == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__BODY || feature == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION) {
            return false;
        }
        if (container instanceof XAbstractFeatureCall || container instanceof XConstructorCall || container instanceof XAssignment || container instanceof XVariableDeclaration || container instanceof XReturnExpression || container instanceof XThrowExpression || feature == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__FOR_EXPRESSION || feature == XbasePackage.Literals.XSWITCH_EXPRESSION__SWITCH || feature == XbasePackage.Literals.XCASE_PART__CASE || feature == XbasePackage.Literals.XIF_EXPRESSION__IF || feature == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__PREDICATE) {
            return true;
        }
        if (container instanceof XClosure || this.logicalContainerProvider.getLogicalContainer(expr) != null) {
            LightweightTypeReference expectedReturnType = this.typeResolver.resolveTypes(expr).getExpectedReturnType(expr);
            return expectedReturnType == null || !expectedReturnType.isPrimitiveVoid();
        }
        if (container instanceof XCasePart || container instanceof XCatchClause) {
            container = container.eContainer();
        }
        if (container instanceof XExpression) {
            return this.isValueExpectedRecursive((XExpression)container);
        }
        return true;
    }

    protected void mustBeJavaStatementExpression(XExpression expr) {
        if (expr != null) {
            this.error("This expression is not allowed in this context, since it doesn't cause any side effects.", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_inner_expression", new String[0]);
        }
    }

    @Check
    public void checkCasts(XCastedExpression cast) {
        LightweightTypeReference toType = this.toLightweightTypeReference(cast.getType());
        LightweightTypeReference fromType = this.getActualType(cast.getTarget());
        this.checkCast(cast.getType(), toType, fromType);
    }

    @Check
    public void checkTypeGuards(XCasePart casePart) {
        if (casePart.getTypeGuard() == null) {
            return;
        }
        LightweightTypeReference typeGuard = this.toLightweightTypeReference(casePart.getTypeGuard());
        if (typeGuard.isPrimitive()) {
            this.error("Primitives are not allowed as type guards", (EStructuralFeature)XbasePackage.Literals.XCASE_PART__TYPE_GUARD, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            return;
        }
        LightweightTypeReference targetTypeRef = this.getActualType(((XSwitchExpression)casePart.eContainer()).getSwitch());
        this.checkCast(casePart.getTypeGuard(), typeGuard, targetTypeRef);
    }

    @Check
    public void checkInstanceOf(XInstanceOfExpression instanceOfExpression) {
        LightweightTypeReference leftType = this.getActualType(instanceOfExpression.getExpression());
        LightweightTypeReference rightType = this.toLightweightTypeReference(instanceOfExpression.getType(), true);
        if (leftType == null || rightType == null || rightType.getType() == null || rightType.getType().eIsProxy()) {
            return;
        }
        if (this.containsTypeArgs(rightType)) {
            this.error("Cannot perform instanceof check against parameterized type " + this.getNameOfTypes(rightType), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            return;
        }
        if (leftType.isAny() || leftType.isUnknown()) {
            return;
        }
        if (rightType.isPrimitive()) {
            this.error("Cannot perform instanceof check against primitive type " + this.getNameOfTypes(rightType), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            return;
        }
        if (leftType.isPrimitive() || rightType.isArray() && !leftType.isArray() && !leftType.isType(Object.class) && !leftType.isType(Cloneable.class) && !leftType.isType(Serializable.class) || this.isFinal(rightType) && !this.memberOfTypeHierarchy(rightType, leftType) || this.isFinal(leftType) && !this.memberOfTypeHierarchy(leftType, rightType)) {
            this.error("Incompatible conditional operand types " + this.getNameOfTypes(leftType) + " and " + this.getNameOfTypes(rightType), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            return;
        }
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof") && rightType.isAssignableFrom(leftType, new TypeConformanceComputationArgument(false, false, true, true, false, false))) {
            this.addIssueToState("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof", "The expression of type " + this.getNameOfTypes(leftType) + " is already of type " + this.canonicalName(rightType), null);
        }
    }

    protected boolean memberOfTypeHierarchy(LightweightTypeReference type, LightweightTypeReference potentialMember) {
        return potentialMember.isAssignableFrom(type, new TypeConformanceComputationArgument(false, false, false, true, false, false));
    }

    @NonNullByDefault
    protected boolean containsTypeArgs(LightweightTypeReference instanceOfType) {
        return instanceOfType.accept(new TypeReferenceVisitorWithNonNullResult<Boolean>(){

            @Override
            protected Boolean doVisitTypeReference(LightweightTypeReference reference) {
                return Boolean.FALSE;
            }

            @Override
            protected Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
                for (LightweightTypeReference argument : reference.getTypeArguments()) {
                    if (argument.isWildcard()) {
                        if (((WildcardTypeReference)argument).isUnbounded()) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            protected Boolean doVisitArrayTypeReference(ArrayTypeReference reference) {
                return reference.getComponentType().accept(this);
            }
        });
    }

    protected boolean isFinal(LightweightTypeReference expressionTypeRef) {
        if (expressionTypeRef.isArray()) {
            return this.isFinal(expressionTypeRef.getComponentType());
        }
        if (expressionTypeRef.isPrimitive()) {
            return true;
        }
        return expressionTypeRef.getType() instanceof JvmDeclaredType && ((JvmDeclaredType)expressionTypeRef.getType()).isFinal();
    }

    @Check
    public void checkDelegateConstructorIsFirst(XFeatureCall featureCall) {
        JvmIdentifiableElement container;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor && (container = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)) != null) {
            if (container instanceof JvmConstructor) {
                EList<XExpression> expressions;
                XExpression body = this.logicalContainerProvider.getAssociatedExpression(container);
                if (body == featureCall) {
                    return;
                }
                if (body instanceof XBlockExpression && ((expressions = ((XBlockExpression)body).getExpressions()).isEmpty() || expressions.get(0) != featureCall)) {
                    this.error("Constructor call must be the first expression in a constructor", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation", new String[0]);
                }
            } else {
                this.error("Constructor call must be the first expression in a constructor", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation", new String[0]);
            }
        }
    }

    @Check
    public void checkConstructorArgumentsAreValid(XFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor) {
            JvmType containerType = (JvmType)EcoreUtil2.getContainerOfType((EObject)this.logicalContainerProvider.getNearestLogicalContainer(featureCall), JvmType.class);
            for (XExpression argument : featureCall.getFeatureCallArguments()) {
                this.checkIsValidConstructorArgument(argument, containerType);
            }
        }
    }

    protected void checkIsValidConstructorArgument(XExpression argument, JvmType containerType) {
        TreeIterator iterator = EcoreUtil2.eAll((EObject)argument);
        while (iterator.hasNext()) {
            EObject partOfArgumentExpression = (EObject)iterator.next();
            if (partOfArgumentExpression instanceof XFeatureCall || partOfArgumentExpression instanceof XMemberFeatureCall) {
                JvmIdentifiableElement feature;
                XAbstractFeatureCall featureCall = (XAbstractFeatureCall)partOfArgumentExpression;
                XExpression actualReceiver = featureCall.getActualReceiver();
                if (!(actualReceiver instanceof XFeatureCall) || ((XFeatureCall)actualReceiver).getFeature() != containerType || (feature = featureCall.getFeature()) == null || feature.eIsProxy()) continue;
                if (feature instanceof JvmField) {
                    if (((JvmField)feature).isStatic()) continue;
                    this.error("Cannot refer to an instance field " + feature.getSimpleName() + " while explicitly invoking a constructor", partOfArgumentExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument", new String[0]);
                    continue;
                }
                if (!(feature instanceof JvmOperation) || ((JvmOperation)feature).isStatic()) continue;
                this.error("Cannot refer to an instance method while explicitly invoking a constructor", partOfArgumentExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument", new String[0]);
                continue;
            }
            if (!(partOfArgumentExpression instanceof XClosure)) continue;
            iterator.prune();
        }
    }

    @Check
    public void checkNoCircularConstructorCall(XFeatureCall featureCall) {
        JvmIdentifiableElement logicalContainer;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor && (logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)) instanceof JvmConstructor) {
            JvmConstructor currentConstructor = (JvmConstructor)logicalContainer;
            JvmConstructor calledConstructor = (JvmConstructor)feature;
            HashSet visited = Sets.newHashSet((Object[])new JvmConstructor[]{currentConstructor});
            while (calledConstructor.getDeclaringType() == currentConstructor.getDeclaringType()) {
                if (!visited.add(calledConstructor)) {
                    this.error("Recursive constructor invocation", (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "org.eclipse.xtext.xbase.validation.IssueCodes.circular_constructor_invocation", new String[0]);
                    return;
                }
                XExpression constructorBody = this.logicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)calledConstructor);
                if (constructorBody instanceof XBlockExpression) {
                    JvmIdentifiableElement calledFeature;
                    EList<XExpression> expressions = ((XBlockExpression)constructorBody).getExpressions();
                    if (expressions.isEmpty()) {
                        return;
                    }
                    XExpression firstInBody = (XExpression)((XBlockExpression)constructorBody).getExpressions().get(0);
                    if (firstInBody instanceof XFeatureCall && (calledFeature = ((XFeatureCall)firstInBody).getFeature()) != null && !calledFeature.eIsProxy() && calledFeature instanceof JvmConstructor) {
                        calledConstructor = (JvmConstructor)calledFeature;
                        continue;
                    }
                }
                return;
            }
        }
    }

    @Check
    public void checkNoForwardReferences(XExpression fieldInitializer) {
        JvmIdentifiableElement container = this.logicalContainerProvider.getLogicalContainer(fieldInitializer);
        if (container instanceof JvmField) {
            JvmField field = (JvmField)container;
            boolean staticField = field.isStatic();
            JvmDeclaredType declaredType = field.getDeclaringType();
            HashSet illegalFields = Sets.newHashSet();
            int i = declaredType.getMembers().size() - 1;
            while (i >= 0) {
                JvmMember member = (JvmMember)declaredType.getMembers().get(i);
                if (member instanceof JvmField && ((JvmField)member).isStatic() == staticField) {
                    illegalFields.add((JvmField)member);
                }
                if (member == field) break;
                --i;
            }
            TreeIterator iterator = EcoreUtil2.eAll((EObject)fieldInitializer);
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (object instanceof XFeatureCall) {
                    JvmIdentifiableElement feature = ((XFeatureCall)object).getFeature();
                    if (!illegalFields.contains(((XFeatureCall)object).getFeature())) continue;
                    this.error("Cannot reference the field '" + feature.getSimpleName() + "' before it is defined", object, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference", new String[0]);
                    continue;
                }
                if (!(object instanceof XClosure)) continue;
                iterator.prune();
            }
        }
    }

    @Check
    public void checkClosureParams(XClosure closure) {
        if (closure.getFormalParameters().size() > 6) {
            this.error("The maximum number of parameters for a closure is six.", closure, (EStructuralFeature)XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS, 6, "org.eclipse.xtext.xbase.validation.IssueCodes.too_many_params_in_closure", new String[0]);
        }
    }

    @Check
    void checkNullSafeFeatureCallWithPrimitives(XMemberFeatureCall featureCall) {
        if (featureCall.isNullSafe() && this.getActualType(featureCall.getMemberCallTarget()).isPrimitive()) {
            this.error("Cannot use null-safe feature call on primitive receiver", featureCall, (EStructuralFeature)XbasePackage.Literals.XMEMBER_FEATURE_CALL__NULL_SAFE, "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive", new String[0]);
        }
        if (featureCall.isNullSafe() && this.getActualType(featureCall).isPrimitive()) {
            this.addIssue("Null-safe feature call of feature with primitive type", featureCall, "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature");
        }
    }

    @Check
    public void checkLocalUsageOfDeclared(XVariableDeclaration variableDeclaration) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable") && !this.isLocallyUsed(variableDeclaration, variableDeclaration.eContainer())) {
            String message = "The value of the local variable " + variableDeclaration.getName() + " is not used";
            this.addIssueToState("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable", message, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME);
        }
    }

    @Check
    public void checkTypeLiteral(XTypeLiteral typeLiteral) {
        if (!typeLiteral.getArrayDimensions().isEmpty() && typeLiteral.getType().getIdentifier().equals("void")) {
            this.error("'void" + Joiner.on((String)"").join(typeLiteral.getArrayDimensions()) + "' is not a valid type", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type", new String[0]);
        }
    }

    @Check
    public void checkImports(XImportSection importSection) {
        if (importSection.getImportDeclarations().isEmpty()) {
            return;
        }
        HashMap imports = Maps.newHashMap();
        HashMap staticImports = Maps.newHashMap();
        HashMap extensionImports = Maps.newHashMap();
        HashMap importedNames = Maps.newHashMap();
        this.populateMaps(importSection, imports, staticImports, extensionImports, importedNames);
        Set<EObject> primarySourceElements = this.collectPrimarySourceElements(importSection, imports, importedNames);
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued")) {
            for (EObject primarySourceElement : primarySourceElements) {
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)primarySourceElement);
                if (node == null) continue;
                for (INode n : node.getAsTreeIterable()) {
                    if (n.getGrammarElement() instanceof CrossReference) {
                        this.handleTypeUsageInCrossReference(imports, importedNames, n);
                        continue;
                    }
                    if (n.getGrammarElement() instanceof TerminalRule && ((TerminalRule)n.getGrammarElement()).getName().equals("ML_COMMENT")) {
                        this.handleTypeUsageInComment(imports, importedNames, n);
                        continue;
                    }
                    if (!n.hasDirectSemanticElement() || !(n.getSemanticElement() instanceof XAbstractFeatureCall)) continue;
                    this.handleTypeUsageInTypeLiteral(imports, importedNames, (XAbstractFeatureCall)n.getSemanticElement(), n);
                    this.handleTypeUsageInStaticFeatureCall(staticImports, extensionImports, n);
                }
            }
            Iterable obsoleteImports = Iterables.concat(imports.values(), staticImports.values(), extensionImports.values());
            for (XImportDeclaration imp : obsoleteImports) {
                this.addIssue("The import '" + imp.getImportedTypeName() + "' is never used.", imp, "org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued");
            }
        }
    }

    protected void handleTypeUsageInStaticFeatureCall(Map<JvmType, XImportDeclaration> staticImports, Map<JvmType, XImportDeclaration> extensionImports, INode node) {
        JvmIdentifiableElement logicalContainer;
        JvmDeclaredType featureCallOwner;
        JvmFeature feature;
        JvmDeclaredType declaringType;
        JvmIdentifiableElement element;
        XAbstractFeatureCall featureCall = (XAbstractFeatureCall)node.getSemanticElement();
        boolean isExtension = featureCall.isExtension();
        if ((featureCall.isStatic() || isExtension) && !(element = featureCall.getFeature()).eIsProxy() && (declaringType = (feature = (JvmFeature)element).getDeclaringType()) != null && !Iterables.contains((Iterable)(featureCallOwner = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)(logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)), JvmDeclaredType.class)).getAllFeatures(), (Object)feature)) {
            if (isExtension) {
                extensionImports.remove(declaringType);
            } else {
                staticImports.remove(declaringType);
            }
        }
    }

    protected void handleTypeUsageInComment(Map<JvmType, XImportDeclaration> imports, Map<String, JvmType> importedNames, INode n) {
        List typeRefRegions = this.javaDocTypeReferenceProvider.computeTypeRefRegions(n);
        for (ReplaceRegion replaceRegion : typeRefRegions) {
            String simpleName = replaceRegion.getText();
            if (!importedNames.containsKey(simpleName)) continue;
            imports.remove(importedNames.remove(simpleName));
        }
    }

    protected void handleTypeUsageInTypeLiteral(Map<JvmType, XImportDeclaration> imports, Map<String, JvmType> importedNames, XAbstractFeatureCall featureCall, INode node) {
        if (featureCall instanceof XFeatureCall) {
            XFeatureCall casted = (XFeatureCall)featureCall;
            if (casted.isPackageFragment() || !casted.isTypeLiteral()) {
                return;
            }
            this.doHandleTypeReference(imports, importedNames, node);
        }
    }

    protected void handleTypeUsageInCrossReference(Map<JvmType, XImportDeclaration> imports, Map<String, JvmType> importedNames, INode n) {
        CrossReference crossReference = (CrossReference)n.getGrammarElement();
        EClassifier classifier = crossReference.getType().getClassifier();
        if (classifier instanceof EClass && (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf((EClass)classifier) || TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf((EClass)classifier))) {
            this.doHandleTypeReference(imports, importedNames, n);
        }
    }

    private void doHandleTypeReference(Map<JvmType, XImportDeclaration> imports, Map<String, JvmType> importedNames, INode n) {
        StringBuilder builder = new StringBuilder();
        for (ILeafNode leafNode : n.getLeafNodes()) {
            if (leafNode.isHidden()) continue;
            builder.append(leafNode.getText());
        }
        String simpleName = builder.toString();
        if (importedNames.containsKey(simpleName)) {
            JvmType type = importedNames.remove(simpleName);
            imports.remove(type);
        } else {
            if (this.markImportUsed(imports, importedNames, simpleName, "$")) {
                return;
            }
            if (this.markImportUsed(imports, importedNames, simpleName, ".")) {
                return;
            }
            if (this.markImportUsed(imports, importedNames, simpleName, "::")) {
                return;
            }
        }
    }

    protected boolean markImportUsed(Map<JvmType, XImportDeclaration> imports, Map<String, JvmType> importedNames, String simpleName, String delimiter) {
        int idx = simpleName.indexOf(delimiter);
        if (idx < 0) {
            return false;
        }
        String firstSegment = simpleName.substring(0, idx);
        if (importedNames.containsKey(firstSegment)) {
            imports.remove(importedNames.remove(firstSegment));
        }
        return true;
    }

    protected Set<EObject> collectPrimarySourceElements(XImportSection importSection, Map<JvmType, XImportDeclaration> imports, Map<String, JvmType> importedNames) {
        HashSet primarySourceElements = Sets.newHashSet();
        for (JvmDeclaredType declaredType : this.importsConfiguration.getLocallyDefinedTypes((XtextResource)importSection.eResource())) {
            EObject primarySourceElement;
            XImportDeclaration importDeclaration;
            JvmType importedType;
            if (importedNames.containsKey(declaredType.getSimpleName()) && (importedType = importedNames.get(declaredType.getSimpleName())) != declaredType && importedType.eResource() != importSection.eResource() && (importDeclaration = imports.get(importedType)) != null) {
                this.error("The import '" + importedType.getIdentifier() + "' conflicts with a type defined in the same file", importDeclaration, null, "org.eclipse.xtext.xbase.validation.IssueCodes.import_conflict", new String[0]);
            }
            if ((primarySourceElement = this.associations.getPrimarySourceElement((EObject)declaredType)) == null) continue;
            primarySourceElements.add(primarySourceElement);
        }
        return primarySourceElements;
    }

    protected void populateMaps(XImportSection importSection, Map<JvmType, XImportDeclaration> imports, Map<JvmType, XImportDeclaration> staticImports, Map<JvmType, XImportDeclaration> extensionImports, Map<String, JvmType> importedNames) {
        for (XImportDeclaration imp : importSection.getImportDeclarations()) {
            Map<JvmType, XImportDeclaration> map;
            if (imp.getImportedNamespace() != null) {
                this.addIssue("The use of wildcard imports is deprecated.", imp, "org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated");
                continue;
            }
            JvmDeclaredType importedType = imp.getImportedType();
            if (importedType == null || importedType.eIsProxy()) continue;
            Map<JvmType, XImportDeclaration> map2 = imp.isStatic() ? (imp.isExtension() ? extensionImports : staticImports) : (map = imports);
            if (imp.isStatic()) {
                if (imp.isExtension()) {
                    XImportDeclaration staticImport = staticImports.get(importedType);
                    if (staticImport != null) {
                        this.addIssue("Obsolete static import of '" + importedType.getSimpleName() + "'.", staticImport, "org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate");
                    }
                } else if (extensionImports.containsKey(importedType)) {
                    this.addIssue("Obsolete static import of '" + importedType.getSimpleName() + "'.", imp, "org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate");
                }
            }
            if (map.containsKey(importedType)) {
                this.addIssue("Duplicate import of '" + importedType.getSimpleName() + "'.", imp, "org.eclipse.xtext.xbase.validation.IssueCodes.import_duplicate");
                continue;
            }
            map.put((JvmType)importedType, imp);
            if (imp.isStatic()) continue;
            JvmDeclaredType currentType = importedType;
            String currentSuffix = currentType.getSimpleName();
            JvmType collidingImport = importedNames.put(currentSuffix, (JvmType)importedType);
            if (collidingImport != null) {
                this.error("The import '" + importedType.getIdentifier() + "' collides with the import '" + collidingImport.getIdentifier() + "'.", imp, null, "org.eclipse.xtext.xbase.validation.IssueCodes.import_collision", new String[0]);
            }
            while (currentType.eContainer() instanceof JvmType) {
                currentSuffix = String.valueOf((currentType = (JvmType)currentType.eContainer()).getSimpleName()) + "$" + currentSuffix;
                JvmType collidingImport2 = importedNames.put(currentSuffix, (JvmType)importedType);
                if (collidingImport2 == null) continue;
                this.error("The import '" + importedType.getIdentifier() + "' collides with the import '" + collidingImport2.getIdentifier() + "'.", imp, null, "org.eclipse.xtext.xbase.validation.IssueCodes.import_collision", new String[0]);
            }
        }
    }

    @Check
    public void checkPrimitiveComparedToNull(XBinaryOperation binaryOperation) {
        LightweightTypeReference leftType;
        boolean equalsComparison;
        String operatorSymbol = binaryOperation.getConcreteSyntaxFeatureName();
        XExpression left = binaryOperation.getLeftOperand();
        XExpression right = binaryOperation.getRightOperand();
        boolean bl = equalsComparison = this.expressionHelper.isOperatorFromExtension(binaryOperation, OperatorMapping.EQUALS, ObjectExtensions.class) || this.expressionHelper.isOperatorFromExtension(binaryOperation, OperatorMapping.NOT_EQUALS, ObjectExtensions.class);
        if (equalsComparison || this.expressionHelper.isOperatorFromExtension(binaryOperation, OperatorMapping.TRIPLE_NOT_EQUALS, ObjectExtensions.class) || this.expressionHelper.isOperatorFromExtension(binaryOperation, OperatorMapping.TRIPLE_EQUALS, ObjectExtensions.class)) {
            LightweightTypeReference rightType;
            LightweightTypeReference leftType2;
            if (right instanceof XNullLiteral && (leftType2 = this.typeResolver.resolveTypes(left).getActualType(left)) != null) {
                if (leftType2.isPrimitive()) {
                    this.error("The operator '" + operatorSymbol + "' is undefined for the argument types " + leftType2.getSimpleName() + " and null", binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
                } else if (equalsComparison) {
                    this.addIssue("The operator '" + operatorSymbol + "' should be replaced by '" + operatorSymbol + "=' when null is one of the arguments.", binaryOperation, "org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null");
                }
            }
            if (left instanceof XNullLiteral && (rightType = this.typeResolver.resolveTypes(right).getActualType(right)) != null) {
                if (rightType.isPrimitive()) {
                    this.error("The operator '" + operatorSymbol + "' is undefined for the argument types null and " + rightType.getSimpleName(), binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
                } else if (equalsComparison && !(right instanceof XNullLiteral)) {
                    this.addIssue("The operator '" + operatorSymbol + "' should be replaced by '" + operatorSymbol + "=' when null is one of the arguments.", binaryOperation, "org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null");
                }
            }
        } else if (this.expressionHelper.isOperatorFromExtension(binaryOperation, OperatorMapping.ELVIS, ObjectExtensions.class) && (leftType = this.getActualType(left)).isPrimitive()) {
            this.error("The operator '" + operatorSymbol + "' is undefined for arguments of type " + leftType.getSimpleName(), binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
        }
    }

    protected boolean isLocallyUsed(EObject target, EObject containerToFindUsage) {
        return !XbaseUsageCrossReferencer.find(target, containerToFindUsage).isEmpty();
    }

    @Override
    protected List<EPackage> getEPackages() {
        return Lists.newArrayList((Object[])new EPackage[]{XbasePackage.eINSTANCE, XtypePackage.eINSTANCE, TypesPackage.eINSTANCE});
    }

    protected String canonicalName(LightweightTypeReference typeRef) {
        return typeRef == null ? "<null>" : typeRef.getSimpleName();
    }

    protected boolean isInterface(JvmType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected XExpressionHelper getExpressionHelper() {
        return this.expressionHelper;
    }

    @Check
    public void checkNoJavaStyleTypeCasting(XBlockExpression blockExpression) {
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast")) {
            return;
        }
        if (blockExpression.getExpressions().size() <= 1) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)blockExpression);
        if (node == null) {
            return;
        }
        INode expressionNode = null;
        for (INode child : node.getChildren()) {
            if (this.isSemicolon(child)) {
                expressionNode = null;
                continue;
            }
            if (!this.isXExpressionInsideBlock(child)) continue;
            if (expressionNode != null) {
                this.checkNoJavaStyleTypeCasting(expressionNode);
            }
            expressionNode = child;
        }
    }

    protected boolean isXExpressionInsideBlock(INode child) {
        return child.getGrammarElement() == this.grammarAccess.getXBlockExpressionAccess().getExpressionsXExpressionInsideBlockParserRuleCall_2_0_0() || child.getGrammarElement() == this.grammarAccess.getXExpressionInClosureAccess().getExpressionsXExpressionInsideBlockParserRuleCall_1_0_0();
    }

    protected boolean isSemicolon(INode child) {
        return child.getGrammarElement() == this.grammarAccess.getXBlockExpressionAccess().getSemicolonKeyword_2_1() || child.getGrammarElement() == this.grammarAccess.getXExpressionInClosureAccess().getSemicolonKeyword_1_1();
    }

    protected void checkNoJavaStyleTypeCasting(INode node) {
        XAbstractFeatureCall featureCall;
        INode expressionNode;
        EObject semanticObject;
        BidiTreeIterator iterator = node.getAsTreeIterable().reverse().iterator();
        ILeafNode child = this.getFirstLeafNode((BidiTreeIterator<INode>)iterator);
        if (child != null && child.getGrammarElement() == this.grammarAccess.getXParenthesizedExpressionAccess().getRightParenthesisKeyword_2() && ((semanticObject = NodeModelUtils.findActualSemanticObjectFor((INode)(expressionNode = this.getNode((BidiTreeIterator<INode>)iterator, new EObject[]{this.grammarAccess.getXParenthesizedExpressionAccess().getXExpressionParserRuleCall_1()})))) instanceof XFeatureCall || semanticObject instanceof XMemberFeatureCall) && (featureCall = (XAbstractFeatureCall)semanticObject).isTypeLiteral()) {
            ICompositeNode parenthesizedNode = child.getParent();
            ITextRegion parenthesizedRegion = parenthesizedNode.getTextRegion();
            this.addIssue("Use 'as' keyword for type casting.", featureCall, parenthesizedRegion.getOffset(), parenthesizedRegion.getLength(), "org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast");
        }
    }

    protected INode getNode(BidiTreeIterator<INode> iterator, EObject ... grammarElements) {
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            EObject grammarElement = node.getGrammarElement();
            EObject[] eObjectArray = grammarElements;
            int n = grammarElements.length;
            int n2 = 0;
            while (n2 < n) {
                EObject expectedGrammarElement = eObjectArray[n2];
                if (grammarElement == expectedGrammarElement) {
                    return node;
                }
                ++n2;
            }
        }
        return null;
    }

    protected ILeafNode getFirstLeafNode(BidiTreeIterator<INode> iterator) {
        while (iterator.hasNext()) {
            INode child = (INode)iterator.next();
            if (this.isHidden(child) || !(child instanceof ILeafNode)) continue;
            return (ILeafNode)child;
        }
        return null;
    }

    protected boolean isHidden(INode child) {
        return child instanceof ILeafNode && ((ILeafNode)child).isHidden();
    }

    @Check
    public void checkDuplicatedCases(XSwitchExpression switchExpression) {
        if (!this.switchExpressions.isJavaSwitchExpression(switchExpression)) {
            return;
        }
        HashMultimap duplicatedCases = HashMultimap.create();
        for (XCasePart casePart : switchExpression.getCases()) {
            if (!this.switchExpressions.isJavaCaseExpression(switchExpression, casePart)) continue;
            Object result = this.switchConstantExpressionsInterpreter.evaluate(casePart.getCase());
            duplicatedCases.put(result, (Object)casePart);
        }
        for (Object result : duplicatedCases.keySet()) {
            Collection cases = duplicatedCases.get(result);
            if (cases.size() <= 1) continue;
            for (XCasePart casePart : cases) {
                this.error("Duplicate case", casePart.getCase(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_case", new String[0]);
            }
        }
    }

    @Check
    public void checkTypeGuardsOrder(XSwitchExpression expression) {
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case")) {
            return;
        }
        OwnedConverter converter = new OwnedConverter(new StandardTypeReferenceOwner(this.getServices(), expression));
        ArrayList<LightweightTypeReference> previousTypeReferences = new ArrayList<LightweightTypeReference>();
        for (XCasePart casePart : expression.getCases()) {
            LightweightTypeReference actualType;
            JvmTypeReference typeGuard = casePart.getTypeGuard();
            if (typeGuard == null || (actualType = converter.toLightweightReference(typeGuard)) == null) continue;
            if (this.isHandled(actualType, previousTypeReferences)) {
                this.addIssue("Unreachable code: The case can never match. It is already handled by a previous condition.", (EObject)typeGuard, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case");
                continue;
            }
            if (casePart.getCase() != null) continue;
            previousTypeReferences.add(actualType);
        }
    }

    @Check
    public void checkInstanceOfOrder(XIfExpression expression) {
        XIfExpression container;
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of")) {
            return;
        }
        if (expression.eContainer() instanceof XIfExpression && (container = (XIfExpression)expression.eContainer()).getElse() == expression) {
            return;
        }
        List<XExpression> ifParts = this.collectIfParts(expression, new ArrayList<XExpression>());
        OwnedConverter converter = new OwnedConverter(new StandardTypeReferenceOwner(this.getServices(), expression));
        HashMultimap previousTypeReferences = HashMultimap.create();
        for (XExpression ifPart : ifParts) {
            JvmTypeReference type;
            LightweightTypeReference actualType;
            XAbstractFeatureCall featureCall;
            JvmIdentifiableElement feature;
            XInstanceOfExpression instanceOfExpression;
            if (!(ifPart instanceof XInstanceOfExpression) || !((instanceOfExpression = (XInstanceOfExpression)ifPart).getExpression() instanceof XAbstractFeatureCall) || !((feature = (featureCall = (XAbstractFeatureCall)instanceOfExpression.getExpression()).getFeature()) instanceof XVariableDeclaration) && !(feature instanceof JvmField) && !(feature instanceof JvmFormalParameter) || (actualType = converter.toLightweightReference(type = instanceOfExpression.getType())) == null) continue;
            if (this.isHandled(actualType, previousTypeReferences.get((Object)feature))) {
                this.addIssue("Unreachable code: The if condition can never match. It is already handled by a previous condition.", (EObject)type, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of");
                continue;
            }
            previousTypeReferences.put((Object)feature, (Object)actualType);
        }
    }

    private List<XExpression> collectIfParts(XIfExpression expression, List<XExpression> result) {
        result.add(expression.getIf());
        if (expression.getElse() instanceof XIfExpression) {
            this.collectIfParts((XIfExpression)expression.getElse(), result);
        }
        return result;
    }

    @Check
    public void checkCatchClausesOrder(XTryCatchFinallyExpression expression) {
        OwnedConverter converter = new OwnedConverter(new StandardTypeReferenceOwner(this.getServices(), expression));
        ArrayList<LightweightTypeReference> previousTypeReferences = new ArrayList<LightweightTypeReference>();
        for (XCatchClause catchClause : expression.getCatchClauses()) {
            LightweightTypeReference actualTypeReference = converter.toLightweightReference(catchClause.getDeclaredParam().getParameterType());
            if (actualTypeReference == null) continue;
            if (this.isHandled(actualTypeReference, previousTypeReferences)) {
                this.error("Unreachable code: The catch block can never match. It is already handled by a previous condition.", (EObject)catchClause.getDeclaredParam().getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_catch_block", new String[0]);
                continue;
            }
            previousTypeReferences.add(actualTypeReference);
        }
    }

    protected boolean isHandled(LightweightTypeReference actualTypeReference, Collection<LightweightTypeReference> collection) {
        return this.typesOrderUtil.isHandled(actualTypeReference, collection);
    }
}

