/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.tasks.ITaskFinder;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.ui.markers.IMarkerContributor;
import org.eclipse.xtext.ui.tasks.TaskMarkerCreator;
import org.eclipse.xtext.ui.tasks.TaskMarkerTypeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMarkerContributor
implements IMarkerContributor {
    private static final Logger log = Logger.getLogger(TaskMarkerContributor.class);
    @Inject
    private TaskMarkerCreator markerCreator;
    @Inject
    private ITaskFinder taskFinder;
    @Inject
    private TaskMarkerTypeProvider typeProvider;

    @Override
    public void updateMarkers(IFile file, Resource resource, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            List tasks = this.taskFinder.findTasks(resource);
            boolean _isCanceled = subMonitor.isCanceled();
            if (_isCanceled) {
                throw new OperationCanceledException();
            }
            subMonitor.worked(1);
            this.deleteMarkers(file, (IProgressMonitor)subMonitor);
            this.createTaskMarkers(file, tasks, (IProgressMonitor)subMonitor);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                String _message = e.getMessage();
                log.error((Object)_message, (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void createTaskMarkers(IFile file, List<Task> tasks, IProgressMonitor monitor) throws CoreException {
        for (Task task : tasks) {
            String _markerType = this.typeProvider.getMarkerType(task);
            this.markerCreator.createMarker(task, (IResource)file, _markerType);
        }
    }

    @Override
    public void deleteMarkers(IFile file, IProgressMonitor monitor) {
        try {
            file.deleteMarkers("org.eclipse.xtext.ui.task", true, 0);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

