/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetInitializer;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;

@Singleton
public class XtextResourceSetProvider
implements IResourceSetProvider {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    private ImmutableList<? extends IResourceSetInitializer> initializers = ImmutableList.of();

    @Inject
    private void setContributions(ISharedStateContributionRegistry contributionRegistry) {
        this.initializers = contributionRegistry.getContributedInstances(IResourceSetInitializer.class);
    }

    public ResourceSet get(IProject project) {
        XtextResourceSet set = (XtextResourceSet)this.resourceSetProvider.get();
        int i = 0;
        while (i < this.initializers.size()) {
            ((IResourceSetInitializer)this.initializers.get(i)).initialize((ResourceSet)set, project);
            ++i;
        }
        return set;
    }
}

