/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.DefaultTraceURIConverter;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.generator.trace.ITraceURIConverterContribution;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleTraceURIConverter
extends DefaultTraceURIConverter {
    private ITraceURIConverterContribution contribution;

    @Inject
    private void initializeContribution(ISharedStateContributionRegistry registry) {
        this.contribution = this.getContribution(registry.getContributedInstances(ITraceURIConverterContribution.class));
    }

    private ITraceURIConverterContribution getContribution(ImmutableList<? extends ITraceURIConverterContribution> allContributions) {
        switch (allContributions.size()) {
            case 0: {
                return new NullContribution();
            }
            case 1: {
                return (ITraceURIConverterContribution)allContributions.get(0);
            }
        }
        return new CompositeContribution(allContributions);
    }

    public URI getURIForTrace(XtextResource context) {
        URI result = this.contribution.getURIForTrace(context);
        if (result != null) {
            return result;
        }
        return super.getURIForTrace(context);
    }

    public URI getURIForTrace(URI uri) {
        URI result = this.contribution.getURIForTrace(uri);
        if (result != null) {
            return result;
        }
        return super.getURIForTrace(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompositeContribution
    implements ITraceURIConverterContribution {
        private ImmutableList<? extends ITraceURIConverterContribution> contributions;

        public CompositeContribution(ImmutableList<? extends ITraceURIConverterContribution> contributions) {
            this.contributions = contributions;
        }

        @Override
        public URI getURIForTrace(XtextResource context) {
            int i = 0;
            int size = this.contributions.size();
            while (i < size) {
                URI result = ((ITraceURIConverterContribution)this.contributions.get(i)).getURIForTrace(context);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }

        @Override
        public URI getURIForTrace(URI uri) {
            int i = 0;
            int size = this.contributions.size();
            while (i < size) {
                URI result = ((ITraceURIConverterContribution)this.contributions.get(i)).getURIForTrace(uri);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }
    }

    public static final class NullContribution
    implements ITraceURIConverterContribution {
        public URI getURIForTrace(XtextResource context) {
            return null;
        }

        public URI getURIForTrace(URI uri) {
            return null;
        }
    }
}

