/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.controlflow;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.controlflow.BooleanResult;
import org.eclipse.xtext.xbase.controlflow.EvaluationContext;
import org.eclipse.xtext.xbase.controlflow.EvaluationResult;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.ConstantOperators;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.scoping.XImportSectionNamespaceScopeProvider;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;

@Accessors(value={AccessorType.PROTECTED_GETTER})
public class ConstantConditionsInterpreter {
    @Inject
    @Extension
    private ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    @Extension
    private NumberLiterals numberLiterals;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ConstantOperators constantOperators;

    public BooleanResult getBooleanConstantOrNull(XExpression it) {
        try {
            IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(it);
            RecursionGuard<EObject> _recursionGuard = new RecursionGuard<EObject>();
            EvaluationContext context = new EvaluationContext(resolvedTypes, _recursionGuard);
            EvaluationResult evaluationResult = this.evaluate(it, context);
            Object _value = evaluationResult.getValue();
            if (_value instanceof Boolean) {
                Object _value_1 = evaluationResult.getValue();
                boolean _isCompileTimeConstant = evaluationResult.isCompileTimeConstant();
                return new BooleanResult((Boolean)_value_1, _isCompileTimeConstant);
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                return null;
            }
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e_1 = (IllegalArgumentException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public EvaluationResult evaluate(XExpression expression, EvaluationContext context) {
        RecursionGuard<EObject> _visiting = context.getVisiting();
        boolean _tryNext = _visiting.tryNext(expression);
        if (_tryNext) {
            try {
                EvaluationResult evaluationResult = this.internalEvaluate(expression, context);
                return evaluationResult;
            }
            finally {
                RecursionGuard<EObject> _visiting_1 = context.getVisiting();
                _visiting_1.done(expression);
            }
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalEvaluate(XExpression expression, EvaluationContext context) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalEvaluate(Void nullValue, EvaluationContext context) {
        throw new ConstantExpressionEvaluationException("null");
    }

    protected EvaluationResult _internalEvaluate(XNumberLiteral it, EvaluationContext context) {
        Class<? extends Number> _javaType = this.numberLiterals.getJavaType(it);
        Number value = this.numberLiterals.numberValue(it, _javaType);
        IResolvedTypes _resolvedTypes = context.getResolvedTypes();
        LightweightTypeReference _actualType = _resolvedTypes.getActualType(it);
        boolean _isPrimitive = _actualType.isPrimitive();
        return new EvaluationResult(value, _isPrimitive);
    }

    protected EvaluationResult _internalEvaluate(XAbstractFeatureCall it, EvaluationContext context) {
        boolean _notEquals;
        JvmIdentifiableElement feature = it.getFeature();
        boolean _eIsProxy = feature.eIsProxy();
        if (_eIsProxy) {
            return EvaluationResult.NOT_A_CONSTANT;
        }
        boolean _matched = false;
        if (!_matched) {
            if (feature instanceof JvmType) {
                _matched = true;
            }
            if (!_matched && feature instanceof JvmEnumerationLiteral) {
                _matched = true;
            }
            if (_matched) {
                return new EvaluationResult(feature, true);
            }
        }
        if (!_matched && feature instanceof JvmField) {
            _matched = true;
            boolean _isSetConstant = ((JvmField)feature).isSetConstant();
            if (_isSetConstant) {
                boolean _isConstant = ((JvmField)feature).isConstant();
                if (_isConstant) {
                    Object _constantValue = ((JvmField)feature).getConstantValue();
                    return new EvaluationResult(_constantValue, true);
                }
            } else {
                boolean _isFinal = ((JvmField)feature).isFinal();
                if (_isFinal) {
                    boolean _notEquals_2;
                    boolean _notEquals2;
                    XExpression _actualReceiver = it.getActualReceiver();
                    boolean bl = _notEquals2 = !Objects.equal((Object)_actualReceiver, null);
                    if (_notEquals2) {
                        Object _value_1;
                        boolean _notEquals_1;
                        XExpression _actualReceiver_1 = it.getActualReceiver();
                        EvaluationResult receiver = this.evaluate(_actualReceiver_1, context);
                        boolean _isNotAConstant = receiver.isNotAConstant();
                        if (_isNotAConstant) {
                            return receiver;
                        }
                        XExpression associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression(feature);
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)associatedExpression, null);
                        if (_notEquals_1) {
                            EvaluationResult result = this.evaluateAssociatedExpression(associatedExpression, context);
                            Object _value = result.getValue();
                            return new EvaluationResult(_value, false);
                        }
                        ArrayList _switchResult_1 = null;
                        Object v = _value_1 = receiver.getValue();
                        boolean _matched_1 = false;
                        if (!_matched_1 && v instanceof JvmIdentifiableElement) {
                            _matched_1 = true;
                            _switchResult_1 = CollectionLiterals.newArrayList((Object[])new JvmIdentifiableElement[]{(JvmIdentifiableElement)v});
                        }
                        if (!_matched_1 && v instanceof List) {
                            _matched_1 = true;
                            _switchResult_1 = new ArrayList((Collection)v);
                        }
                        ArrayList list = _switchResult_1;
                        list.add(feature);
                        return new EvaluationResult(list, false);
                    }
                    XExpression associatedExpression_1 = this._iLogicalContainerProvider.getAssociatedExpression(feature);
                    boolean bl3 = _notEquals_2 = !Objects.equal((Object)associatedExpression_1, null);
                    if (_notEquals_2) {
                        EvaluationResult result_1 = this.evaluateAssociatedExpression(associatedExpression_1, context);
                        Object _value_2 = result_1.getValue();
                        return new EvaluationResult(_value_2, false);
                    }
                    ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new JvmField[]{(JvmField)feature});
                    return new EvaluationResult(_newArrayList, false);
                }
            }
        }
        if (!_matched && feature instanceof XVariableDeclaration) {
            XExpression _right;
            boolean _not;
            boolean _and = false;
            boolean _isWriteable = ((XVariableDeclaration)feature).isWriteable();
            boolean bl = _not = !_isWriteable;
            _and = !_not ? false : (_notEquals = !Objects.equal((Object)(_right = ((XVariableDeclaration)feature).getRight()), null));
            if (_and) {
                _matched = true;
                XExpression _right_1 = ((XVariableDeclaration)feature).getRight();
                return this.evaluateAssociatedExpression(_right_1, context);
            }
        }
        if (!_matched && feature instanceof JvmFormalParameter) {
            EObject _eContainer;
            _matched = true;
            EObject container = _eContainer = ((JvmFormalParameter)feature).eContainer();
            boolean _matched_1 = false;
            if (!_matched_1 && container instanceof XSwitchExpression) {
                XExpression _switch = ((XSwitchExpression)container).getSwitch();
                boolean bl = _notEquals = !Objects.equal((Object)_switch, null);
                if (_notEquals) {
                    _matched_1 = true;
                    XExpression _switch_1 = ((XSwitchExpression)container).getSwitch();
                    return this.evaluate(_switch_1, context);
                }
            }
            return new EvaluationResult(feature, false);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    public EvaluationResult evaluateAssociatedExpression(XExpression it, EvaluationContext context) {
        JvmIdentifiableElement _feature;
        EvaluationResult _switchResult = null;
        boolean _matched = false;
        if (!_matched && it instanceof XAbstractFeatureCall && (_feature = ((XAbstractFeatureCall)it).getFeature()) instanceof JvmEnumerationLiteral) {
            _matched = true;
            EvaluationResult arg = this.evaluate(it, context);
            Object _value = arg.getValue();
            return new EvaluationResult(_value, false);
        }
        if (!_matched) {
            _switchResult = this.evaluate(it, context);
        }
        return _switchResult;
    }

    protected EvaluationResult _internalEvaluate(XNullLiteral it, EvaluationContext context) {
        return new EvaluationResult(null, true);
    }

    private boolean isFromXbaseLibrary(XAbstractFeatureCall it) {
        boolean _eIsProxy;
        boolean _xblockexpression = false;
        JvmIdentifiableElement feature = it.getFeature();
        boolean _and = false;
        boolean _notEquals = !Objects.equal((Object)feature, null);
        _and = !_notEquals ? false : (_eIsProxy = feature.eIsProxy());
        if (_and) {
            throw new IllegalArgumentException("proxy");
        }
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && feature instanceof JvmMember) {
            _matched = true;
            JvmDeclaredType _declaringType = null;
            if ((JvmMember)feature != null) {
                _declaringType = ((JvmMember)feature).getDeclaringType();
            }
            String _packageName = null;
            if (_declaringType != null) {
                _packageName = _declaringType.getPackageName();
            }
            String _string = XImportSectionNamespaceScopeProvider.XBASE_LIB.toString();
            _switchResult = Objects.equal((Object)_packageName, (Object)_string);
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected EvaluationResult _internalEvaluate(XUnaryOperation it, EvaluationContext context) {
        EvaluationResult _switchResult;
        EvaluationResult _xblockexpression;
        EvaluationResult _xifexpression = null;
        boolean _isFromXbaseLibrary = this.isFromXbaseLibrary(it);
        if (_isFromXbaseLibrary) {
            _xblockexpression = null;
            XExpression _operand = it.getOperand();
            EvaluationResult arg = this.evaluate(_operand, context);
            String op = it.getConcreteSyntaxFeatureName();
            _switchResult = null;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)op, (Object)"-")) {
                _matched = true;
                try {
                    Object _value = arg.getValue();
                    Object result = this.constantOperators.minus(_value);
                    boolean _isCompileTimeConstant = arg.isCompileTimeConstant();
                    return new EvaluationResult(result, _isCompileTimeConstant);
                }
                catch (Throwable _t) {
                    if (_t instanceof ConstantExpressionEvaluationException) {
                        ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                        return EvaluationResult.NOT_A_CONSTANT;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            if (!_matched) {
                boolean _and = false;
                boolean _equals = Objects.equal((Object)op, (Object)"!");
                if (!_equals) {
                    _and = false;
                } else {
                    Object _value_1 = arg.getValue();
                    _and = _value_1 instanceof Boolean;
                }
                if (_and) {
                    _matched = true;
                    boolean _isCompileTimeConstant_1 = arg.isCompileTimeConstant();
                    _switchResult = new EvaluationResult((Boolean)arg.getValue() == false, _isCompileTimeConstant_1);
                }
            }
            if (!_matched) {
                boolean _and_1 = false;
                boolean _equals_1 = Objects.equal((Object)op, (Object)"+");
                if (!_equals_1) {
                    _and_1 = false;
                } else {
                    Object _value_2 = arg.getValue();
                    _and_1 = _value_2 instanceof Number;
                }
                if (_and_1) {
                    _matched = true;
                    _switchResult = arg;
                }
            }
            if (!_matched) {
                _switchResult = EvaluationResult.NOT_A_CONSTANT;
            }
        } else {
            return EvaluationResult.NOT_A_CONSTANT;
        }
        _xifexpression = _xblockexpression = _switchResult;
        return _xifexpression;
    }

    protected EvaluationResult _internalEvaluate(XBinaryOperation it, EvaluationContext context) {
        boolean _isFromXbaseLibrary = this.isFromXbaseLibrary(it);
        if (_isFromXbaseLibrary) {
            XExpression _leftOperand = it.getLeftOperand();
            EvaluationResult left = this.evaluate(_leftOperand, context);
            XExpression _rightOperand = it.getRightOperand();
            EvaluationResult right = this.evaluate(_rightOperand, context);
            try {
                boolean _isCompileTimeConstant_9;
                String op = it.getConcreteSyntaxFeatureName();
                Object _switchResult = null;
                boolean _matched = false;
                if (!_matched && Objects.equal((Object)op, (Object)"+")) {
                    _matched = true;
                    Object _value = left.getValue();
                    Object _value_1 = right.getValue();
                    _switchResult = this.constantOperators.plus(_value, _value_1);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"-")) {
                    _matched = true;
                    Object _value_2 = left.getValue();
                    Object _value_3 = right.getValue();
                    _switchResult = this.constantOperators.minus(_value_2, _value_3);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"*")) {
                    _matched = true;
                    Object _value_4 = left.getValue();
                    Object _value_5 = right.getValue();
                    _switchResult = this.constantOperators.multiply(_value_4, _value_5);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"/")) {
                    _matched = true;
                    Object _value_6 = left.getValue();
                    Object _value_7 = right.getValue();
                    _switchResult = this.constantOperators.divide(_value_6, _value_7);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"%")) {
                    _matched = true;
                    Object _value_8 = left.getValue();
                    Object _value_9 = right.getValue();
                    _switchResult = this.constantOperators.modulo(_value_8, _value_9);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"<<")) {
                    _matched = true;
                    Object _value_10 = left.getValue();
                    Object _value_11 = right.getValue();
                    _switchResult = this.constantOperators.shiftLeft(_value_10, _value_11);
                }
                if (!_matched && Objects.equal((Object)op, (Object)">>")) {
                    _matched = true;
                    Object _value_12 = left.getValue();
                    Object _value_13 = right.getValue();
                    _switchResult = this.constantOperators.shiftRight(_value_12, _value_13);
                }
                if (!_matched && Objects.equal((Object)op, (Object)">>>")) {
                    _matched = true;
                    Object _value_14 = left.getValue();
                    Object _value_15 = right.getValue();
                    _switchResult = this.constantOperators.shiftRightUnsigned(_value_14, _value_15);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"<")) {
                    _matched = true;
                    Object _value_16 = left.getValue();
                    Object _value_17 = right.getValue();
                    _switchResult = this.constantOperators.lessThan(_value_16, _value_17);
                }
                if (!_matched && Objects.equal((Object)op, (Object)">")) {
                    _matched = true;
                    Object _value_18 = left.getValue();
                    Object _value_19 = right.getValue();
                    _switchResult = this.constantOperators.greaterThan(_value_18, _value_19);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"<=")) {
                    _matched = true;
                    Object _value_20 = left.getValue();
                    Object _value_21 = right.getValue();
                    _switchResult = this.constantOperators.lessEquals(_value_20, _value_21);
                }
                if (!_matched && Objects.equal((Object)op, (Object)">=")) {
                    _matched = true;
                    Object _value_22 = left.getValue();
                    Object _value_23 = right.getValue();
                    _switchResult = this.constantOperators.greaterEquals(_value_22, _value_23);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"&&")) {
                    boolean _isCompileTimeConstant_1;
                    _matched = true;
                    Object _value_24 = left.getValue();
                    Object _value_25 = right.getValue();
                    boolean _and = false;
                    boolean _isCompileTimeConstant = left.isCompileTimeConstant();
                    _and = !_isCompileTimeConstant ? false : (_isCompileTimeConstant_1 = right.isCompileTimeConstant());
                    return this.internalLogicalAnd(_value_24, _value_25, _and);
                }
                if (!_matched && Objects.equal((Object)op, (Object)"||")) {
                    boolean _isCompileTimeConstant_3;
                    _matched = true;
                    Object _value_26 = left.getValue();
                    Object _value_27 = right.getValue();
                    boolean _and_1 = false;
                    boolean _isCompileTimeConstant_2 = left.isCompileTimeConstant();
                    _and_1 = !_isCompileTimeConstant_2 ? false : (_isCompileTimeConstant_3 = right.isCompileTimeConstant());
                    return this.internalLogicalOr(_value_26, _value_27, _and_1);
                }
                if (!_matched) {
                    if (Objects.equal((Object)op, (Object)"==")) {
                        _matched = true;
                    }
                    if (!_matched && Objects.equal((Object)op, (Object)"===")) {
                        _matched = true;
                    }
                    if (_matched) {
                        boolean _isCompileTimeConstant_5;
                        boolean _isNotAConstant_1;
                        boolean _or = false;
                        boolean _isNotAConstant = left.isNotAConstant();
                        _or = _isNotAConstant ? true : (_isNotAConstant_1 = right.isNotAConstant());
                        if (_or) {
                            return EvaluationResult.NOT_A_CONSTANT;
                        }
                        Object _equalValue = left.equalValue(right);
                        boolean _and_2 = false;
                        boolean _isCompileTimeConstant_4 = left.isCompileTimeConstant();
                        _and_2 = !_isCompileTimeConstant_4 ? false : (_isCompileTimeConstant_5 = right.isCompileTimeConstant());
                        return new EvaluationResult(_equalValue, _and_2);
                    }
                }
                if (!_matched) {
                    if (Objects.equal((Object)op, (Object)"!=")) {
                        _matched = true;
                    }
                    if (!_matched && Objects.equal((Object)op, (Object)"!==")) {
                        _matched = true;
                    }
                    if (_matched) {
                        boolean _isCompileTimeConstant_7;
                        boolean _isNotAConstant_3;
                        boolean _or_1 = false;
                        boolean _isNotAConstant_2 = left.isNotAConstant();
                        _or_1 = _isNotAConstant_2 ? true : (_isNotAConstant_3 = right.isNotAConstant());
                        if (_or_1) {
                            return EvaluationResult.NOT_A_CONSTANT;
                        }
                        Object result = left.equalValue(right);
                        boolean _matched_1 = false;
                        if (!_matched_1 && result instanceof Boolean) {
                            boolean _isCompileTimeConstant_72;
                            _matched_1 = true;
                            boolean _and_3 = false;
                            boolean _isCompileTimeConstant_6 = left.isCompileTimeConstant();
                            _and_3 = !_isCompileTimeConstant_6 ? false : (_isCompileTimeConstant_72 = right.isCompileTimeConstant());
                            return new EvaluationResult((Boolean)result == false, _and_3);
                        }
                        boolean _and_3 = false;
                        boolean _isCompileTimeConstant_6 = left.isCompileTimeConstant();
                        _and_3 = !_isCompileTimeConstant_6 ? false : (_isCompileTimeConstant_7 = right.isCompileTimeConstant());
                        return new EvaluationResult(result, _and_3);
                    }
                }
                if (!_matched) {
                    return EvaluationResult.NOT_A_CONSTANT;
                }
                Object value = _switchResult;
                boolean _and_4 = false;
                boolean _isCompileTimeConstant_8 = left.isCompileTimeConstant();
                _and_4 = !_isCompileTimeConstant_8 ? false : (_isCompileTimeConstant_9 = right.isCompileTimeConstant());
                return new EvaluationResult(value, _and_4);
            }
            catch (Throwable _t) {
                if (_t instanceof ConstantExpressionEvaluationException) {
                    ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                    return EvaluationResult.NOT_A_CONSTANT;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Object left, Object right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Boolean left, Boolean right, boolean compileTimeConstant) {
        return new EvaluationResult(left != false && right != false, compileTimeConstant);
    }

    protected EvaluationResult _internalLogicalAnd(Boolean left, Object right, boolean compileTimeConstant) {
        if (!left.booleanValue()) {
            return new EvaluationResult(Boolean.FALSE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Boolean left, Void right, boolean compileTimeConstant) {
        if (!left.booleanValue()) {
            return new EvaluationResult(Boolean.FALSE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Object left, Boolean right, boolean compileTimeConstant) {
        if (!right.booleanValue()) {
            return new EvaluationResult(Boolean.FALSE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalAnd(Void left, Boolean right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Object left, Object right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Boolean left, Boolean right, boolean compileTimeConstant) {
        return new EvaluationResult(left != false || right != false, compileTimeConstant);
    }

    protected EvaluationResult _internalLogicalOr(Boolean left, Object right, boolean compileTimeConstant) {
        if (left.booleanValue()) {
            return new EvaluationResult(Boolean.TRUE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Boolean left, Void right, boolean compileTimeConstant) {
        if (left.booleanValue()) {
            return new EvaluationResult(Boolean.TRUE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Object left, Boolean right, boolean compileTimeConstant) {
        if (right.booleanValue()) {
            return new EvaluationResult(Boolean.TRUE, compileTimeConstant);
        }
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalLogicalOr(Void left, Boolean right, boolean compileTimeConstant) {
        return EvaluationResult.NOT_A_CONSTANT;
    }

    protected EvaluationResult _internalEvaluate(XCastedExpression expression, EvaluationContext context) {
        XExpression _target = expression.getTarget();
        return this.evaluate(_target, context);
    }

    protected EvaluationResult _internalEvaluate(XStringLiteral it, EvaluationContext context) {
        String _value = it.getValue();
        return new EvaluationResult(_value, true);
    }

    protected EvaluationResult _internalEvaluate(XBooleanLiteral it, EvaluationContext context) {
        boolean _isIsTrue = it.isIsTrue();
        return new EvaluationResult(_isIsTrue, true);
    }

    protected EvaluationResult _internalEvaluate(XTypeLiteral it, EvaluationContext context) {
        return new EvaluationResult(it, true);
    }

    public EvaluationResult internalEvaluate(XExpression it, EvaluationContext context) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, context);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, context);
        }
        if (it instanceof XAbstractFeatureCall) {
            return this._internalEvaluate((XAbstractFeatureCall)it, context);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, context);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, context);
        }
        if (it instanceof XNullLiteral) {
            return this._internalEvaluate((XNullLiteral)it, context);
        }
        if (it instanceof XNumberLiteral) {
            return this._internalEvaluate((XNumberLiteral)it, context);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, context);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, context);
        }
        if (it != null) {
            return this._internalEvaluate(it, context);
        }
        if (it == null) {
            return this._internalEvaluate((Void)null, context);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    public EvaluationResult internalLogicalAnd(Object left, Object right, boolean compileTimeConstant) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return this._internalLogicalAnd((Boolean)left, (Boolean)right, compileTimeConstant);
        }
        if (left instanceof Boolean && right == null) {
            return this._internalLogicalAnd((Boolean)left, (Void)null, compileTimeConstant);
        }
        if (left instanceof Boolean && right != null) {
            return this._internalLogicalAnd((Boolean)left, right, compileTimeConstant);
        }
        if (left == null && right instanceof Boolean) {
            return this._internalLogicalAnd((Void)null, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right instanceof Boolean) {
            return this._internalLogicalAnd(left, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right != null) {
            return this._internalLogicalAnd(left, right, compileTimeConstant);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(left, right, compileTimeConstant).toString());
    }

    public EvaluationResult internalLogicalOr(Object left, Object right, boolean compileTimeConstant) {
        if (left instanceof Boolean && right instanceof Boolean) {
            return this._internalLogicalOr((Boolean)left, (Boolean)right, compileTimeConstant);
        }
        if (left instanceof Boolean && right == null) {
            return this._internalLogicalOr((Boolean)left, (Void)null, compileTimeConstant);
        }
        if (left instanceof Boolean && right != null) {
            return this._internalLogicalOr((Boolean)left, right, compileTimeConstant);
        }
        if (left == null && right instanceof Boolean) {
            return this._internalLogicalOr((Void)null, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right instanceof Boolean) {
            return this._internalLogicalOr(left, (Boolean)right, compileTimeConstant);
        }
        if (left != null && right != null) {
            return this._internalLogicalOr(left, right, compileTimeConstant);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(left, right, compileTimeConstant).toString());
    }

    @Pure
    protected ILogicalContainerProvider get_iLogicalContainerProvider() {
        return this._iLogicalContainerProvider;
    }

    @Pure
    protected NumberLiterals getNumberLiterals() {
        return this.numberLiterals;
    }

    @Pure
    protected IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Pure
    protected ConstantOperators getConstantOperators() {
        return this.constantOperators;
    }
}

