/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.macro;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtBasedProcessorProvider
extends ProcessorInstanceForJvmTypeProvider {
    public Object getProcessorInstance(JvmType type) {
        try {
            Resource _eResource = type.eResource();
            ResourceSet _resourceSet = _eResource.getResourceSet();
            Object _classpathURIContext = ((XtextResourceSet)_resourceSet).getClasspathURIContext();
            IJavaProject project = (IJavaProject)_classpathURIContext;
            String _identifier = type.getIdentifier();
            ClassLoader classLoader = this.createClassLoader(_identifier, project);
            String _identifier_1 = type.getIdentifier();
            Class<?> result = classLoader.loadClass(_identifier_1);
            return result.newInstance();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                String _identifier_2 = type.getIdentifier();
                String _plus = "Problem during instantiation of " + _identifier_2;
                String _plus_1 = String.valueOf(_plus) + " : ";
                String _message = e.getMessage();
                String _plus_2 = String.valueOf(_plus_1) + _message;
                throw new IllegalStateException(_plus_2, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public ClassLoader getClassLoader(EObject ctx) {
        Resource _eResource = ctx.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        Object _classpathURIContext = ((XtextResourceSet)_resourceSet).getClasspathURIContext();
        IJavaProject project = (IJavaProject)_classpathURIContext;
        return this.createClassLoaderForJavaProject(project);
    }

    protected ClassLoader createClassLoader(String typeName, IJavaProject javaProject) {
        try {
            URLClassLoader _xblockexpression = null;
            IType type = javaProject.findType(typeName);
            boolean _equals = Objects.equal((Object)type, null);
            if (_equals) {
                Class<?> _class = ((Object)((Object)this)).getClass();
                return _class.getClassLoader();
            }
            IJavaProject projectToUse = type.getJavaProject();
            _xblockexpression = this.createClassLoaderForJavaProject(projectToUse);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected URLClassLoader createClassLoaderForJavaProject(IJavaProject projectToUse) {
        try {
            IClasspathEntry[] resolvedClasspath = projectToUse.getResolvedClasspath(true);
            ArrayList urls = CollectionLiterals.newArrayList((Object[])new URL[0]);
            List<URL> _outputFolders = this.getOutputFolders(projectToUse);
            urls.addAll(_outputFolders);
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _notEquals_1;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                URL url = null;
                int _entryKind = entry.getEntryKind();
                switch (_entryKind) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        IPath path = entry.getPath();
                        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot(projectToUse);
                        IResource project = _workspaceRoot.findMember(path);
                        IProject _project = project.getProject();
                        IJavaProject _create = JavaCore.create((IProject)_project);
                        List<URL> _outputFolders_1 = this.getOutputFolders(_create);
                        urls.addAll(_outputFolders_1);
                        break;
                    }
                    case 1: {
                        boolean _notEquals;
                        IPath path_1 = entry.getPath();
                        IWorkspaceRoot _workspaceRoot_1 = this.getWorkspaceRoot(projectToUse);
                        IResource library = _workspaceRoot_1.findMember(path_1);
                        URL _xifexpression = null;
                        boolean bl = _notEquals = !Objects.equal((Object)library, null);
                        if (_notEquals) {
                            java.net.URI _rawLocationURI = library.getRawLocationURI();
                            _xifexpression = _rawLocationURI.toURL();
                        } else {
                            File _file = path_1.toFile();
                            java.net.URI _uRI = _file.toURI();
                            _xifexpression = _uRI.toURL();
                        }
                        url = _xifexpression;
                        break;
                    }
                    default: {
                        URL _uRL;
                        IPath path_2 = entry.getPath();
                        File _file_1 = path_2.toFile();
                        java.net.URI _uRI_1 = _file_1.toURI();
                        url = _uRL = _uRI_1.toURL();
                    }
                }
                boolean bl = _notEquals_1 = !Objects.equal(url, null);
                if (_notEquals_1) {
                    urls.add(url);
                }
                ++n2;
            }
            ClassLoader _parentClassLoader = this.getParentClassLoader();
            return new URLClassLoader((URL[])Conversions.unwrapArray((Object)urls, URL.class), _parentClassLoader);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ClassLoader getParentClassLoader() {
        ClassLoader bundleClassLoader = TransformationContext.class.getClassLoader();
        return bundleClassLoader;
    }

    private IWorkspaceRoot getWorkspaceRoot(IJavaProject javaProject) {
        IProject _project = javaProject.getProject();
        IWorkspace _workspace = _project.getWorkspace();
        return _workspace.getRoot();
    }

    private List<URL> getOutputFolders(IJavaProject javaProject) {
        try {
            IClasspathEntry[] _rawClasspath;
            ArrayList result = CollectionLiterals.newArrayList((Object[])new URL[0]);
            IPath _outputLocation = javaProject.getOutputLocation();
            IPath path = _outputLocation.addTrailingSeparator();
            String _string = path.toString();
            URI _createPlatformResourceURI = URI.createPlatformResourceURI((String)_string, (boolean)true);
            String _string_1 = _createPlatformResourceURI.toString();
            URL url = new URL(_string_1);
            result.add(url);
            IClasspathEntry[] iClasspathEntryArray = _rawClasspath = javaProject.getRawClasspath();
            int n = _rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                int _entryKind = entry.getEntryKind();
                switch (_entryKind) {
                    case 3: {
                        URL _uRL;
                        boolean _notEquals;
                        IPath _outputLocation_1;
                        path = _outputLocation_1 = entry.getOutputLocation();
                        boolean bl = _notEquals = !Objects.equal((Object)path, null);
                        if (!_notEquals) break;
                        IPath _addTrailingSeparator = path.addTrailingSeparator();
                        String _string_2 = _addTrailingSeparator.toString();
                        URI _createPlatformResourceURI_1 = URI.createPlatformResourceURI((String)_string_2, (boolean)true);
                        String _string_3 = _createPlatformResourceURI_1.toString();
                        url = _uRL = new URL(_string_3);
                        result.add(url);
                    }
                }
                ++n2;
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

