/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.outline.XtendEObjectNode;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtend.ide.outline.XtendOutlineModes;
import org.eclipse.xtend.ide.outline.XtendOutlineNodeFactory;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.BackgroundOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiModeOutlineTreeProvider
extends BackgroundOutlineTreeProvider {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private JvmTypeExtensions typeExtensions;
    private IOutlineTreeProvider.ModeAware modeAware;

    protected XtendFeatureNode createNodeForFeature(IOutlineNode parentNode, JvmDeclaredType inferredType, JvmFeature jvmFeature, EObject semanticFeature, int inheritanceDepth) {
        boolean synthetic = this.typeExtensions.isSynthetic((JvmIdentifiableElement)jvmFeature);
        Object text = this.computeDecoratedText(synthetic ? jvmFeature : semanticFeature, inheritanceDepth);
        ImageDescriptor image = this.getImageDescriptor(synthetic ? jvmFeature : semanticFeature);
        if (this.isShowInherited()) {
            return this.getOutlineNodeFactory().createXtendFeatureNode(parentNode, (EObject)jvmFeature, image, text, true, synthetic, inheritanceDepth);
        }
        return this.getOutlineNodeFactory().createXtendFeatureNode(parentNode, (EObject)(synthetic ? jvmFeature : semanticFeature), image, text, true, synthetic, inheritanceDepth);
    }

    protected final void createFeatureNodesForType(IOutlineNode parentNode, JvmDeclaredType inferredType, JvmDeclaredType baseType, Set<JvmMember> processedMembers, int inheritanceDepth) {
        for (JvmMember member : inferredType.getMembers()) {
            if (processedMembers.contains(member)) continue;
            if (member instanceof JvmDeclaredType) {
                JvmDeclaredType jvmNestedType = (JvmDeclaredType)member;
                if (this.isShowInherited()) {
                    HashSet forgetProcessed = Sets.newHashSet();
                    EObject sourceElement = this.associations.getPrimarySourceElement((EObject)member);
                    if (sourceElement instanceof XtendTypeDeclaration) {
                        this.createNodeForType(parentNode, sourceElement, (Set<JvmMember>)forgetProcessed, inheritanceDepth);
                    } else {
                        this.createNodeForType(parentNode, jvmNestedType, (Set<JvmMember>)forgetProcessed, inheritanceDepth);
                    }
                } else {
                    this.createNodeForType(parentNode, jvmNestedType, processedMembers, inheritanceDepth);
                }
            } else if (member instanceof JvmFeature) {
                JvmFeature feature = (JvmFeature)member;
                if (this.skipFeature(feature)) continue;
                XtendFeatureNode featureNode = this.createNodeForFeature(parentNode, baseType, feature, (EObject)feature, inheritanceDepth);
                EList localClasses = feature.getLocalClasses();
                if (!localClasses.isEmpty()) {
                    for (JvmGenericType jvmGenericType : localClasses) {
                        HashSet forgetProcessed = Sets.newHashSet();
                        this.createNodeForType((IOutlineNode)featureNode, (JvmDeclaredType)jvmGenericType, (Set<JvmMember>)forgetProcessed, inheritanceDepth);
                    }
                }
            }
            this.rememberJvmMember(processedMembers, member);
        }
        if (this.isShowInherited()) {
            this.handleInheritedMembers(parentNode, inferredType, baseType, processedMembers, inheritanceDepth);
        }
    }

    protected void handleInheritedMembers(IOutlineNode parentNode, JvmDeclaredType inferredType, JvmDeclaredType baseType, Set<JvmMember> processedMembers, int inheritanceDepth) {
        JvmTypeReference extendedClass = inferredType.getExtendedClass();
        if (extendedClass != null) {
            this.createInheritedFeatureNodes(parentNode, baseType, processedMembers, inheritanceDepth, extendedClass);
        }
        for (JvmTypeReference extendedInterface : inferredType.getExtendedInterfaces()) {
            this.createInheritedFeatureNodes(parentNode, baseType, processedMembers, inheritanceDepth, extendedInterface);
        }
    }

    protected boolean skipFeature(JvmFeature feature) {
        return feature instanceof JvmConstructor && (feature.getDeclaringType().isLocal() || this.typeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)feature));
    }

    protected abstract void createNodeForType(IOutlineNode var1, EObject var2, Set<JvmMember> var3, int var4);

    protected EObjectNode createNodeForType(IOutlineNode parentNode, JvmDeclaredType typeElement, Set<JvmMember> processedMembers, int inheritanceDepth) {
        XtendEObjectNode classNode = this.createXtendNode(parentNode, (EObject)typeElement, inheritanceDepth);
        if (!processedMembers.contains(typeElement)) {
            processedMembers.add((JvmMember)typeElement);
            this.createFeatureNodesForType((IOutlineNode)classNode, typeElement, typeElement, processedMembers, inheritanceDepth);
        }
        return classNode;
    }

    protected abstract void createInheritedFeatureNodes(IOutlineNode var1, JvmDeclaredType var2, Set<JvmMember> var3, int var4, JvmTypeReference var5);

    protected boolean isShowInherited() {
        if (this.modeAware != null) {
            return this.modeAware.getCurrentMode() == XtendOutlineModes.SHOW_INHERITED_MODE;
        }
        return false;
    }

    public void internalCreateChildren(DocumentRootNode parentNode, EObject modelElement) {
        super.internalCreateChildren(parentNode, modelElement);
    }

    protected void rememberJvmMember(Set<JvmMember> processedMembers, JvmMember feature) {
        processedMembers.add(feature);
    }

    protected boolean isLeaf(EObject modelElement) {
        if (modelElement instanceof JvmDeclaredType) {
            return ((JvmDeclaredType)modelElement).getMembers().isEmpty();
        }
        if (modelElement instanceof XtendTypeDeclaration) {
            return ((XtendTypeDeclaration)modelElement).getMembers().isEmpty();
        }
        return super.isLeaf(modelElement);
    }

    protected XtendEObjectNode createXtendNode(IOutlineNode parentNode, EObject modelElement, int inheritanceDepth) {
        Object text = this.computeDecoratedText(modelElement, inheritanceDepth);
        ImageDescriptor image = this.getImageDescriptor(modelElement);
        boolean syntatic = false;
        if (modelElement instanceof JvmIdentifiableElement) {
            syntatic = this.typeExtensions.isSynthetic((JvmIdentifiableElement)modelElement);
        }
        XtendEObjectNode objectNode = this.getOutlineNodeFactory().createXtendEOBjectNode(parentNode, modelElement, image, text, true, syntatic, inheritanceDepth);
        return objectNode;
    }

    protected Object computeDecoratedText(Object modelElement, int inheritanceDepth) {
        Object supertext = super.getText(modelElement);
        if (!(supertext instanceof StyledString)) {
            return supertext;
        }
        StyledString styledText = (StyledString)supertext;
        if (inheritanceDepth > 0) {
            styledText = this.applyStylerToFirstSegment(styledText, ColoringLabelProvider.INHERITED_STYLER);
        }
        if (modelElement instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement jvmElement = (JvmIdentifiableElement)modelElement;
            if (!this.getAssociations().getSourceElements((EObject)jvmElement).isEmpty() && !this.getAssociations().isPrimaryJvmElement((EObject)jvmElement)) {
                styledText = this.applyStylerToFirstSegment(styledText, StyledString.QUALIFIER_STYLER);
            }
        }
        if (this.isShowInherited()) {
            XtendMember xtendMember;
            if (modelElement instanceof JvmMember) {
                String qualifier = this.createQualifier((JvmMember)modelElement);
                this.appendQualifier(styledText, qualifier);
            } else if (modelElement instanceof XtendMember && (xtendMember = (XtendMember)modelElement).eContainer() instanceof XtendTypeDeclaration) {
                String qualifiedName = this.createQualifier((XtendTypeDeclaration)xtendMember.eContainer(), '.');
                this.appendQualifier(styledText, qualifiedName);
            }
        }
        return styledText;
    }

    private void appendQualifier(StyledString styledText, String qualifier) {
        if (qualifier != null) {
            styledText.append(" - " + qualifier, StyledString.QUALIFIER_STYLER);
        }
    }

    private StyledString applyStylerToFirstSegment(StyledString styledText, StyledString.Styler styler) {
        if (styledText.getStyleRanges().length > 0) {
            StyleRange textStyle = styledText.getStyleRanges()[0];
            if (textStyle.start != 0) {
                styledText.setStyle(0, textStyle.start, styler);
            } else {
                styledText.setStyle(0, textStyle.length, styler);
            }
        } else {
            styledText = new StyledString(styledText.getString(), styler);
        }
        return styledText;
    }

    private String createQualifier(JvmMember jvmMember) {
        String qualifier = null;
        if (jvmMember instanceof JvmFeature) {
            qualifier = jvmMember.getDeclaringType().getIdentifier();
        } else if (jvmMember instanceof JvmDeclaredType) {
            qualifier = jvmMember.eContainer() instanceof JvmDeclaredType ? ((JvmDeclaredType)jvmMember.eContainer()).getQualifiedName('.') : ((JvmDeclaredType)jvmMember).getPackageName();
        }
        return qualifier;
    }

    private String createQualifier(XtendTypeDeclaration xtendType, char innerClassDelimiter) {
        if (xtendType.getName() == null) {
            return null;
        }
        XtendTypeDeclaration declaringType = null;
        if (xtendType.eContainer() instanceof XtendTypeDeclaration) {
            declaringType = (XtendTypeDeclaration)xtendType.eContainer();
        }
        if (declaringType == null) {
            String packageName = this.createPackagename(xtendType);
            if (Strings.isEmpty((String)packageName)) {
                return xtendType.getName();
            }
            return String.valueOf(packageName) + "." + xtendType.getName();
        }
        String parentName = this.createQualifier(declaringType, innerClassDelimiter);
        if (parentName == null) {
            return null;
        }
        return String.valueOf(parentName) + innerClassDelimiter + xtendType.getName();
    }

    private String createPackagename(XtendTypeDeclaration xtendType) {
        XtendFile xtendFile = (XtendFile)EcoreUtil2.getContainerOfType((EObject)xtendType, XtendFile.class);
        if (xtendFile != null) {
            return xtendFile.getPackage();
        }
        return "";
    }

    protected XtendOutlineNodeFactory getOutlineNodeFactory() {
        return (XtendOutlineNodeFactory)super.getOutlineNodeFactory();
    }

    protected IXtendJvmAssociations getAssociations() {
        return this.associations;
    }

    public void setModeAware(IOutlineTreeProvider.ModeAware modeAware) {
        this.modeAware = modeAware;
    }
}

