/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FeatureScopeSessionToResolvedTypes {
    private final IFeatureScopeSession session;
    private final IResolvedTypes types;
    private int hashCode;

    FeatureScopeSessionToResolvedTypes(IFeatureScopeSession session, IResolvedTypes types) {
        this.session = session;
        this.types = types;
    }

    IFeatureScopeSession getSession() {
        return this.session;
    }

    IResolvedTypes getTypes() {
        return this.types;
    }

    public boolean equals(Object obj) {
        FeatureScopeSessionToResolvedTypes other = (FeatureScopeSessionToResolvedTypes)obj;
        if (other == this) {
            return true;
        }
        if (other == null || this.hashCode() != other.hashCode()) {
            return false;
        }
        ArrayList localNames = Lists.newArrayList();
        ArrayList localTypes = Lists.newArrayList();
        this.populateLists(localNames, localTypes);
        ArrayList otherLocalNames = Lists.newArrayList();
        ArrayList otherLocalTypes = Lists.newArrayList();
        other.populateLists(otherLocalNames, otherLocalTypes);
        return localNames.equals(otherLocalNames) && localTypes.equals(otherLocalTypes);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        ArrayList localNames = Lists.newArrayList();
        ArrayList localTypes = Lists.newArrayList();
        this.populateLists(localNames, localTypes);
        this.hashCode = localNames.hashCode() ^ localTypes.hashCode();
        return this.hashCode;
    }

    protected void populateLists(List<QualifiedName> localNames, List<String> localTypes) {
        List<IEObjectDescription> elements = this.session.getLocalElements();
        for (IEObjectDescription desc : elements) {
            if (!TypesPackage.Literals.JVM_IDENTIFIABLE_ELEMENT.isSuperTypeOf(desc.getEClass())) continue;
            localNames.add(desc.getName());
            JvmIdentifiableElement identifiable = (JvmIdentifiableElement)desc.getEObjectOrProxy();
            LightweightTypeReference type = this.types.getActualType(identifiable);
            if (type != null) {
                localTypes.add(type.getRawTypeReference().getIdentifier());
                continue;
            }
            localTypes.add(null);
        }
    }
}

