/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.OnChangeEvictingCache;

public class DerivedStateAwareResource
extends StorageAwareResource {
    @Inject(optional=true)
    private IDerivedStateComputer derivedStateComputer;
    protected volatile boolean fullyInitialized = false;
    protected volatile boolean isInitializing = false;

    public void setDerivedStateComputer(IDerivedStateComputer lateInitialization) {
        this.derivedStateComputer = lateInitialization;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void setFullyInitialized(boolean fullyInitialized) {
        this.fullyInitialized = fullyInitialized;
    }

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public synchronized EList<EObject> getContents() {
        if (!(!this.isLoaded || this.isLoading || this.isInitializing || this.isUpdating || this.fullyInitialized || this.isLoadedFromStorage())) {
            try {
                this.eSetDeliver(false);
                this.installDerivedState(false);
            }
            finally {
                this.eSetDeliver(true);
            }
        }
        return this.doGetContents();
    }

    protected EList<EObject> doGetContents() {
        return super.getContents();
    }

    protected List<EObject> getUnloadingContents() {
        return new BasicEList.FastCompare(this.doGetContents());
    }

    @Override
    protected void doUnload() {
        TreeIterator allContents = this.getAllProperContents(this.unloadingContents);
        if (!this.doGetContents().isEmpty()) {
            this.doGetContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            this.unloaded((InternalEObject)allContents.next());
        }
        this.setParseResult(null);
        this.setIsLoadedFromStorage(false);
    }

    @Override
    protected void clearInternalState() {
        if (this.fullyInitialized) {
            this.discardDerivedState();
        }
        super.clearInternalState();
    }

    @Override
    protected void updateInternalState(IParseResult oldParseResult, IParseResult newParseResult) {
        if (this.fullyInitialized) {
            this.discardDerivedState();
        }
        super.updateInternalState(oldParseResult, newParseResult);
    }

    @Override
    protected void updateInternalState(IParseResult newParseResult) {
        super.updateInternalState(newParseResult);
        IResourceScopeCache cache = this.getCache();
        if (cache instanceof OnChangeEvictingCache) {
            ((OnChangeEvictingCache)cache).getOrCreate((Resource)this);
        }
    }

    protected String getURIFragmentRootSegment(EObject eObject) {
        IParseResult parseResult;
        if (this.unloadingContents == null && (parseResult = this.getParseResult()) != null && eObject == parseResult.getRootASTElement()) {
            return "0";
        }
        return super.getURIFragmentRootSegment(eObject);
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        return super.getEObjectForURIFragmentRootSegment(uriFragmentRootSegment);
    }

    public void discardDerivedState() {
        if (this.isLoaded && this.fullyInitialized && !this.isInitializing) {
            try {
                this.isInitializing = true;
                if (this.derivedStateComputer != null) {
                    this.derivedStateComputer.discardDerivedState(this);
                }
                this.fullyInitialized = false;
            }
            finally {
                this.isInitializing = false;
                this.getCache().clear((Resource)this);
            }
        }
    }

    public void installDerivedState(boolean preIndexingPhase) {
        if (!this.isLoaded) {
            throw new IllegalStateException("The resource must be loaded, before installDerivedState can be called.");
        }
        if (!(this.fullyInitialized || this.isInitializing || this.isLoadedFromStorage())) {
            try {
                this.isInitializing = true;
                if (this.derivedStateComputer != null) {
                    EList<EObject> roots = this.doGetContents();
                    if (roots.size() > 1) {
                        throw new IllegalStateException("The resource should have no more than one root element, but: " + roots);
                    }
                    try {
                        this.derivedStateComputer.installDerivedState(this, preIndexingPhase);
                    }
                    catch (Throwable e) {
                        if (this.operationCanceledManager.isOperationCanceledException(e)) {
                            this.derivedStateComputer.discardDerivedState(this);
                            this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                        }
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                this.fullyInitialized = true;
            }
            finally {
                this.isInitializing = false;
                this.getCache().clear((Resource)this);
            }
        }
    }
}

