/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ContentProposalLabelProvider;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalPriorities;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.util.XtextSwitch;

public abstract class AbstractContentProposalProvider
implements IContentProposalProvider,
ICompletionProposalFactory {
    @Inject
    private IContentProposalPriorities priorities;
    @Inject
    @ContentProposalLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverter;
    @Inject
    private IProposalConflictHelper conflictHelper;

    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        NullSafeCompletionProposalAcceptor nullSafe = new NullSafeCompletionProposalAcceptor(acceptor);
        IFollowElementAcceptor selector = this.createSelector(context, nullSafe);
        for (AbstractElement element : context.getFirstSetGrammarElements()) {
            selector.accept(element);
        }
    }

    public abstract void completeKeyword(Keyword var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public abstract void completeRuleCall(RuleCall var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public abstract void completeAssignment(Assignment var1, ContentAssistContext var2, ICompletionProposalAcceptor var3);

    public IFollowElementAcceptor createSelector(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        return new DefaultContentAssistProcessorSwitch(context, acceptor);
    }

    public ICompletionProposal createCompletionProposal(String proposal, String displayString, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, new StyledString(displayString), image, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, null, null, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    public ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, ContentAssistContext contentAssistContext) {
        return this.createCompletionProposal(proposal, displayString, image, this.getPriorityHelper().getDefaultPriority(), contentAssistContext.getPrefix(), contentAssistContext);
    }

    protected ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, int priority, String prefix, ContentAssistContext context) {
        if (this.isValidProposal(proposal, prefix, context)) {
            return this.doCreateProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (proposal == null) {
            return false;
        }
        if (!context.getMatcher().isCandidateMatchingPrefix(proposal, prefix)) {
            return false;
        }
        return !this.conflictHelper.existsConflict(proposal, context);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        ConfigurableCompletionProposal result = this.doCreateProposal(proposal, displayString, image, replacementOffset, replacementLength);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        return result;
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int replacementOffset, int replacementLength) {
        return new ConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, proposal.length(), image, displayString, null, null);
    }

    protected StyledString getKeywordDisplayString(Keyword keyword) {
        return new StyledString(keyword.getValue());
    }

    protected StyledString getStyledDisplayString(IEObjectDescription description) {
        return this.getStyledDisplayString(description.getEObjectOrProxy(), this.qualifiedNameConverter.toString(description.getQualifiedName()), this.qualifiedNameConverter.toString(description.getName()));
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        return new StyledString(this.getDisplayString(element, qualifiedName, shortName));
    }

    protected String getDisplayString(EObject element, String qualifiedNameAsString, String shortName) {
        QualifiedName qualifiedName;
        if (qualifiedNameAsString == null) {
            qualifiedNameAsString = shortName;
        }
        if (qualifiedNameAsString == null) {
            if (element != null) {
                qualifiedNameAsString = this.labelProvider.getText((Object)element);
            } else {
                return null;
            }
        }
        if ((qualifiedName = this.qualifiedNameConverter.toQualifiedName(qualifiedNameAsString)).getSegmentCount() > 1) {
            return String.valueOf(qualifiedName.getLastSegment()) + " - " + qualifiedNameAsString;
        }
        return qualifiedNameAsString;
    }

    public void setValueConverter(IValueConverterService valueConverter) {
        this.valueConverter = valueConverter;
    }

    public IValueConverterService getValueConverter() {
        return this.valueConverter;
    }

    protected Image getImage(EObject eObject) {
        return this.labelProvider.getImage((Object)eObject);
    }

    public void setConflictHelper(IProposalConflictHelper conflictHelper) {
        this.conflictHelper = conflictHelper;
    }

    public IProposalConflictHelper getConflictHelper() {
        return this.conflictHelper;
    }

    public void setPriorityHelper(IContentProposalPriorities priorities) {
        this.priorities = priorities;
    }

    public IContentProposalPriorities getPriorityHelper() {
        return this.priorities;
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultContentAssistProcessorSwitch
    extends XtextSwitch<Boolean>
    implements IFollowElementAcceptor {
        private final ContentAssistContext context;
        private final ICompletionProposalAcceptor acceptor;

        public DefaultContentAssistProcessorSwitch(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            this.context = context;
            this.acceptor = acceptor;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }

        public Boolean caseKeyword(Keyword object) {
            AbstractContentProposalProvider.this.completeKeyword(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseRuleCall(RuleCall object) {
            AbstractContentProposalProvider.this.completeRuleCall(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseAssignment(Assignment object) {
            AbstractContentProposalProvider.this.completeAssignment(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        @Override
        public void accept(AbstractElement element) {
            this.doSwitch((EObject)element);
        }
    }

    public static class NullSafeCompletionProposalAcceptor
    extends ICompletionProposalAcceptor.Delegate {
        public NullSafeCompletionProposalAcceptor(ICompletionProposalAcceptor delegate) {
            super(delegate);
        }

        public void accept(ICompletionProposal proposal) {
            if (proposal != null) {
                super.accept(proposal);
            }
        }
    }
}

