/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.junit.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.junit.util.ResourceLoadHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.junit.editor.contentassist.ContentAssistProcessorTestBuilder;
import org.eclipse.xtext.ui.junit.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXbaseContentAssistTest
extends TestCase
implements ResourceLoadHelper {
    @Inject
    protected IWorkspace workspace;
    protected String fileExtension;
    protected static String[] KEYWORDS_AND_STATICS = new String[]{"if", "while", "for", "do", "true", "false", "typeof", "try", "switch", "new", "throw", "return", "null", "emptyList", "emptySet", "emptyMap", "newImmutableList()", "newImmutableSet()", "newImmutableMap()", "newArrayList()", "newLinkedList()", "newHashSet()", "newLinkedHashSet()", "newTreeSet()", "newHashMap()", "newLinkedHashMap()", "newTreeMap()", "print()", "println()"};
    protected static String[] STRING_OPERATORS = new String[]{"==", "!=", "+", "<=", ">=", "<", ">", "->"};
    protected static String[] CAST_INSTANCEOF = new String[]{"as", "instanceof"};
    protected static final String[] STRING_FEATURES;
    protected static final String[] STATIC_STRING_FEATURES;

    static {
        ArrayList features = Lists.newArrayList();
        ArrayList staticFeatures = Lists.newArrayList();
        Method[] methodArray = String.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ArrayList list = features;
            if (Modifier.isStatic(method.getModifiers())) {
                list = staticFeatures;
            }
            if (method.getParameterTypes().length == 0) {
                if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                    list.add(Strings.toFirstLower((String)method.getName().substring(3)));
                } else if (method.getName().startsWith("is") && method.getParameterTypes().length == 0) {
                    list.add(Strings.toFirstLower((String)method.getName().substring(2)));
                } else {
                    list.add(method.getName());
                }
            } else {
                list.add(String.valueOf(method.getName()) + "()");
            }
            ++n2;
        }
        features.remove("compareTo()");
        HashSet featuresAsSet = Sets.newHashSet((Iterable)features);
        HashSet staticFeaturesAsSet = Sets.newHashSet((Iterable)staticFeatures);
        Field[] fieldArray = String.class.getFields();
        int n3 = fieldArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Field field = fieldArray[n4];
            HashSet asSet = featuresAsSet;
            ArrayList list = features;
            if (Modifier.isStatic(field.getModifiers())) {
                list = staticFeatures;
                asSet = staticFeaturesAsSet;
            }
            if (asSet.add(field.getName())) {
                list.add(field.getName());
            }
            ++n4;
        }
        features.add("toFirstLower");
        features.add("toFirstUpper");
        features.add("nullOrEmpty");
        STRING_FEATURES = features.toArray(new String[features.size()]);
        STATIC_STRING_FEATURES = staticFeatures.toArray(new String[staticFeatures.size()]);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getInjector().injectMembers((Object)this);
    }

    protected void tearDown() throws Exception {
        if (this.doCleanWorkspace()) {
            IResourcesSetupUtil.cleanWorkspace();
        }
        super.tearDown();
    }

    protected boolean doCleanWorkspace() {
        return true;
    }

    protected abstract Injector getInjector();

    public <T> T get(Class<T> clazz) {
        return (T)this.getInjector().getInstance(clazz);
    }

    protected XExpression expression(String string) throws Exception {
        XtextResource resource = this.getResourceFor((InputStream)new StringInputStream(string));
        AbstractXbaseContentAssistTest.assertEquals((String)resource.getErrors().toString(), (int)0, (int)resource.getErrors().size());
        XExpression result = (XExpression)resource.getContents().get(0);
        return result;
    }

    protected XtextResourceSet getResourceSet() {
        return this.get(XtextResourceSet.class);
    }

    public XtextResource getResourceFor(InputStream stream) {
        try {
            XtextResource result = (XtextResource)this.getResourceSet().createResource(URI.createURI((String)("Test." + this.fileExtension)));
            result.load(stream, null);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Inject
    protected void setExtensions(@Named(value="file.extensions") String extensions) {
        this.fileExtension = extensions.split(",")[0];
    }

    @Test
    public void testEmptyInput() throws Exception {
        this.newBuilder().assertText(this.getKeywordsAndStatics());
    }

    protected String[] getKeywordsAndStatics() {
        return KEYWORDS_AND_STATICS;
    }

    public String[] getStringFeatures() {
        return STRING_FEATURES;
    }

    public String[] getStaticStringFeatures() {
        return STATIC_STRING_FEATURES;
    }

    protected String[] expect(String[] ... arrays) {
        ArrayList expectation = Lists.newArrayList();
        String[][] stringArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            expectation.addAll(Arrays.asList(array));
            ++n2;
        }
        return expectation.toArray(new String[expectation.size()]);
    }

    @Test
    public void testOnStringLiteral_01() throws Exception {
        this.newBuilder().append("''").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_02() throws Exception {
        this.newBuilder().append("''.").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_03() throws Exception {
        this.newBuilder().append("''.").assertTextAtCursorPosition(".", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_04() throws Exception {
        this.newBuilder().append("''+''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_05() throws Exception {
        this.newBuilder().append("''+''").assertTextAtCursorPosition("+''", 1, this.expect({"+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_06() throws Exception {
        this.newBuilder().append("''==''").assertTextAtCursorPosition("==", 1, new String[]{"=="});
    }

    @Test
    public void testOnStringLiteral_07() throws Exception {
        this.newBuilder().append("''==''").assertTextAtCursorPosition("==", 2, this.expect({"=="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_08() throws Exception {
        this.newBuilder().append("''<=''").assertTextAtCursorPosition("<=", 1, this.expect({"<", "<="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_09() throws Exception {
        this.newBuilder().append("''<=''").assertTextAtCursorPosition("<=", 2, this.expect({"<="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_10() throws Exception {
        this.newBuilder().append("'' ").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_11() throws Exception {
        this.newBuilder().append("''. ").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_12() throws Exception {
        this.newBuilder().append("'' .").assertTextAtCursorPosition(".", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_13() throws Exception {
        this.newBuilder().append("'' + ''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_14() throws Exception {
        this.newBuilder().append("'' + ''").assertTextAtCursorPosition("+ ''", 2, this.getKeywordsAndStatics());
        this.newBuilder().append("'' + ''").assertTextAtCursorPosition("+ ''", 1, this.expect({"+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_15() throws Exception {
        this.newBuilder().append("'' == ''").assertTextAtCursorPosition("==", 1, new String[]{"=="});
    }

    @Test
    public void testOnStringLiteral_16() throws Exception {
        this.newBuilder().append("'' == ''").assertTextAtCursorPosition("==", 2, this.expect({"=="}, this.getKeywordsAndStatics()));
        this.newBuilder().append("'' == ''").assertTextAtCursorPosition("==", 3, this.getKeywordsAndStatics());
    }

    @Test
    public void testOnStringLiteral_17() throws Exception {
        this.newBuilder().append("'' <= ''").assertTextAtCursorPosition("<=", 1, this.expect({"<", "<="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_18() throws Exception {
        this.newBuilder().append("'' <= ''").assertTextAtCursorPosition("<=", 2, this.expect({"<="}, this.getKeywordsAndStatics()));
        this.newBuilder().append("'' <= ''").assertTextAtCursorPosition("<=", 3, this.getKeywordsAndStatics());
    }

    @Test
    public void testOnStringLiteral_19() throws Exception {
        this.newBuilder().append("''.toString").assertText(this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_20() throws Exception {
        this.newBuilder().append("''.toString.").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_21() throws Exception {
        this.newBuilder().append("''.toString.").assertTextAtCursorPosition("g.", 1, this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_22() throws Exception {
        this.newBuilder().append("''.toString+''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_23() throws Exception {
        this.newBuilder().append("''.toString+''").assertTextAtCursorPosition("+''", 1, this.expect({"+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_24() throws Exception {
        this.newBuilder().append("''.toString==''").assertTextAtCursorPosition("==", 1, this.expect({"=="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_25() throws Exception {
        this.newBuilder().append("''.toString==''").assertTextAtCursorPosition("==", 2, this.expect({"=="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_26() throws Exception {
        this.newBuilder().append("''.toString<=''").assertTextAtCursorPosition("<=", 1, this.expect({"<", "<="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_27() throws Exception {
        this.newBuilder().append("''.toString<=''").assertTextAtCursorPosition("<=", 2, this.expect({"<="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_28() throws Exception {
        this.newBuilder().append("''.toString.toString").assertTextAtCursorPosition(".", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_29() throws Exception {
        this.newBuilder().append("''.toString.toString.toString").assertTextAtCursorPosition("g.", 1, this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testOnStringLiteral_30() throws Exception {
        this.newBuilder().append("('')").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_31() throws Exception {
        this.newBuilder().append("('').").assertText(this.getStringFeatures());
    }

    @Test
    public void testOnStringLiteral_32() throws Exception {
        this.newBuilder().append("(''.toString)").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_33() throws Exception {
        this.newBuilder().append("(''.toString )").assertTextAtCursorPosition(")", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_34() throws Exception {
        this.newBuilder().append("''.toString ").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_35() throws Exception {
        this.newBuilder().append("''.toString .").assertTextAtCursorPosition("g .", 2, this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_36() throws Exception {
        this.newBuilder().append("''.toString +''").assertTextAtCursorPosition("+", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testOnStringLiteral_37() throws Exception {
        this.newBuilder().append("''.toString ==''").assertTextAtCursorPosition("==", 1, this.expect({"=="}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testOnStringLiteral_38() throws Exception {
        this.newBuilder().append("''.toString.toString").assertTextAtCursorPosition("g.", 1, this.expect(STRING_OPERATORS, {"toString"}));
    }

    @Test
    public void testAfterBinaryOperation_01() throws Exception {
        this.newBuilder().append("''+''").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_02() throws Exception {
        this.newBuilder().append("'' + ''+''").assertTextAtCursorPosition("''+", 2, this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_03() throws Exception {
        this.newBuilder().append("(''+'')").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_04() throws Exception {
        this.newBuilder().append("(''+'').").assertText(this.getStringFeatures());
    }

    @Test
    public void testAfterBinaryOperation_05() throws Exception {
        this.newBuilder().append("((''+''))").assertText(this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_06() throws Exception {
        this.newBuilder().append("((''+''))").assertTextAtCursorPosition("))", 1, this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_07() throws Exception {
        this.newBuilder().append("((''+''))").assertTextAtCursorPosition("))", this.expect(STRING_OPERATORS, CAST_INSTANCEOF));
    }

    @Test
    public void testAfterBinaryOperation_08() throws Exception {
        this.newBuilder().append("((''+(''.bytes)))").assertTextAtCursorPosition(")", new String[]{"==", "!=", "+=", "+", "->", "bytes"});
    }

    @Test
    public void testAfterBinaryOperation_09() throws Exception {
        this.newBuilder().append("((''+''.bytes))").assertTextAtCursorPosition(")", new String[]{"==", "!=", "+=", "+", "->", "bytes"});
    }

    @Test
    public void testAfterBinaryOperation_10() throws Exception {
        this.newBuilder().append("((''+null))").assertTextAtCursorPosition(")", new String[]{"null", "!=", "==", "->"});
    }

    @Test
    public void testStaticFeatures_01() throws Exception {
        this.newBuilder().append("String::").assertText(this.getStaticStringFeatures());
    }

    @Test
    public void testNull() throws Exception {
        this.newBuilder().append("null").assertText(new String[]{"null", "!=", "==", "->"});
    }

    @Test
    public void testForLoop_01() throws Exception {
        this.newBuilder().append("for (String s: null) ").assertText(this.expect({"s"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testForLoop_02() throws Exception {
        this.newBuilder().append("for (String string: null) string").assertTextAtCursorPosition(") string", 6, new String[]{"string"});
    }

    @Test
    public void testForLoop_03() throws Exception {
        this.newBuilder().append("for (String string: null) ''+").assertText(this.expect({"string", "+"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testForLoop_04() throws Exception {
        this.newBuilder().append("for (String string: ").assertText(this.getKeywordsAndStatics());
    }

    @Test
    public void testForLoop_05() throws Exception {
        this.newBuilder().append("for (String string: )").assertTextAtCursorPosition(")", this.getKeywordsAndStatics());
    }

    @Test
    public void testClosure_01() throws Exception {
        this.newBuilder().append("[String a, String b|").assertText(this.expect({"a", "b"}, this.getKeywordsAndStatics(), {"val", "var"}));
    }

    @Test
    public void testCatchParameter_01() throws Exception {
        this.newBuilder().append("try {} catch(NullPointerException e) e").assertTextAtCursorPosition(") e", 2, this.expect({"e"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testCatchParameter_02() throws Exception {
        this.newBuilder().append("try {} catch(NullPointerException e) ").assertText(this.expect({"e"}, this.getKeywordsAndStatics()));
    }

    @Test
    public void testCamelCase_01() throws Exception {
        this.newBuilder().append("newLLis").assertText(new String[]{"newLinkedList()"});
    }

    @Test
    public void testCamelCase_02() throws Exception {
        this.newBuilder().append("new ArrBloQu").assertText(new String[]{"java.util.concurrent.ArrayBlockingQueue"});
    }

    protected ContentAssistProcessorTestBuilder newBuilder() throws Exception {
        return new ContentAssistProcessorTestBuilder(this.getInjector(), (ResourceLoadHelper)this);
    }
}

