/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XIntLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationValueArray;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.compiler.CompilationStrategyAdapter;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmTypesBuilder {
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private TypeReferences references;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    private Map<EClass, AnnotationValueTranslator> translators = Maps.newLinkedHashMap();

    public void setBody(JvmExecutable logicalContainer, XExpression expr) {
        if (expr == null) {
            return;
        }
        this.associator.associateLogicalContainer(expr, (JvmIdentifiableElement)logicalContainer);
    }

    public void setBody(JvmExecutable executable, Functions.Function1<ImportManager, ? extends CharSequence> strategy) {
        this.addCompilationStrategy((JvmMember)executable, strategy);
    }

    public String getDocumentation(EObject source) {
        DocumentationAdapter adapter;
        if (source == null) {
            return null;
        }
        if (source instanceof JvmIdentifiableElement && (adapter = (DocumentationAdapter)EcoreUtil.getAdapter((List)source.eAdapters(), DocumentationAdapter.class)) != null) {
            return adapter.getDocumentation();
        }
        String documentation = this.documentationProvider.getDocumentation(source);
        return documentation;
    }

    public void setDocumentation(JvmIdentifiableElement jvmElement, String documentation) {
        if (documentation == null) {
            return;
        }
        DocumentationAdapter documentationAdapter = new DocumentationAdapter();
        documentationAdapter.setDocumentation(documentation);
        jvmElement.eAdapters().add((Object)documentationAdapter);
    }

    public JvmGenericType toClass(EObject sourceElement, QualifiedName name, Procedures.Procedure1<JvmGenericType> initializer) {
        return this.toClass(sourceElement, name != null ? name.toString() : null, initializer);
    }

    public JvmGenericType toClass(EObject sourceElement, String name, Procedures.Procedure1<JvmGenericType> initializer) {
        JvmTypeReference objectType;
        JvmGenericType result = this.createJvmGenericType(sourceElement, name);
        if (result == null) {
            return null;
        }
        if (initializer != null) {
            initializer.apply((Object)result);
        }
        if (result.getSuperTypes().isEmpty() && (objectType = this.references.getTypeForName(Object.class, sourceElement, new JvmTypeReference[0])) != null) {
            result.getSuperTypes().add((Object)objectType);
        }
        if (Iterables.isEmpty((Iterable)result.getDeclaredConstructors())) {
            result.getMembers().add((Object)this.toConstructor(sourceElement, result.getSimpleName(), null));
        }
        return this.associate(sourceElement, result);
    }

    public JvmGenericType toInterface(EObject sourceElement, String name, Procedures.Procedure1<JvmGenericType> initializer) {
        JvmGenericType result = this.createJvmGenericType(sourceElement, name);
        if (result == null) {
            return null;
        }
        result.setInterface(true);
        if (initializer != null) {
            initializer.apply((Object)result);
        }
        return this.associate(sourceElement, result);
    }

    public JvmAnnotationType toAnnotationType(EObject sourceElement, String name, Procedures.Procedure1<JvmAnnotationType> initializer) {
        if (sourceElement == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        Pair<String, String> fullName = this.splitQualifiedName(name);
        JvmAnnotationType annotationType = TypesFactory.eINSTANCE.createJvmAnnotationType();
        annotationType.setSimpleName((String)fullName.getSecond());
        if (fullName.getFirst() != null) {
            annotationType.setPackageName((String)fullName.getFirst());
        }
        if (initializer != null) {
            initializer.apply((Object)annotationType);
        }
        return this.associate(sourceElement, annotationType);
    }

    public JvmEnumerationType toEnumerationType(EObject sourceElement, String name, Procedures.Procedure1<JvmEnumerationType> initializer) {
        if (sourceElement == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        Pair<String, String> fullName = this.splitQualifiedName(name);
        JvmEnumerationType result = TypesFactory.eINSTANCE.createJvmEnumerationType();
        result.setSimpleName((String)fullName.getSecond());
        if (fullName.getFirst() != null) {
            result.setPackageName((String)fullName.getFirst());
        }
        if (initializer != null) {
            initializer.apply((Object)result);
        }
        return this.associate(sourceElement, result);
    }

    protected JvmGenericType createJvmGenericType(EObject sourceElement, String name) {
        if (sourceElement == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        Pair<String, String> fullName = this.splitQualifiedName(name);
        JvmGenericType result = TypesFactory.eINSTANCE.createJvmGenericType();
        result.setSimpleName((String)fullName.getSecond());
        if (fullName.getFirst() != null) {
            result.setPackageName((String)fullName.getFirst());
        }
        result.setVisibility(JvmVisibility.PUBLIC);
        return result;
    }

    protected Pair<String, String> splitQualifiedName(String name) {
        String simpleName = name;
        String packageName = null;
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx != -1) {
            simpleName = name.substring(dotIdx + 1);
            packageName = name.substring(0, dotIdx);
        }
        Pair fullName = Tuples.create(packageName, (Object)simpleName);
        return fullName;
    }

    public JvmField toField(EObject sourceElement, String name, JvmTypeReference typeRef) {
        return this.toField(sourceElement, name, typeRef, null);
    }

    public JvmField toField(EObject sourceElement, String name, JvmTypeReference typeRef, Procedures.Procedure1<JvmField> initializer) {
        JvmField result = TypesFactory.eINSTANCE.createJvmField();
        result.setSimpleName(this.nullSaveName(name));
        result.setVisibility(JvmVisibility.PRIVATE);
        result.setType(this.cloneWithProxies(typeRef));
        if (initializer != null && name != null) {
            initializer.apply((Object)result);
        }
        return this.associate(sourceElement, result);
    }

    protected String nullSaveName(String name) {
        return name != null ? name : "<unknown>";
    }

    public <T extends JvmIdentifiableElement> T associate(EObject sourceElement, T target) {
        this.associator.associatePrimary(sourceElement, (EObject)target);
        return target;
    }

    public JvmOperation toMethod(EObject sourceElement, String name, JvmTypeReference returnType, Procedures.Procedure1<JvmOperation> init) {
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        result.setSimpleName(this.nullSaveName(name));
        result.setVisibility(JvmVisibility.PUBLIC);
        result.setReturnType(this.cloneWithProxies(returnType));
        if (init != null && name != null) {
            init.apply((Object)result);
        }
        return this.associate(sourceElement, result);
    }

    public JvmOperation toGetter(EObject sourceElement, final String name, JvmTypeReference typeRef) {
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        result.setVisibility(JvmVisibility.PUBLIC);
        result.setSimpleName("get" + this.nullSaveName(Strings.toFirstUpper((String)name)));
        result.setReturnType(this.cloneWithProxies(typeRef));
        if (name != null) {
            this.setBody((JvmExecutable)result, (Functions.Function1<ImportManager, ? extends CharSequence>)new Functions.Function1<ImportManager, CharSequence>(){

                public CharSequence apply(ImportManager p) {
                    return "return this." + name + ";";
                }
            });
        }
        return this.associate(sourceElement, result);
    }

    public JvmOperation toSetter(EObject sourceElement, final String name, JvmTypeReference typeRef) {
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        result.setVisibility(JvmVisibility.PUBLIC);
        result.setSimpleName("set" + this.nullSaveName(Strings.toFirstUpper((String)name)));
        result.getParameters().add((Object)this.toParameter(sourceElement, this.nullSaveName(name), this.cloneWithProxies(typeRef)));
        if (name != null) {
            this.setBody((JvmExecutable)result, (Functions.Function1<ImportManager, ? extends CharSequence>)new Functions.Function1<ImportManager, CharSequence>(){

                public CharSequence apply(ImportManager p) {
                    return "this." + name + " = " + name + ";";
                }
            });
        }
        return this.associate(sourceElement, result);
    }

    public JvmFormalParameter toParameter(EObject sourceElement, String name, JvmTypeReference typeRef) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        result.setName(this.nullSaveName(name));
        result.setParameterType(this.cloneWithProxies(typeRef));
        return this.associate(sourceElement, result);
    }

    public JvmConstructor toConstructor(EObject sourceElement, String simpleName, Procedures.Procedure1<JvmConstructor> init) {
        JvmConstructor constructor = TypesFactory.eINSTANCE.createJvmConstructor();
        constructor.setSimpleName(this.nullSaveName(simpleName));
        this.setBody((JvmExecutable)constructor, (Functions.Function1<ImportManager, ? extends CharSequence>)new Functions.Function1<ImportManager, CharSequence>(){

            public CharSequence apply(ImportManager p) {
                return "{}";
            }
        });
        if (init != null && simpleName != null) {
            init.apply((Object)constructor);
        }
        return this.associate(sourceElement, constructor);
    }

    public JvmAnnotationReference toAnnotation(EObject sourceElement, Class<?> annotationType) {
        return this.toAnnotation(sourceElement, annotationType, null);
    }

    public JvmAnnotationReference toAnnotation(EObject sourceElement, String annotationTypeName) {
        return this.toAnnotation(sourceElement, annotationTypeName, null);
    }

    public JvmAnnotationReference toAnnotation(EObject sourceElement, Class<?> annotationType, Object value) {
        return this.toAnnotation(sourceElement, annotationType.getCanonicalName(), value);
    }

    public JvmAnnotationReference toAnnotation(EObject sourceElement, String annotationTypeName, Object value) {
        JvmAnnotationReference result = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        JvmType jvmType = this.references.findDeclaredType(annotationTypeName, (Notifier)sourceElement);
        if (!(jvmType instanceof JvmAnnotationType)) {
            throw new IllegalArgumentException("The given class " + annotationTypeName + " is not an annotation type.");
        }
        result.setAnnotation((JvmAnnotationType)jvmType);
        if (value != null && value instanceof String) {
            JvmStringAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
            annotationValue.getValues().add((Object)((String)value));
            result.getValues().add((Object)annotationValue);
        }
        return result;
    }

    public JvmTypeReference cloneWithProxies(JvmTypeReference typeRef) {
        if (typeRef == null) {
            return null;
        }
        if (typeRef instanceof JvmParameterizedTypeReference && !typeRef.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)) {
            throw new IllegalArgumentException("typeref#type was null");
        }
        return (JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)typeRef);
    }

    public void initialization(JvmField field, Functions.Function1<ImportManager, ? extends CharSequence> strategy) {
        this.addCompilationStrategy((JvmMember)field, strategy);
    }

    protected void addCompilationStrategy(JvmMember member, Functions.Function1<ImportManager, ? extends CharSequence> strategy) {
        CompilationStrategyAdapter adapter = new CompilationStrategyAdapter();
        adapter.setCompilationStrategy(strategy);
        member.eAdapters().add((Object)adapter);
    }

    public JvmTypeReference newTypeRef(EObject ctx, Class<?> clazz, JvmTypeReference ... typeArgs) {
        return this.references.getTypeForName(clazz, ctx, typeArgs);
    }

    public JvmTypeReference newTypeRef(EObject ctx, String typeName, JvmTypeReference ... typeArgs) {
        return this.references.getTypeForName(typeName, (Notifier)ctx, typeArgs);
    }

    public JvmTypeReference addArrayTypeDimension(JvmTypeReference componentType) {
        return this.references.createArrayType(componentType);
    }

    public void translateAnnotationsTo(Iterable<? extends XAnnotation> annotations, JvmAnnotationTarget target) {
        for (XAnnotation xAnnotation : annotations) {
            JvmAnnotationReference annotationReference = this.getJvmAnnotationReference(xAnnotation);
            target.getAnnotations().add((Object)annotationReference);
        }
    }

    protected JvmAnnotationReference getJvmAnnotationReference(XAnnotation anno) {
        JvmAnnotationValue value;
        JvmAnnotationReference reference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        JvmAnnotationType annotation = (JvmAnnotationType)anno.eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, false);
        reference.setAnnotation(annotation);
        for (XAnnotationElementValuePair val : anno.getElementValuePairs()) {
            JvmAnnotationValue annotationValue = this.getJvmAnnotationValue(val.getValue());
            if (annotationValue == null) continue;
            JvmOperation op = (JvmOperation)val.eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_PAIR__ELEMENT, false);
            annotationValue.setOperation(op);
            reference.getValues().add((Object)annotationValue);
        }
        if (anno.getValue() != null && (value = this.getJvmAnnotationValue(anno.getValue())) != null) {
            reference.getValues().add((Object)value);
        }
        return reference;
    }

    protected JvmAnnotationValue getJvmAnnotationValue(XExpression value) {
        if (value instanceof XAnnotationValueArray) {
            EList<XExpression> values = ((XAnnotationValueArray)value).getValues();
            JvmAnnotationValue result = null;
            for (XExpression expr : values) {
                AnnotationValueTranslator translator = this.translator(expr);
                if (translator == null) {
                    throw new IllegalArgumentException("expression " + value + " is not supported in annotation literals");
                }
                if (result == null) {
                    result = translator.createValue(expr);
                }
                translator.appendValue(result, expr);
            }
            return result;
        }
        if (value != null) {
            AnnotationValueTranslator translator = this.translator(value);
            if (translator == null) {
                throw new IllegalArgumentException("expression " + value + " is not supported in annotation literals");
            }
            JvmAnnotationValue result = translator.createValue(value);
            translator.appendValue(result, value);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotationValueTranslator translator(XExpression obj) {
        Map<EClass, AnnotationValueTranslator> map = this.translators;
        synchronized (map) {
            if (this.translators.isEmpty()) {
                this.translators.put(XAnnotationsPackage.Literals.XANNOTATION, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmAnnotationAnnotationValue annotationValue = (JvmAnnotationAnnotationValue)value;
                        JvmAnnotationReference annotationReference = JvmTypesBuilder.this.getJvmAnnotationReference((XAnnotation)expr);
                        annotationValue.getAnnotations().add((Object)annotationReference);
                    }
                });
                this.translators.put(XbasePackage.Literals.XSTRING_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmStringAnnotationValue annotationValue = (JvmStringAnnotationValue)value;
                        String string = ((XStringLiteral)expr).getValue();
                        annotationValue.getValues().add((Object)string);
                    }
                });
                this.translators.put(XbasePackage.Literals.XBOOLEAN_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmBooleanAnnotationValue annotationValue = (JvmBooleanAnnotationValue)value;
                        boolean isTrue = ((XBooleanLiteral)expr).isIsTrue();
                        annotationValue.getValues().add((Object)isTrue);
                    }
                });
                this.translators.put(XbasePackage.Literals.XTYPE_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmTypeAnnotationValue annotationValue = (JvmTypeAnnotationValue)value;
                        XTypeLiteral literal = (XTypeLiteral)expr;
                        JvmType proxy = (JvmType)literal.eGet((EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE, false);
                        JvmParameterizedTypeReference reference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
                        reference.setType(proxy);
                        annotationValue.getValues().add((Object)reference);
                    }
                });
                this.translators.put(XbasePackage.Literals.XINT_LITERAL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmIntAnnotationValue annotationValue = (JvmIntAnnotationValue)value;
                        annotationValue.getValues().add((Object)((XIntLiteral)expr).getValue());
                    }
                });
                this.translators.put(XbasePackage.Literals.XFEATURE_CALL, new AnnotationValueTranslator(){

                    public JvmAnnotationValue createValue(XExpression expr) {
                        return TypesFactory.eINSTANCE.createJvmCustomAnnotationValue();
                    }

                    public void appendValue(JvmAnnotationValue value, XExpression expr) {
                        JvmCustomAnnotationValue annotationValue = (JvmCustomAnnotationValue)value;
                        annotationValue.getValues().add((Object)expr);
                    }
                });
            }
        }
        return this.translators.get(obj.eClass());
    }

    static interface AnnotationValueTranslator {
        public JvmAnnotationValue createValue(XExpression var1);

        public void appendValue(JvmAnnotationValue var1, XExpression var2);
    }
}

