/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractFeaturesForTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticMethodsFeatureForTypeProvider
extends AbstractFeaturesForTypeProvider {
    @Inject
    protected IResourceScopeCache cache;
    protected Resource context;
    private boolean isExtensionProvider = false;

    @Override
    public Iterable<JvmFeature> getFeaturesByName(String name, JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (declarator != null) {
            this.collectFeatures(name, hierarchy, result);
        } else {
            this.collectFeatures(name, null, result);
        }
        return result;
    }

    @Override
    public final Iterable<JvmFeature> getAllFeatures(JvmTypeReference declarator, Iterable<JvmTypeReference> hierarchy) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (declarator != null) {
            this.collectFeatures(null, hierarchy, result);
        } else {
            this.collectFeatures(null, null, result);
        }
        return result;
    }

    protected void collectFeatures(String name, Iterable<JvmTypeReference> hierarchy, Collection<JvmFeature> result) {
        Map<JvmTypeReference, Collection<String>> staticTypeNames = this.getVisibleTypesContainingStaticMethods(hierarchy);
        for (Map.Entry<JvmTypeReference, Collection<String>> e : staticTypeNames.entrySet()) {
            for (final String staticTypeName : e.getValue()) {
                JvmTypeReference staticType = (JvmTypeReference)this.cache.get((Object)Tuples.create((Object)this, (Object)staticTypeName), this.context, (Provider)new Provider<JvmTypeReference>(){

                    public JvmTypeReference get() {
                        return AbstractStaticMethodsFeatureForTypeProvider.this.getTypeReferences().getTypeForName(staticTypeName, (Notifier)AbstractStaticMethodsFeatureForTypeProvider.this.context, new JvmTypeReference[0]);
                    }
                });
                if (staticType == null) continue;
                List rawTypes = this.getRawTypeHelper().getAllRawTypes(staticType, this.context);
                for (JvmType rawType : rawTypes) {
                    if (!(rawType instanceof JvmDeclaredType)) continue;
                    Iterable features = name != null ? ((JvmDeclaredType)rawType).findAllFeaturesByName(name) : ((JvmDeclaredType)rawType).getAllFeatures();
                    for (JvmFeature feature : features) {
                        if (!(feature instanceof JvmOperation) || !this.isMatchingExtension(e.getKey(), (JvmOperation)feature)) continue;
                        result.add(feature);
                    }
                }
            }
        }
    }

    protected boolean isMatchingExtension(JvmTypeReference expectedParameterTypeReference, JvmOperation operation) {
        if (operation.isStatic()) {
            if (expectedParameterTypeReference == null) {
                return true;
            }
            if (operation.getParameters().size() > 0) {
                JvmFormalParameter firstParam = (JvmFormalParameter)operation.getParameters().get(0);
                return super.isSameTypeOrAssignableToUpperBound(expectedParameterTypeReference, firstParam.getParameterType());
            }
        }
        return false;
    }

    protected abstract Map<JvmTypeReference, Collection<String>> getVisibleTypesContainingStaticMethods(Iterable<JvmTypeReference> var1);

    public void setResourceContext(Resource context) {
        this.context = context;
    }

    protected Resource getContext() {
        return this.context;
    }

    @Override
    public boolean isExtensionProvider() {
        return this.isExtensionProvider;
    }

    public void setExtensionProvider(boolean isExtensionProvider) {
        this.isExtensionProvider = isExtensionProvider;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [context=" + this.getContextURI() + ", isExtensionProvider=" + this.isExtensionProvider + "]";
    }

    protected String getContextURI() {
        return this.context == null ? "" : String.valueOf(this.context.getURI().lastSegment());
    }
}

