/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.xbase.scoping.featurecalls.FilteredDelegatingScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.JvmFeatureScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.LazyJvmFeatureScope;
import org.eclipse.xtext.xbase.scoping.featurecalls.LazyJvmFeatureScopeStrategy;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmFeatureScopeProvider
implements IJvmFeatureScopeProvider {
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private IFeaturesForTypeProvider featuresProvider;
    @Inject
    private SynonymTypesProvider synonymTypeProvider;

    public void setTypeArgumentContextProvider(TypeArgumentContextProvider typeArgumentContextProvider) {
        this.typeArgumentContextProvider = typeArgumentContextProvider;
    }

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    @Override
    public JvmFeatureScope createFeatureScope(IScope parent, List<IJvmFeatureScopeProvider.FeatureScopeDescription> featureScopeDescriptions) {
        Object result = parent;
        ArrayList lazyScopes = Lists.newArrayListWithCapacity((int)featureScopeDescriptions.size());
        for (IJvmFeatureScopeProvider.FeatureScopeDescription description : featureScopeDescriptions) {
            LazyJvmFeatureScope lazyScope = this.createFeatureScopeForTypeRef(description);
            lazyScopes.add(lazyScope);
            result = new FilteredDelegatingScope((IScope)result, lazyScope, false);
        }
        for (LazyJvmFeatureScope lazyScope : lazyScopes) {
            result = new FilteredDelegatingScope((IScope)result, lazyScope, true);
        }
        if (!(result instanceof JvmFeatureScope)) {
            return new JvmFeatureScope(parent, "Empty feature scope", Collections.emptyList());
        }
        return (JvmFeatureScope)((Object)result);
    }

    protected LazyJvmFeatureScope createFeatureScopeForTypeRef(IJvmFeatureScopeProvider.FeatureScopeDescription featureScopeDescription) {
        JvmTypeReference receiverType = featureScopeDescription.getReceiverType();
        ITypeArgumentContext context = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest(receiverType));
        IJvmFeatureDescriptionProvider featureDescriptionProvider = featureScopeDescription.getDescriptionProvider();
        Iterable<JvmTypeReference> hierarchy = this.linearizeTypeHierarchy(receiverType);
        IFeaturesForTypeProvider featureProvider = this.featuresProvider;
        if (featureDescriptionProvider instanceof IFeaturesForTypeProvider) {
            featureProvider = (IFeaturesForTypeProvider)((Object)featureDescriptionProvider);
        }
        LazyJvmFeatureScopeStrategy strategy = new LazyJvmFeatureScopeStrategy(featureDescriptionProvider, featureProvider, receiverType, featureScopeDescription.getContextFactory(), context, hierarchy);
        LazyJvmFeatureScope result = new LazyJvmFeatureScope(featureDescriptionProvider.toString(), strategy);
        return result;
    }

    protected boolean isValidFeature(JvmFeature input) {
        return input != null && input.getSimpleName() != null && input.getDeclaringType() != null && !(input instanceof JvmConstructor);
    }

    public Iterable<JvmTypeReference> linearizeTypeHierarchy(JvmTypeReference typeRef) {
        if (typeRef == null) {
            return Collections.emptyList();
        }
        final LinkedHashMap result = Maps.newLinkedHashMap();
        final Wrapper addOn = Wrapper.wrap((Object)0);
        final HashMap visited = Maps.newHashMap();
        if (!(typeRef.getType() instanceof JvmTypeParameter)) {
            result.put(typeRef, -1);
            visited.put(typeRef.getType(), typeRef);
        }
        SuperTypeCollector.SuperTypeAcceptor acceptor = new SuperTypeCollector.SuperTypeAcceptor(){

            public boolean accept(JvmTypeReference superType, int distance) {
                JvmTypeReference existing = (JvmTypeReference)visited.get(superType.getType());
                if (existing == null) {
                    visited.put(superType.getType(), superType);
                    result.put(superType, distance + (Integer)addOn.get());
                    return true;
                }
                Integer previousDistance = (Integer)result.get(existing);
                if (previousDistance > (Integer)addOn.get() && distance > previousDistance) {
                    visited.put(superType.getType(), superType);
                    result.remove(existing);
                    result.put(superType, distance + (Integer)addOn.get());
                    return true;
                }
                return false;
            }
        };
        this.superTypeCollector.collectSuperTypes(typeRef, acceptor);
        for (JvmTypeReference synonym : this.synonymTypeProvider.getSynonymTypes(typeRef, false)) {
            if (visited.containsKey(synonym.getType())) continue;
            result.put(synonym, result.size());
            visited.put(synonym.getType(), synonym);
            addOn.set((Object)result.size());
            this.superTypeCollector.collectSuperTypes(synonym, acceptor);
        }
        ArrayList sortable = Lists.newArrayList((Iterable)Iterables.filter(result.entrySet(), (Predicate)new Predicate<Map.Entry<JvmTypeReference, Integer>>(){

            public boolean apply(Map.Entry<JvmTypeReference, Integer> entry) {
                JvmType type = entry.getKey().getType();
                return type != null && !type.eIsProxy();
            }
        }));
        Collections.sort(sortable, new Comparator<Map.Entry<JvmTypeReference, Integer>>(){

            @Override
            public int compare(Map.Entry<JvmTypeReference, Integer> o1, Map.Entry<JvmTypeReference, Integer> o2) {
                if (o1.getValue().equals(o2.getValue())) {
                    JvmTypeReference ref1 = o1.getKey();
                    JvmTypeReference ref2 = o2.getKey();
                    if (ref1.getType() instanceof JvmGenericType && ref2.getType() instanceof JvmGenericType) {
                        if (((JvmGenericType)ref1.getType()).isInterface()) {
                            if (!((JvmGenericType)ref2.getType()).isInterface()) {
                                return 1;
                            }
                        } else if (((JvmGenericType)ref2.getType()).isInterface()) {
                            return -1;
                        }
                    }
                    return o1.getKey().getQualifiedName().compareTo(o2.getKey().getQualifiedName());
                }
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return Lists.newArrayList((Iterable)Lists.transform((List)sortable, (Function)new Function<Map.Entry<JvmTypeReference, Integer>, JvmTypeReference>(){

            public JvmTypeReference apply(Map.Entry<JvmTypeReference, Integer> from) {
                return from.getKey();
            }
        }));
    }
}

