/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.formatting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtype.XFunctionTypeRef;

public class OrganizeImports {
    @Inject
    private Provider<ReferenceAcceptor> referenceAcceptorProvider;

    public String getOrganizedImportSection(XtextResource state) {
        List<String> listofStaticExtensionImports;
        List<String> listofStaticImports;
        ReferenceAcceptor acceptor = (ReferenceAcceptor)this.referenceAcceptorProvider.get();
        XtendFile xtendFile = this.getXtendFile(state);
        if (xtendFile == null) {
            return null;
        }
        acceptor.addImplicitlyImportedPackages(Lists.newArrayList((Object[])new String[]{"java.lang", xtendFile.getPackage()}));
        this.collectAllReferences(state, acceptor);
        StringBuilder importsSection = new StringBuilder();
        List<String> listofImportedTypeNames = acceptor.getListofImportedTypeNames();
        if (!listofImportedTypeNames.isEmpty()) {
            importsSection.append("\n");
            for (String qn : listofImportedTypeNames) {
                importsSection.append("\nimport ").append(qn);
            }
        }
        if (!(listofStaticImports = acceptor.getListofStaticImports()).isEmpty()) {
            importsSection.append("\n");
            for (String qn : listofStaticImports) {
                importsSection.append("\nimport static ").append(qn).append(".*");
            }
        }
        if (!(listofStaticExtensionImports = acceptor.getListofStaticExtensionImports()).isEmpty()) {
            importsSection.append("\n");
            for (String qn : listofStaticExtensionImports) {
                importsSection.append("\nimport static extension ").append(qn).append(".*");
            }
        }
        return importsSection.toString();
    }

    public TextRegion computeRegion(XtextResource resource) {
        XtendFile xtendFile = this.getXtendFile(resource);
        if (xtendFile == null) {
            return null;
        }
        List packDecl = NodeModelUtils.findNodesForFeature((EObject)xtendFile, (EStructuralFeature)Xtend2Package.Literals.XTEND_FILE__PACKAGE);
        int offset = 0;
        if (packDecl.size() >= 1) {
            offset = ((INode)packDecl.get(0)).getOffset() + ((INode)packDecl.get(0)).getLength();
        }
        if (xtendFile.getXtendClass() == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)xtendFile.getXtendClass());
        int length = node.getTotalOffset() - offset;
        return new TextRegion(offset, length);
    }

    protected XtendFile getXtendFile(XtextResource resource) {
        if (resource.getContents().isEmpty()) {
            return null;
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        if (!(eObject instanceof XtendFile)) {
            return null;
        }
        XtendFile xtendFile = (XtendFile)eObject;
        return xtendFile;
    }

    public void collectAllReferences(XtextResource resource, ReferenceAcceptor acceptor) {
        XtendFile xtendFile = this.getXtendFile(resource);
        TreeIterator contents = EcoreUtil.getAllContents((EObject)xtendFile, (boolean)true);
        while (contents.hasNext()) {
            JvmIdentifiableElement member;
            XFeatureCall featureCall;
            EObject next = (EObject)contents.next();
            if (next instanceof JvmTypeReference) {
                acceptor.acceptType((JvmTypeReference)next);
                continue;
            }
            if (next instanceof XAnnotation) {
                acceptor.acceptType((JvmType)((XAnnotation)next).getAnnotationType());
                continue;
            }
            if (next instanceof XInstanceOfExpression) {
                acceptor.acceptType(((XInstanceOfExpression)next).getType());
                continue;
            }
            if (next instanceof XConstructorCall) {
                acceptor.acceptType((JvmType)((XConstructorCall)next).getConstructor().getDeclaringType());
                continue;
            }
            if (next instanceof XTypeLiteral) {
                acceptor.acceptType(((XTypeLiteral)next).getType());
                continue;
            }
            if (next instanceof XFeatureCall) {
                featureCall = (XFeatureCall)next;
                if (featureCall.getDeclaringType() == null) {
                    member = featureCall.getFeature();
                    if (member instanceof JvmOperation && ((JvmOperation)member).isStatic()) {
                        acceptor.acceptStaticImport((JvmMember)member);
                    }
                    if (!(member instanceof JvmField) || !((JvmField)member).isStatic()) continue;
                    acceptor.acceptStaticImport((JvmMember)member);
                    continue;
                }
                acceptor.acceptType((JvmType)featureCall.getDeclaringType());
                continue;
            }
            if (!(next instanceof XMemberFeatureCall)) continue;
            featureCall = (XMemberFeatureCall)next;
            member = featureCall.getFeature();
            if (member instanceof JvmOperation && ((JvmOperation)member).isStatic()) {
                acceptor.acceptStaticExtensionImport((JvmMember)member);
            }
            if (!(member instanceof JvmField) || !((JvmField)member).isStatic()) continue;
            acceptor.acceptStaticExtensionImport((JvmMember)member);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReferenceAcceptor {
        public Set<JvmType> types = Sets.newLinkedHashSet();
        public Set<JvmType> staticMembers = Sets.newLinkedHashSet();
        public Set<JvmType> staticExtensionMembers = Sets.newLinkedHashSet();
        private Set<String> implicitPackageImports = Sets.newLinkedHashSet();

        public void acceptType(JvmTypeReference ref) {
            block5: {
                block4: {
                    if (ref instanceof XFunctionTypeRef) {
                        return;
                    }
                    if (ref.eContainer() instanceof XFunctionTypeRef && ref.eContainmentFeature() == TypesPackage.Literals.JVM_SPECIALIZED_TYPE_REFERENCE__EQUIVALENT) {
                        return;
                    }
                    this.acceptType(ref.getType());
                    if (!(ref instanceof JvmParameterizedTypeReference)) break block4;
                    EList list = ((JvmParameterizedTypeReference)ref).getArguments();
                    for (JvmTypeReference jvmTypeReference : list) {
                        this.acceptType(jvmTypeReference);
                    }
                    break block5;
                }
                if (!(ref instanceof JvmWildcardTypeReference)) break block5;
                EList constraints = ((JvmWildcardTypeReference)ref).getConstraints();
                for (JvmTypeConstraint jvmTypeConstraint : constraints) {
                    this.acceptType(jvmTypeConstraint.getTypeReference());
                }
            }
        }

        public void addImplicitlyImportedPackages(Collection<? extends String> implicitlyImportedPackage) {
            this.implicitPackageImports.addAll(implicitlyImportedPackage);
        }

        public List<String> getListofStaticExtensionImports() {
            ArrayList result = Lists.newArrayList();
            for (JvmType type : this.staticExtensionMembers) {
                if (!this.isMemberNeedsImport(type)) continue;
                result.add(type.getIdentifier());
            }
            Collections.sort(result);
            return result;
        }

        protected boolean isMemberNeedsImport(JvmType type) {
            return type instanceof JvmEnumerationType || type instanceof JvmGenericType && !"org.eclipse.xtext.xbase.lib".equals(((JvmGenericType)type).getPackageName());
        }

        public List<String> getListofStaticImports() {
            ArrayList result = Lists.newArrayList();
            for (JvmType type : this.staticMembers) {
                if (!this.isMemberNeedsImport(type)) continue;
                result.add(type.getIdentifier());
            }
            List<String> staticExtensionImports = this.getListofStaticExtensionImports();
            result.removeAll(staticExtensionImports);
            Collections.sort(result);
            return result;
        }

        public List<String> getListofImportedTypeNames() {
            LinkedHashMap names = Maps.newLinkedHashMap();
            for (JvmType type : this.types) {
                JvmDeclaredType jvmGenericType;
                if (!(type instanceof JvmDeclaredType) || !this.isTypeNeedsImport(jvmGenericType = (JvmDeclaredType)type)) continue;
                this.addType(names, jvmGenericType);
            }
            ArrayList result = Lists.newArrayList(names.values());
            Collections.sort(result);
            return result;
        }

        protected boolean isTypeNeedsImport(JvmDeclaredType jvmType) {
            String packageName = jvmType.getPackageName();
            return !this.implicitPackageImports.contains(packageName);
        }

        protected void addType(Map<String, String> names, JvmDeclaredType type) {
            String simpleName;
            String packageName = type.getPackageName();
            String string = simpleName = packageName != null ? type.getQualifiedName().substring(packageName.length() + 1) : type.getQualifiedName();
            if (simpleName == null) {
                return;
            }
            if (!names.containsKey(simpleName)) {
                String identifier = type.getIdentifier();
                if (identifier == null) {
                    return;
                }
                names.put(simpleName, identifier);
            }
        }

        public void acceptType(JvmType type) {
            this.types.add(type);
        }

        public void acceptStaticImport(JvmMember member) {
            this.staticMembers.add((JvmType)member.getDeclaringType());
        }

        public void acceptStaticExtensionImport(JvmMember member) {
            this.staticExtensionMembers.add((JvmType)member.getDeclaringType());
        }
    }
}

