/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.jvmmodel;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.lib.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchMethodCompileStrategy
implements Functions.Function1<ImportManager, CharSequence> {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferenceSerializer typeReferenceSerializer;
    private List<JvmOperation> sortedDispatchOperations;
    private JvmOperation dispatchOperation;

    protected void initialize(JvmOperation dispatchOperation, List<JvmOperation> sortedDispatchOperations) {
        this.dispatchOperation = dispatchOperation;
        this.sortedDispatchOperations = sortedDispatchOperations;
    }

    public CharSequence apply(ImportManager importManager) {
        final StringBuilderBasedAppendable a = new StringBuilderBasedAppendable(importManager);
        boolean needsElse = true;
        for (JvmOperation operation : this.sortedDispatchOperations) {
            Iterator iter1 = this.dispatchOperation.getParameters().iterator();
            final ArrayList laters = Lists.newArrayList();
            Iterator iter2 = operation.getParameters().iterator();
            while (iter2.hasNext()) {
                JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
                JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
                final JvmTypeReference type = p2.getParameterType();
                final String name = this.getVarName((JvmIdentifiableElement)p1, (IAppendable)a);
                if (this.typeConformanceComputer.isConformant(p2.getParameterType(), p1.getParameterType(), true)) continue;
                if (this.typeReferences.is(type, Void.class)) {
                    laters.add(new Later(){

                        public void exec() {
                            if (laters.size() > 1) {
                                a.append("(");
                            }
                            a.append(name).append(" == null");
                            if (laters.size() > 1) {
                                a.append(")");
                            }
                        }
                    });
                    continue;
                }
                laters.add(new Later(){

                    public void exec() {
                        if (laters.size() > 1) {
                            a.append("(");
                        }
                        a.append(name).append(" instanceof ");
                        a.append(DispatchMethodCompileStrategy.this.primitives.asWrapperTypeIfPrimitive(type).getType());
                        if (laters.size() > 1) {
                            a.append(")");
                        }
                    }
                });
            }
            if (this.sortedDispatchOperations.get(0) != operation) {
                a.append(" else ");
            }
            if (laters.isEmpty()) {
                needsElse = false;
                a.append("{").increaseIndentation();
            } else {
                a.append("if (");
                a.increaseIndentation().increaseIndentation();
                Iterator iterator = laters.iterator();
                while (iterator.hasNext()) {
                    ((Later)iterator.next()).exec();
                    if (!iterator.hasNext()) continue;
                    a.append("\n && ");
                }
                a.decreaseIndentation().decreaseIndentation();
                a.append(") {").increaseIndentation();
            }
            a.append("\n");
            boolean isCurrentVoid = this.typeReferences.is(operation.getReturnType(), Void.TYPE);
            boolean isDispatchVoid = this.typeReferences.is(this.dispatchOperation.getReturnType(), Void.TYPE);
            if (isDispatchVoid) {
                this.generateActualDispatchCall(this.dispatchOperation, operation, (IAppendable)a);
                a.append(";");
            } else {
                if (isCurrentVoid) {
                    this.generateActualDispatchCall(this.dispatchOperation, operation, (IAppendable)a);
                    a.append(";\nreturn null");
                } else {
                    a.append("return ");
                    this.generateActualDispatchCall(this.dispatchOperation, operation, (IAppendable)a);
                }
                a.append(";");
            }
            a.decreaseIndentation().append("\n}");
        }
        if (needsElse) {
            a.append(" else {").increaseIndentation();
            a.append("\n");
            a.increaseIndentation();
            a.append("throw new IllegalArgumentException(\"Unhandled parameter types: \" +\n");
            JvmType jvmType = this.typeReferences.findDeclaredType("java.util.Arrays", (Notifier)this.dispatchOperation);
            a.append(jvmType).append(".<Object>asList(");
            Iterator iterator = this.dispatchOperation.getParameters().iterator();
            while (iterator.hasNext()) {
                JvmFormalParameter parameter = (JvmFormalParameter)iterator.next();
                String name = this.getVarName((JvmIdentifiableElement)parameter, (IAppendable)a);
                a.append(name);
                if (!iterator.hasNext()) continue;
                a.append(", ");
            }
            a.append(").toString());");
            a.decreaseIndentation();
            a.decreaseIndentation().append("\n}");
        }
        return a.toString();
    }

    protected void generateActualDispatchCall(JvmOperation dispatchOperation, JvmOperation actualOperationToCall, IAppendable a) {
        a.append(actualOperationToCall.getSimpleName()).append("(");
        Iterator iter1 = dispatchOperation.getParameters().iterator();
        Iterator iter2 = actualOperationToCall.getParameters().iterator();
        while (iter2.hasNext()) {
            JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
            JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
            if (!this.typeConformanceComputer.isConformant(p2.getParameterType(), p1.getParameterType(), true)) {
                a.append("(");
                this.typeReferenceSerializer.serialize(this.primitives.asWrapperTypeIfPrimitive(p2.getParameterType()), (EObject)dispatchOperation, a);
                a.append(")");
            }
            if (this.typeReferences.is(p2.getParameterType(), Void.class)) {
                a.append("null");
            } else {
                a.append(this.getVarName((JvmIdentifiableElement)p1, a));
            }
            if (!iter2.hasNext()) continue;
            a.append(", ");
        }
        a.append(")");
    }

    protected String getVarName(JvmIdentifiableElement ex, IAppendable appendable) {
        return ex.getSimpleName();
    }
}

