/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.validation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.IRawTypeHelper;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.validation.XbaseWithAnnotationsJavaValidator;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.richstring.RichStringProcessor;
import org.eclipse.xtext.xtend2.typing.XtendOverridesService;
import org.eclipse.xtext.xtend2.validation.ClasspathBasedChecks;
import org.eclipse.xtext.xtend2.validation.ValidatingRichStringAcceptor;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringElseIf;
import org.eclipse.xtext.xtend2.xtend2.RichStringForLoop;
import org.eclipse.xtext.xtend2.xtend2.RichStringIf;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendImport;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;
import org.eclipse.xtext.xtend2.xtend2.XtendParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComposedChecks(validators={ClasspathBasedChecks.class})
public class Xtend2JavaValidator
extends XbaseWithAnnotationsJavaValidator {
    @Inject
    private FeatureOverridesService featureOverridesService;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private IXtend2JvmAssociations associations;
    @Inject
    private XtendOverridesService overridesService;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IRawTypeHelper rawTypeHelper;
    @Inject
    private XAnnotationUtil annotationUtil;
    private final Set<EReference> typeConformanceCheckedReferences = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.getTypeConformanceCheckedReferences(), (Iterable)ImmutableSet.of((Object)Xtend2Package.Literals.RICH_STRING_FOR_LOOP__AFTER, (Object)Xtend2Package.Literals.RICH_STRING_FOR_LOOP__BEFORE, (Object)Xtend2Package.Literals.RICH_STRING_FOR_LOOP__SEPARATOR, (Object)Xtend2Package.Literals.RICH_STRING_IF__IF, (Object)Xtend2Package.Literals.RICH_STRING_ELSE_IF__IF)));

    protected List<EPackage> getEPackages() {
        return Lists.newArrayList((Object[])new EPackage[]{Xtend2Package.eINSTANCE, XbasePackage.eINSTANCE, XAnnotationsPackage.eINSTANCE});
    }

    protected Set<EReference> getTypeConformanceCheckedReferences() {
        return this.typeConformanceCheckedReferences;
    }

    @Check
    public void checkNoSideffectFreeExpressionsInBlockExpression(XBlockExpression blockExpression) {
        if (blockExpression instanceof RichString) {
            return;
        }
        super.checkNoSideffectFreeExpressionsInBlockExpression(blockExpression);
    }

    @Check
    public void checkAnnotationTarget(XAnnotation annotation) {
        JvmAnnotationType annotationType = annotation.getAnnotationType();
        Set targets = this.annotationUtil.getAnnotationTargets(annotationType);
        if (targets.isEmpty()) {
            return;
        }
        EObject eContainer = this.getContainingAnnotationTarget(annotation);
        Map<Class<?>, ElementType> targetInfos = this.getTargetInfos();
        for (Map.Entry<Class<?>, ElementType> mapping : targetInfos.entrySet()) {
            if (!mapping.getKey().isInstance(eContainer) || targets.contains((Object)mapping.getValue())) continue;
            this.error("The annotation @" + annotation.getAnnotationType().getSimpleName() + " is disallowed for this location.", (EObject)annotation, null, -1, "org.eclipse.xtext.xtend2.validation.IssueCodes.wrong_annotation_target", new String[0]);
        }
    }

    protected EObject getContainingAnnotationTarget(XAnnotation annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer.eClass() == Xtend2Package.Literals.XTEND_MEMBER) {
            return eContainer.eContainer();
        }
        return eContainer;
    }

    protected Map<Class<?>, ElementType> getTargetInfos() {
        HashMap result = Maps.newHashMap();
        result.put(XtendClass.class, ElementType.TYPE);
        result.put(XtendField.class, ElementType.FIELD);
        result.put(XtendFunction.class, ElementType.METHOD);
        result.put(XtendParameter.class, ElementType.PARAMETER);
        return result;
    }

    @Check
    public void checkAssignment(XAssignment assignment) {
        JvmIdentifiableElement assignmentFeature = assignment.getFeature();
        if (assignmentFeature instanceof XtendParameter) {
            this.error("Assignment to final parameter", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else {
            super.checkAssignment(assignment);
        }
    }

    @Check
    public void checkVariableNameShadowing(XtendFunction func) {
        JvmOperation operation = this.associations.getDirectlyInferredOperation(func);
        if (operation != null) {
            for (JvmFormalParameter p : operation.getParameters()) {
                super.checkDeclaredVariableName((EObject)operation, (EObject)p, TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME);
            }
        }
    }

    @Check
    public void checkNoVoidInDependencyDeclaration(XtendField dep) {
        if (this.typeReferences.is(dep.getType(), Void.TYPE)) {
            this.error("Primitive void cannot be a dependency.", (EObject)dep.getType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkMemberNamesAreUnique(XtendClass xtendClass) {
        Collection fields;
        HashMultimap name2field = HashMultimap.create();
        HashMultimap type2extension = HashMultimap.create();
        for (XtendMember member : xtendClass.getMembers()) {
            if (!(member instanceof XtendField)) continue;
            XtendField field = (XtendField)member;
            if (Strings.isEmpty((String)field.getName())) {
                JvmType type;
                if (!field.isExtension() || (type = field.getType().getType()) == null) continue;
                type2extension.put((Object)type, (Object)field);
                continue;
            }
            name2field.put((Object)field.getName(), (Object)field);
        }
        for (String name : name2field.keySet()) {
            fields = name2field.get((Object)name);
            if (fields.size() <= 1) continue;
            for (XtendField field : fields) {
                this.error("Duplicate field " + name, field, (EStructuralFeature)Xtend2Package.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_field", new String[0]);
            }
        }
        for (JvmType type : type2extension.keySet()) {
            fields = type2extension.get((Object)type);
            if (fields.size() <= 1) continue;
            for (XtendField field : fields) {
                this.error("Duplicate extension with same type", field, (EStructuralFeature)Xtend2Package.Literals.XTEND_FIELD__TYPE, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_field", new String[0]);
            }
        }
    }

    @Check
    public void checkXtendParameterNotPrimitiveVoid(XtendParameter param) {
        if (this.typeReferences.is(param.getParameterType(), Void.TYPE)) {
            XtendFunction function = (XtendFunction)(param.eContainer() instanceof XtendFunction ? param.eContainer() : null);
            if (function != null) {
                this.error("void is an invalid type for the parameter " + param.getName() + " of the function " + function.getName(), (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("void is an invalid type for the parameter " + param.getName(), (EObject)param.getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    @Check
    public void checkClassPath(XtendClass clazz) {
        JvmGenericType listType = (JvmGenericType)this.getTypeRefs().findDeclaredType(List.class.getName(), (Notifier)clazz);
        if (listType == null || listType.getTypeParameters().isEmpty()) {
            this.error("Xtend requires Java source level 1.5.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
        if (this.getTypeRefs().findDeclaredType("org.eclipse.xtext.xtend2.lib.StringConcatenation", (Notifier)clazz) == null) {
            this.error("Mandatory library bundle 'org.eclipse.xtext.xtend2.lib' not found on the classpath.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xtend_lib_not_on_classpath", new String[0]);
        }
        if (this.getTypeRefs().findDeclaredType("org.eclipse.xtext.xbase.lib.ObjectExtensions", (Notifier)clazz) == null) {
            this.error("Mandatory library bundle 'org.eclipse.xtext.xbase.lib' not found on the classpath.", clazz, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.xbase_lib_not_on_classpath", new String[0]);
        }
    }

    @Check
    public void checkWhitespaceInRichStrings(RichString richString) {
        Object container;
        if (richString.eContainer() instanceof RichStringIf && ((container = (RichStringIf)richString.eContainer()).getThen() == richString || container.getElse() == richString)) {
            return;
        }
        if (richString.eContainer() instanceof RichStringElseIf && (container = (RichStringElseIf)richString.eContainer()).getThen() == richString) {
            return;
        }
        if (richString.eContainer() instanceof RichStringForLoop && (container = (RichStringForLoop)richString.eContainer()).getEachExpression() == richString) {
            return;
        }
        this.doCheckWhitespaceIn(richString);
    }

    protected void doCheckWhitespaceIn(RichString richString) {
        ValidatingRichStringAcceptor helper = new ValidatingRichStringAcceptor((ValidationMessageAcceptor)this);
        this.richStringProcessor.process(richString, helper, helper);
    }

    @Check
    public void checkSuperTypes(XtendClass xtendClass) {
        JvmTypeReference superClass = xtendClass.getExtends();
        if (superClass != null && superClass.getType() != null) {
            if (!(superClass.getType() instanceof JvmGenericType) || ((JvmGenericType)superClass.getType()).isInterface()) {
                this.error("Superclass must be a class", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__EXTENDS, "org.eclipse.xtext.xtend2.validation.IssueCodes.class_expected", new String[0]);
            } else {
                JvmGenericType inferredType;
                if (((JvmGenericType)superClass.getType()).isFinal()) {
                    this.error("Attempt to override final class", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__EXTENDS, "org.eclipse.xtext.xtend2.validation.IssueCodes.overridden_final", new String[0]);
                }
                if ((inferredType = this.associations.getInferredType(xtendClass)) != null && this.hasCycleInHierarchy(inferredType, Lists.newArrayList())) {
                    this.error("The inheritance hierarchy of " + Strings.notNull((Object)xtendClass.getName()) + " contains cycles", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.cyclic_inheritance", new String[0]);
                }
            }
        }
        int i = 0;
        while (i < xtendClass.getImplements().size()) {
            JvmTypeReference implementedType = (JvmTypeReference)xtendClass.getImplements().get(i);
            if (!(implementedType.getType() instanceof JvmGenericType) || !((JvmGenericType)implementedType.getType()).isInterface()) {
                this.error("Implemented interface must be an interface", (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__IMPLEMENTS, i, "org.eclipse.xtext.xtend2.validation.IssueCodes.interface_expected", new String[0]);
            }
            ++i;
        }
    }

    protected boolean hasCycleInHierarchy(JvmGenericType type, List<JvmGenericType> processedSuperTypes) {
        if (type.isInterface()) {
            return false;
        }
        if (processedSuperTypes.contains(type)) {
            return true;
        }
        processedSuperTypes.add(type);
        for (JvmTypeReference superTypeRef : type.getSuperTypes()) {
            if (!(superTypeRef.getType() instanceof JvmGenericType) || !this.hasCycleInHierarchy((JvmGenericType)superTypeRef.getType(), processedSuperTypes)) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkDuplicateAndOverriddenFunctions(XtendClass xtendClass) {
        final JvmGenericType inferredType = this.associations.getInferredType(xtendClass);
        if (inferredType != null) {
            Signature signature;
            final JvmParameterizedTypeReference typeReference = this.typeReferences.createTypeRef((JvmType)inferredType, new JvmTypeReference[0]);
            if (xtendClass.getTypeParameters().isEmpty()) {
                typeReference.getArguments().clear();
            }
            final ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.AbstractRequest(){

                public JvmTypeReference getReceiverType() {
                    return typeReference;
                }

                public String toString() {
                    return "Xtend2JavaValidator.checkDuplicateAndOverriddenFunctions [inferredType=" + inferredType.getIdentifier() + "]";
                }

                public JvmTypeParameterDeclarator getNearestDeclarator() {
                    return inferredType;
                }
            });
            HashMultimap operationsPerErasure = HashMultimap.create();
            for (JvmOperation operation : inferredType.getDeclaredOperations()) {
                signature = this.getSignature(operation);
                operationsPerErasure.put(signature.getErasureKey(), (Object)operation);
            }
            for (Collection operationsWithSameSignature : operationsPerErasure.asMap().values()) {
                if (operationsWithSameSignature.size() <= 1) continue;
                HashMultimap operationsPerReadableSignature = HashMultimap.create();
                for (JvmOperation operation : operationsWithSameSignature) {
                    String readableSignature = this.getReadableSignature((JvmIdentifiableElement)operation, (List<JvmFormalParameter>)operation.getParameters());
                    operationsPerReadableSignature.put((Object)readableSignature, (Object)operation);
                }
                for (Collection operationsWithSameReadableSignature : operationsPerReadableSignature.asMap().values()) {
                    XtendFunction otherSource;
                    if (operationsWithSameReadableSignature.size() > 1) {
                        for (JvmOperation operation : operationsWithSameReadableSignature) {
                            otherSource = this.associations.getXtendFunction(operation);
                            this.error("Duplicate method " + this.getReadableSignature((JvmIdentifiableElement)operation, (List<JvmFormalParameter>)operation.getParameters()) + " in type " + inferredType.getSimpleName(), otherSource, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                        }
                        continue;
                    }
                    for (JvmOperation operation : operationsWithSameReadableSignature) {
                        otherSource = this.associations.getXtendFunction(operation);
                        this.error("Method  " + this.getReadableSignature((JvmIdentifiableElement)operation, (List<JvmFormalParameter>)operation.getParameters()) + " has the same erasure " + this.getReadableErasure((JvmIdentifiableElement)operation, (List<JvmFormalParameter>)operation.getParameters()) + " as another method in type " + inferredType.getSimpleName(), otherSource, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                    }
                }
            }
            for (JvmOperation operation : Iterables.filter((Iterable)this.featureOverridesService.getAllJvmFeatures((JvmDeclaredType)inferredType, typeArgumentContext), JvmOperation.class)) {
                JvmOperation myOperation2;
                Collection myOperations;
                if (operation.getDeclaringType() == inferredType) continue;
                signature = this.getSignature(operation);
                if (operationsPerErasure.containsKey(signature.getErasureKey()) && (myOperations = operationsPerErasure.get(signature.getErasureKey())).size() == 1 && !this.featureOverridesService.isOverridden((JvmFeature)(myOperation2 = (JvmOperation)Iterables.getOnlyElement((Iterable)myOperations)), (JvmFeature)operation, typeArgumentContext, false)) {
                    XtendFunction source = this.associations.getXtendFunction(myOperation2);
                    this.error("Name clash: The method " + this.getReadableSignature((JvmIdentifiableElement)myOperation2, (List<JvmFormalParameter>)myOperation2.getParameters()) + " of type " + inferredType.getSimpleName() + " has the same erasure as " + this.getReadableSignature((JvmIdentifiableElement)operation, (List<JvmFormalParameter>)operation.getParameters()) + " of type " + operation.getDeclaringType().getSimpleName() + " but does not override it.", source, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                }
                if (!operation.isAbstract() || inferredType.isAbstract()) continue;
                boolean overridden = false;
                if (operationsPerErasure.containsKey(signature.getErasureKey())) {
                    for (JvmOperation myOperation2 : operationsPerErasure.get(signature.getErasureKey())) {
                        if (!this.featureOverridesService.isOverridden((JvmFeature)myOperation2, (JvmFeature)operation, typeArgumentContext, false)) continue;
                        overridden = true;
                        break;
                    }
                }
                if (overridden) continue;
                this.error("The class " + inferredType.getSimpleName() + " must be defined abstract because it does not implement " + this.getReadableSignature(operation.getSimpleName(), Lists.transform((List)operation.getParameters(), (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

                    public JvmTypeReference apply(JvmFormalParameter from) {
                        JvmTypeReference parameterType = from.getParameterType();
                        JvmTypeReference result = typeArgumentContext.resolve(parameterType);
                        return result;
                    }
                })), xtendClass, (EStructuralFeature)Xtend2Package.Literals.XTEND_CLASS__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.class_must_be_defined_abstract", new String[0]);
            }
        }
    }

    @Check
    protected void checkFunctionOverride(XtendFunction function) {
        JvmOperation inferredOperation;
        JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(function);
        if (overriddenOperation == null) {
            if (function.isOverride()) {
                this.error("Function does not override any function", function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__OVERRIDE, "org.eclipse.xtext.xtend2.validation.IssueCodes.obsolete_override", new String[0]);
            }
            return;
        }
        if (!function.isOverride()) {
            this.error("Missing 'override'. Function overrides " + this.canonicalName((JvmIdentifiableElement)overriddenOperation), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.missing_override", new String[0]);
        }
        if (overriddenOperation.isFinal()) {
            this.error("Attempt to override final method " + this.canonicalName((JvmIdentifiableElement)overriddenOperation), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.overridden_final", new String[0]);
        }
        if (this.isMorePrivateThan((inferredOperation = this.associations.getDirectlyInferredOperation(function)).getVisibility(), overriddenOperation.getVisibility())) {
            this.error("Cannot reduce the visibility of the overridden method " + overriddenOperation.getIdentifier(), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.override_reduces_visibility", new String[0]);
        }
        if (function.getReturnType() == null) {
            return;
        }
        ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest((JvmTypeReference)this.getTypeRefs().createTypeRef((JvmType)inferredOperation.getDeclaringType(), new JvmTypeReference[0])));
        JvmTypeReference returnTypeUpperBound = typeArgumentContext.getUpperBound(overriddenOperation.getReturnType(), (Notifier)function);
        if (!this.isConformant(returnTypeUpperBound, function.getReturnType())) {
            this.error("The return type is incompatible with " + overriddenOperation.getIdentifier(), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__RETURN_TYPE, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
        }
    }

    protected boolean isMorePrivateThan(JvmVisibility o1, JvmVisibility o2) {
        if (o1 == o2) {
            return false;
        }
        switch (o1) {
            case DEFAULT: {
                return o2 != JvmVisibility.PRIVATE;
            }
            case PRIVATE: {
                return true;
            }
            case PROTECTED: {
                return o2 == JvmVisibility.PUBLIC;
            }
            case PUBLIC: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown JvmVisibility " + o1);
    }

    protected Iterable<JvmOperation> allSuperOperations(XtendClass xtendClass) {
        Iterable result = Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.concat(Collections.singleton(xtendClass.getExtends()), xtendClass.getImplements()), (Predicate)Predicates.notNull()), (Function)new Function<JvmTypeReference, Iterable<JvmFeature>>(){

            public Iterable<JvmFeature> apply(JvmTypeReference from) {
                return Xtend2JavaValidator.this.featureOverridesService.getAllJvmFeatures(from);
            }
        })), JvmOperation.class);
        return result;
    }

    protected boolean isInterface(JvmDeclaredType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected String canonicalName(JvmIdentifiableElement element) {
        return element != null ? Strings.notNull((Object)element.getIdentifier()) : null;
    }

    protected Signature getSignature(JvmOperation operation) {
        return new Signature(operation);
    }

    protected String getReadableSignature(JvmIdentifiableElement element, List<JvmFormalParameter> parameters) {
        if (element == null) {
            return "null";
        }
        return this.getReadableSignature(element.getSimpleName(), Lists.transform(parameters, (Function)new Function<JvmFormalParameter, JvmTypeReference>(){

            public JvmTypeReference apply(JvmFormalParameter from) {
                return from.getParameterType();
            }
        }));
    }

    protected String getReadableSignature(String elementName, List<JvmTypeReference> parameters) {
        StringBuilder result = new StringBuilder(elementName);
        result.append('(');
        int i = 0;
        while (i < parameters.size()) {
            JvmTypeReference parameterType;
            if (i != 0) {
                result.append(", ");
            }
            if ((parameterType = parameters.get(i)) != null) {
                result.append(parameterType.getSimpleName());
            } else {
                result.append("null");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    protected String getReadableErasure(JvmIdentifiableElement element, List<JvmFormalParameter> parameters) {
        if (element == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder(element.getSimpleName());
        result.append('(');
        int i = 0;
        while (i < parameters.size()) {
            List rawTypes;
            if (i != 0) {
                result.append(", ");
            }
            if (!(rawTypes = this.rawTypeHelper.getAllRawTypes(parameters.get(i).getParameterType(), element.eResource())).isEmpty()) {
                result.append(((JvmType)rawTypes.get(0)).getSimpleName());
            } else {
                result.append("null");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    @Check
    public void checkParameterNames(XtendFunction function) {
        int i = 0;
        while (i < function.getParameters().size()) {
            String leftParameterName = ((XtendParameter)function.getParameters().get(i)).getName();
            int j = i + 1;
            while (j < function.getParameters().size()) {
                if (Strings.equal((String)leftParameterName, (String)((XtendParameter)function.getParameters().get(j)).getName())) {
                    this.error("Duplicate parameter name", (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__PARAMETERS, i, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                    this.error("Duplicate parameter name", (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__PARAMETERS, j, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                }
                ++j;
            }
            if (function.getCreateExtensionInfo() != null && Strings.equal((String)leftParameterName, (String)function.getCreateExtensionInfo().getName())) {
                this.error("Duplicate parameter name", (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__PARAMETERS, i, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                if (function.getCreateExtensionInfo().eIsSet((EStructuralFeature)Xtend2Package.Literals.CREATE_EXTENSION_INFO__NAME)) {
                    this.error("Duplicate parameter name", function.getCreateExtensionInfo(), (EStructuralFeature)Xtend2Package.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                } else {
                    this.error("Duplicate implicit parameter name 'it'", function.getCreateExtensionInfo(), (EStructuralFeature)Xtend2Package.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                }
            }
            ++i;
        }
    }

    @Check
    public void dispatchFuncWithTypeParams(XtendFunction func) {
        if (func.isDispatch()) {
            if (func.getParameters().isEmpty()) {
                this.error("A dispatch function mus at least have one parameter declared.", func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH, "org.eclipse.xtext.xtend2.validation.IssueCodes.case_function_without_params", new String[0]);
            }
            if (!func.getTypeParameters().isEmpty()) {
                this.error("A dispatch function must not declare any type parameters.", func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH, "org.eclipse.xtext.xtend2.validation.IssueCodes.case_function_with_type_params", new String[0]);
            }
            if (func.getName().startsWith("_")) {
                this.error("A dispatch method's name must not start with an underscore.", func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xtend2.validation.IssueCodes.case_func_name_starts_with_underscore", new String[0]);
            }
        }
    }

    @Check
    public void checkDispatchFunctions(XtendClass clazz) {
        JvmGenericType type = this.associations.getInferredType(clazz);
        if (type != null) {
            Multimap<Pair<String, Integer>, JvmOperation> dispatchMethods = this.dispatchingSupport.getDispatchMethods(type);
            for (Pair key : dispatchMethods.keySet()) {
                Collection dispatchOperations = dispatchMethods.get((Object)key);
                JvmOperation syntheticDispatchMethod = this.dispatchingSupport.findSyntheticDispatchMethod(clazz, (Pair<String, Integer>)key);
                JvmOperation overriddenOperation = this.overridesService.findOverriddenOperation(syntheticDispatchMethod);
                if (overriddenOperation != null && this.isMorePrivateThan(syntheticDispatchMethod.getVisibility(), overriddenOperation.getVisibility())) {
                    this.addVisibilityError(dispatchOperations, "Synthetic dispatch method reduces visibility of overridden function " + overriddenOperation.getIdentifier(), "org.eclipse.xtext.xtend2.validation.IssueCodes.override_reduces_visibility");
                }
                if (dispatchOperations.size() == 1) {
                    JvmOperation singleOp = (JvmOperation)dispatchOperations.iterator().next();
                    XtendFunction function = this.associations.getXtendFunction(singleOp);
                    this.warning("Single dispatch function.", function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH, "org.eclipse.xtext.xtend2.validation.IssueCodes.single_case_function", new String[0]);
                    continue;
                }
                HashMultimap signatures = HashMultimap.create();
                boolean isFirstLocalOperation = true;
                JvmVisibility commonVisibility = null;
                for (JvmOperation jvmOperation : dispatchOperations) {
                    XtendFunction function;
                    signatures.put(this.getParamTypes(jvmOperation, true), (Object)jvmOperation);
                    if (jvmOperation.getDeclaringType() == type) {
                        if (isFirstLocalOperation) {
                            commonVisibility = jvmOperation.getVisibility();
                            isFirstLocalOperation = false;
                        } else if (jvmOperation.getVisibility() != commonVisibility) {
                            commonVisibility = null;
                        }
                    }
                    if ((function = this.associations.getXtendFunction(jvmOperation)) == null) continue;
                    JvmTypeReference functionReturnType = function.getReturnType();
                    if (functionReturnType == null) {
                        functionReturnType = this.getTypeProvider().getCommonReturnType(function.getExpression(), true);
                    }
                    if (functionReturnType == null || this.isConformant(jvmOperation.getReturnType(), functionReturnType)) continue;
                    this.error("Incompatible return type of dispatch method. Expected " + this.getNameOfTypes(jvmOperation.getReturnType()) + " but was " + this.canonicalName(functionReturnType), function, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__RETURN_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
                }
                if (commonVisibility == null) {
                    this.addVisibilityError(dispatchOperations, "All local dispatch functions must have the same visibility.", "dispatch_fuctions_with_different_visibility");
                }
                for (final List paramTypes : signatures.keySet()) {
                    Collection ops = signatures.get((Object)paramTypes);
                    if (ops.size() <= 1 || !Iterables.any((Iterable)ops, (Predicate)new Predicate<JvmOperation>(){

                        public boolean apply(JvmOperation input) {
                            return !Xtend2JavaValidator.this.getParamTypes(input, false).equals(paramTypes);
                        }
                    })) continue;
                    for (JvmOperation jvmOperation : ops) {
                        XtendFunction function = this.associations.getXtendFunction(jvmOperation);
                        this.error("Duplicate dispatch function. Primitives cannot overload their wrapper types in dispatch functions.", function, null, "org.eclipse.xtext.xtend2.validation.IssueCodes.duplicate_method", new String[0]);
                    }
                }
            }
        }
    }

    protected void addVisibilityError(Iterable<JvmOperation> operations, String message, String ISSUE_ID) {
        for (JvmOperation jvmOperation : operations) {
            XtendFunction function = this.associations.getXtendFunction(jvmOperation);
            if (function == null) continue;
            EAttribute feature = function.eIsSet((EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__VISIBILITY) ? Xtend2Package.Literals.XTEND_FUNCTION__VISIBILITY : Xtend2Package.Literals.XTEND_FUNCTION__DISPATCH;
            this.error(message, function, (EStructuralFeature)feature, -1, ISSUE_ID, new String[0]);
        }
    }

    protected List<JvmType> getParamTypes(JvmOperation jvmOperation, boolean wrapPrimitives) {
        ArrayList types = Lists.newArrayList();
        for (JvmFormalParameter p : jvmOperation.getParameters()) {
            JvmTypeReference reference = wrapPrimitives ? this.primitives.asWrapperTypeIfPrimitive(p.getParameterType()) : p.getParameterType();
            types.add(reference.getType());
        }
        return types;
    }

    @Check
    public void checkNoReturnsInCreateExtensions(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        ArrayList found = Lists.newArrayList();
        this.collectReturnExpressions((EObject)func.getCreateExtensionInfo().getCreateExpression(), found);
        for (XReturnExpression xReturnExpression : found) {
            this.error("Return is not allowed in creation expression", (EObject)xReturnExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
        found.clear();
        this.collectReturnExpressions((EObject)func.getExpression(), found);
        for (XReturnExpression ret : found) {
            if (ret.getExpression() == null) continue;
            this.error("Return with expression is not allowed within an initializer of a create function.", (EObject)ret, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
    }

    @Check
    public void checkCreateFunctionIsNotTypeVoid(XtendFunction func) {
        if (func.getCreateExtensionInfo() == null) {
            return;
        }
        JvmOperation operation = this.associations.getDirectlyInferredOperation(func);
        if (func.getReturnType() == null) {
            if (this.getTypeRefs().is(operation.getReturnType(), Void.TYPE)) {
                this.error("void is an invalid type for the create function " + func.getName(), func, (EStructuralFeature)Xtend2Package.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        } else if (this.getTypeRefs().is(func.getReturnType(), Void.TYPE)) {
            if (func.getReturnType() != null) {
                this.error("Create function " + func.getName() + " may not declare return type void.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error("The inherited return type void of " + func.getName() + " is invalid for create functions.", (EObject)func.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    public void checkInnerExpressions(XBlockExpression block) {
        if (block instanceof RichString) {
            return;
        }
        super.checkInnerExpressions(block);
    }

    protected void collectReturnExpressions(EObject expr, List<XReturnExpression> found) {
        if (expr instanceof XReturnExpression) {
            found.add((XReturnExpression)expr);
        } else if (expr instanceof XClosure) {
            return;
        }
        for (EObject child : expr.eContents()) {
            this.collectReturnExpressions(child, found);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Check
    public void checkImports(XtendFile file) {
        imports = Maps.newHashMap();
        staticImports = Maps.newHashMap();
        importedNames = Maps.newHashMap();
        for (XtendImport imp : file.getImports()) {
            if (imp.getImportedNamespace() != null) {
                this.warning("The use of wildcard imports is deprecated.", imp, null, "org.eclipse.xtext.xtend2.validation.IssueCodes.import_wildcard_deprecated", new String[0]);
                continue;
            }
            importedType = imp.getImportedType();
            if (importedType == null || importedType.eIsProxy()) continue;
            v0 = map = imp.isStatic() != false ? staticImports : imports;
            if (map.containsKey(importedType)) {
                this.warning("Duplicate import of '" + importedType.getSimpleName() + "'.", imp, null, "org.eclipse.xtext.xtend2.validation.IssueCodes.import_duplicate", new String[0]);
                continue;
            }
            map.put(importedType, imp);
            if (imp.isStatic()) continue;
            currentType = importedType;
            currentSuffix = currentType.getSimpleName();
            importedNames.put(currentSuffix, importedType);
            while (currentType.eContainer() instanceof JvmType) {
                currentType = (JvmType)currentType.eContainer();
                currentSuffix = String.valueOf(currentType.getSimpleName()) + "$" + currentSuffix;
                importedNames.put(currentSuffix, importedType);
            }
        }
        node = NodeModelUtils.findActualNodeFor((EObject)file.getXtendClass());
        block2: for (INode n : node.getAsTreeIterable()) {
            if (!(n.getGrammarElement() instanceof CrossReference) || !((classifier = ((CrossReference)n.getGrammarElement()).getType().getClassifier()) instanceof EClass) || !TypesPackage.Literals.JVM_TYPE.isSuperTypeOf((EClass)classifier) && !TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf((EClass)classifier)) continue;
            simpleName = n.getText().trim();
            if (simpleName.endsWith("::")) {
                simpleName = simpleName.substring(0, simpleName.length() - 2);
            }
            if (!importedNames.containsKey(simpleName)) ** GOTO lbl43
            type = (JvmType)importedNames.remove(simpleName);
            imports.remove(type);
            continue;
lbl-1000:
            // 1 sources

            {
                if (!importedNames.containsKey(simpleName = simpleName.substring(0, simpleName.lastIndexOf(36)))) continue;
                imports.remove(importedNames.remove(simpleName));
                continue block2;
lbl43:
                // 2 sources

                ** while (simpleName.contains((CharSequence)"$"))
            }
lbl44:
            // 1 sources

        }
        for (XtendImport imp : imports.values()) {
            this.warning("The import '" + imp.getImportedTypeName() + "' is never used.", imp, null, "org.eclipse.xtext.xtend2.validation.IssueCodes.import_unsued", new String[0]);
        }
    }

    protected class Signature {
        private final JvmOperation operation;
        private List<JvmType> erasureParameterTypes;

        protected Signature(JvmOperation operation) {
            this.operation = operation;
            if (operation != null) {
                this.erasureParameterTypes = Lists.newArrayListWithCapacity((int)operation.getParameters().size());
                for (JvmFormalParameter parameter : operation.getParameters()) {
                    List rawTypes = Xtend2JavaValidator.this.rawTypeHelper.getAllRawTypes(parameter.getParameterType(), operation.eResource());
                    if (rawTypes.isEmpty()) {
                        this.erasureParameterTypes.add(null);
                        continue;
                    }
                    this.erasureParameterTypes.add((JvmType)rawTypes.get(0));
                }
            } else {
                this.erasureParameterTypes = Collections.emptyList();
            }
        }

        protected String getName() {
            if (this.operation == null) {
                return "null";
            }
            return this.operation.getSimpleName();
        }

        protected Object getErasureKey() {
            return Tuples.create((Object)this.getName(), this.erasureParameterTypes);
        }
    }
}

