/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.actions;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.xtext.ui.graph.RailroadSelectionProvider;
import org.eclipse.xtext.xtext.ui.graph.RailroadView;
import org.eclipse.xtext.xtext.ui.graph.RailroadViewPreferences;
import org.eclipse.xtext.xtext.ui.graph.figures.IEObjectReferer;
import org.eclipse.xtext.xtext.ui.graph.figures.ISelectable;

@Singleton
public class RailroadSelectionLinker
implements IPropertyChangeListener {
    private static final String XTEXT_LANGUAGE_NAME = "org.eclipse.xtext.Xtext";
    @Inject
    private IURIEditorOpener uriEditorOpener;
    @Inject
    private RailroadView view;
    private XtextEditor currentEditor;
    private ISelectable currentSelectedNode;
    @Inject
    private RailroadViewPreferences preferences;
    private ISelectionChangedListener diagramSelectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (RailroadSelectionLinker.this.view.getControl().isFocusControl()) {
                RailroadSelectionLinker.this.diagramSelectionChanged(event);
            }
        }
    };
    private ISelectionChangedListener textSelectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (RailroadSelectionLinker.this.preferences.isLinkWithEditor() && RailroadSelectionLinker.this.view.getSite().getPage().getActivePart() != RailroadSelectionLinker.this.view) {
                RailroadSelectionLinker.this.textSelectionChanged(event);
            }
        }
    };

    public void activate() {
        this.view.getSite().getSelectionProvider().addSelectionChangedListener(this.diagramSelectionChangeListener);
        this.preferences.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.preferences.isLinkWithEditor()) {
            this.selectGrammarText(this.currentSelectedNode, false);
        }
    }

    public void deactivate() {
        this.view.getSite().getSelectionProvider().removeSelectionChangedListener(this.diagramSelectionChangeListener);
        if (this.currentEditor != null) {
            this.removeTextSelectionListener(this.currentEditor);
        }
        this.preferences.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void selectFigure(IFigure selectedFigure) {
        while (selectedFigure != null && !(selectedFigure instanceof IEObjectReferer)) {
            selectedFigure = selectedFigure.getParent();
        }
        if (selectedFigure != null) {
            if (this.currentSelectedNode != null) {
                this.currentSelectedNode.setSelected(false);
            }
            if (selectedFigure instanceof ISelectable) {
                ((ISelectable)selectedFigure).setSelected(true);
                this.currentSelectedNode = (ISelectable)selectedFigure;
            } else {
                this.currentSelectedNode = null;
            }
        }
    }

    protected void selectGrammarText(IFigure selectedFigure, boolean isActivateEditor) {
        IEObjectReferer element;
        URI grammarElementURI;
        if (selectedFigure != null && (grammarElementURI = (element = (IEObjectReferer)selectedFigure).getEObjectURI()) != null) {
            final boolean isSelectElement = selectedFigure instanceof ISelectable;
            if (isActivateEditor && isSelectElement) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        RailroadSelectionLinker.this.uriEditorOpener.open(grammarElementURI, isSelectElement);
                    }
                });
            } else {
                this.uriEditorOpener.open(grammarElementURI, isSelectElement);
                this.view.getSite().getPage().activate((IWorkbenchPart)this.view);
            }
        }
    }

    public void diagramSelectionChanged(SelectionChangedEvent event) {
        Object selectedElement;
        IStructuredSelection structuredSelection;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedElement = structuredSelection.getFirstElement()) instanceof IFigure) {
            IFigure selectedFigure = (IFigure)selectedElement;
            this.selectFigure(selectedFigure);
            boolean isDoubleClick = event instanceof RailroadSelectionProvider.DoubleClickEvent;
            if (!(this.currentEditor != null && this.currentEditor.getInternalSourceViewer().getTextWidget().isFocusControl() || !isDoubleClick && !this.preferences.isLinkWithEditor())) {
                this.selectGrammarText(selectedFigure, isDoubleClick);
            }
        }
    }

    public void textSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty()) {
            ITextSelection textSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            ISelectable figureToBeSelected = this.findFigureForTextOffset(this.view.getContents(), offset, null);
            if (figureToBeSelected != null) {
                this.selectFigure(figureToBeSelected);
                this.view.reveal(figureToBeSelected);
            }
        }
    }

    protected ISelectable findFigureForTextOffset(IFigure figure, int offset, ISelectable currentBestFigure) {
        Region textRegion;
        if (figure == null) {
            return null;
        }
        if (figure instanceof ISelectable && (textRegion = ((ISelectable)figure).getTextRegion()) != null && textRegion.getOffset() <= offset && textRegion.getOffset() + textRegion.getLength() >= offset && (currentBestFigure == null || currentBestFigure.getTextRegion().getLength() > textRegion.getLength())) {
            currentBestFigure = (ISelectable)figure;
        }
        for (Object child : figure.getChildren()) {
            if (!(child instanceof IFigure)) continue;
            currentBestFigure = this.findFigureForTextOffset((IFigure)child, offset, currentBestFigure);
        }
        return currentBestFigure;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("linkWithEditor") && event.getNewValue() == Boolean.TRUE && this.currentSelectedNode != null) {
            this.selectGrammarText(this.currentSelectedNode, true);
        }
    }

    public void setXtextEditor(XtextEditor xtextEditor) {
        if (this.currentEditor != null) {
            this.removeTextSelectionListener(this.currentEditor);
        }
        if (XTEXT_LANGUAGE_NAME.equals(xtextEditor.getLanguageName())) {
            this.currentEditor = xtextEditor;
            ISelectionProvider selectionProvider = xtextEditor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.textSelectionChangeListener);
            } else {
                selectionProvider.addSelectionChangedListener(this.textSelectionChangeListener);
            }
        }
    }

    protected void removeTextSelectionListener(XtextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.textSelectionChangeListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.textSelectionChangeListener);
            }
        }
    }
}

