/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.CfgAdapter;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.ISerializerPDAProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Cfg;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.FollowerFunctionImpl;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaGraphFormatter;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.PdaUtil;
import org.eclipse.xtext.util.formallang.Production;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SerializerPDAProvider
implements ISerializerPDAProvider {
    protected Map<Pair<EObject, EClass>, Pda<? extends ISerializerPDAProvider.ISerState, RuleCall>> cache = Maps.newHashMap();

    protected Pda<? extends ISerializerPDAProvider.ISerState, RuleCall> createPDA(EObject context, EClass type) {
        SerializerCfg cfg = new SerializerCfg(context);
        SerializerFollowerFunction ff = new SerializerFollowerFunction((Production<AbstractElement, AbstractElement>)cfg, context, type);
        Pda pda = new PdaUtil().create((Cfg)cfg, (FollowerFunction)ff, (PdaFactory)new SerializerPDAFactory());
        new NfaUtil().removeOrphans((Nfa)pda);
        return pda;
    }

    @Override
    public Pda<? extends ISerializerPDAProvider.ISerState, RuleCall> getPDA(EObject context, EClass type) {
        Pair key = Tuples.create((Object)context, (Object)type);
        Pda<? extends ISerializerPDAProvider.ISerState, RuleCall> result = this.cache.get(key);
        if (result == null) {
            result = this.createPDA(context, type);
            this.cache.put((Pair<EObject, EClass>)key, result);
        }
        return result;
    }

    protected static class SerializerCfg
    extends CfgAdapter {
        protected EObject context;

        public SerializerCfg(EObject context) {
            super(GrammarUtil.getGrammar(context));
            this.context = context;
        }

        public AbstractElement getRoot() {
            if (this.context instanceof AbstractRule) {
                return ((AbstractRule)this.context).getAlternatives();
            }
            if (this.context instanceof Action) {
                return GrammarUtil.containingRule(this.context).getAlternatives();
            }
            return super.getRoot();
        }

        public AbstractElement getCall(AbstractElement ele) {
            if (ele instanceof RuleCall && !GrammarUtil.isAssigned(ele) && ((RuleCall)ele).getRule().getType().getClassifier() instanceof EClass) {
                return ((RuleCall)ele).getRule().getAlternatives();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerFollowerFunction
    extends FollowerFunctionImpl<AbstractElement, AbstractElement> {
        protected Action actionCtx;
        protected AbstractRule ruleCtx;
        protected EClass type;

        public SerializerFollowerFunction(Production<AbstractElement, AbstractElement> production, EObject context, EClass type) {
            super(production);
            this.actionCtx = context instanceof Action ? (Action)context : null;
            this.ruleCtx = context instanceof AbstractRule ? (AbstractRule)context : null;
            this.type = type;
        }

        public Iterable<AbstractElement> getFollowers(AbstractElement element) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (AbstractElement ele : super.getFollowers((Object)element)) {
                if (ele == null) {
                    if (this.actionCtx != null && GrammarUtil.containingRule(this.actionCtx) == GrammarUtil.containingRule(element)) continue;
                    result.add(null);
                    continue;
                }
                if (this.actionCtx == ele) {
                    result.add(null);
                    continue;
                }
                if (ele instanceof Action) {
                    Action a = (Action)ele;
                    if (this.type == null || a.getFeature() != null || a.getType().getClassifier() != this.type) continue;
                    result.add(ele);
                    continue;
                }
                if (this.type == null && GrammarUtil.isAssigned(ele)) continue;
                result.add(ele);
            }
            return result;
        }

        public Iterable<AbstractElement> getStarts(AbstractElement root) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Action act : GrammarUtil.containedActions(root)) {
                if (this.type == null || act.getFeature() == null || act.getType().getClassifier() != this.type) continue;
                result.add(act);
            }
            for (AbstractElement ele : super.getStarts((Object)root)) {
                if (ele == null) {
                    if (this.actionCtx != null && GrammarUtil.containingRule(this.actionCtx) == GrammarUtil.containingRule(root)) continue;
                    result.add(null);
                    continue;
                }
                if (this.actionCtx == ele) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele) || this.typeMatches(ele, Sets.newHashSet()) == Boolean.FALSE) continue;
                result.add(ele);
            }
            return result;
        }

        protected Boolean typeMatches(AbstractElement ele, Set<AbstractElement> visited) {
            if (!visited.add(ele)) {
                return null;
            }
            if (ele instanceof Action) {
                if (this.type != null && ((Action)ele).getType().getClassifier() == this.type) {
                    return true;
                }
                return false;
            }
            if (GrammarUtil.isAssigned(ele)) {
                if (this.type != null && GrammarUtil.containingRule(ele).getType().getClassifier() == this.type) {
                    return true;
                }
                return false;
            }
            if (GrammarUtil.isEObjectRuleCall(ele)) {
                for (Action act : GrammarUtil.containedActions(((RuleCall)ele).getRule().getAlternatives())) {
                    if (act.getFeature() == null || act.getType().getClassifier() != this.type) continue;
                    return true;
                }
            }
            boolean allFalse = true;
            for (AbstractElement f : GrammarUtil.isEObjectRuleCall(ele) && !GrammarUtil.isAssigned(ele) ? super.getStarts((Object)((RuleCall)ele).getRule().getAlternatives()) : super.getFollowers((Object)ele)) {
                if (f != null) {
                    Boolean r = this.typeMatches(f, visited);
                    if (r == Boolean.TRUE) {
                        return true;
                    }
                    if (r != null) continue;
                    allFalse = false;
                    continue;
                }
                if (this.type != null) continue;
                allFalse = false;
            }
            return allFalse ? Boolean.valueOf(false) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerPDA
    implements Pda<SerializerPDAState, RuleCall> {
        protected SerializerPDAState start;
        protected SerializerPDAState stop;

        public SerializerPDA(SerializerPDAState start, SerializerPDAState stop) {
            this.start = start;
            this.stop = stop;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return new NfaUtil().equalsIgnoreOrder((Nfa)this, (Nfa)((SerializerPDA)obj));
        }

        public Iterable<SerializerPDAState> getFollowers(SerializerPDAState state) {
            return state.followers;
        }

        public RuleCall getPop(SerializerPDAState state) {
            return state.type == ISerializerPDAProvider.SerStateType.POP ? (RuleCall)state.grammarElement : null;
        }

        public RuleCall getPush(SerializerPDAState state) {
            return state.type == ISerializerPDAProvider.SerStateType.PUSH ? (RuleCall)state.grammarElement : null;
        }

        public SerializerPDAState getStart() {
            return this.start;
        }

        public SerializerPDAState getStop() {
            return this.stop;
        }

        public int hashCode() {
            int r = 0;
            if (this.start != null && this.start.followers != null) {
                for (SerializerPDAState s : this.start.followers) {
                    if (s == null) continue;
                    r += s.hashCode();
                }
            }
            return r;
        }

        public String toString() {
            return new NfaGraphFormatter().format((Nfa)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerPDAFactory
    implements PdaFactory<SerializerPDA, SerializerPDAState, RuleCall, AbstractElement> {
        protected SerializerPDAFactory() {
        }

        public SerializerPDA create(AbstractElement start, AbstractElement stop) {
            SerializerPDAState s1 = new SerializerPDAState(start, ISerializerPDAProvider.SerStateType.START);
            SerializerPDAState s2 = new SerializerPDAState(stop, ISerializerPDAProvider.SerStateType.STOP);
            return new SerializerPDA(s1, s2);
        }

        public SerializerPDAState createPop(SerializerPDA pda, AbstractElement token) {
            return new SerializerPDAState(token, ISerializerPDAProvider.SerStateType.POP);
        }

        public SerializerPDAState createPush(SerializerPDA pda, AbstractElement token) {
            return new SerializerPDAState(token, ISerializerPDAProvider.SerStateType.PUSH);
        }

        public SerializerPDAState createState(SerializerPDA nfa, AbstractElement token) {
            return new SerializerPDAState(token, ISerializerPDAProvider.SerStateType.ELEMENT);
        }

        public void setFollowers(SerializerPDA nfa, SerializerPDAState owner, Iterable<SerializerPDAState> followers) {
            owner.followers = Lists.newArrayList(followers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerPDAState
    implements ISerializerPDAProvider.ISerState {
        protected List<SerializerPDAState> followers = Collections.emptyList();
        protected AbstractElement grammarElement;
        protected ISerializerPDAProvider.SerStateType type;

        public SerializerPDAState(AbstractElement grammarElement, ISerializerPDAProvider.SerStateType type) {
            this.type = type;
            this.grammarElement = grammarElement;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SerializerPDAState s = (SerializerPDAState)obj;
            return this.grammarElement == s.grammarElement && this.type == s.type;
        }

        public List<SerializerPDAState> getFollowers() {
            return this.followers;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.grammarElement;
        }

        @Override
        public ISerializerPDAProvider.SerStateType getType() {
            return this.type;
        }

        public int hashCode() {
            return (this.grammarElement != null ? this.grammarElement.hashCode() : 1) * this.type.hashCode();
        }

        public String toString() {
            GrammarElementTitleSwitch fmt = new GrammarElementTitleSwitch().hideCardinality().showQualified();
            switch (this.type) {
                case ELEMENT: {
                    return fmt.apply(this.grammarElement);
                }
                case POP: {
                    return "<<" + fmt.apply(this.grammarElement);
                }
                case PUSH: {
                    return ">>" + fmt.apply(this.grammarElement);
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return "";
        }
    }
}

