/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.ui.util.IProjectFactoryContributor;
import org.eclipse.xtext.ui.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFactory {
    private static final Logger logger = Logger.getLogger(ProjectFactory.class);
    @Inject(optional=true)
    protected IWorkbench workbench;
    @Inject
    protected IWorkspace workspace;
    protected String projectName;
    protected IPath location;
    protected List<String> folders;
    protected List<IProject> referencedProjects;
    protected List<String> projectNatures;
    protected List<String> builderIds;
    protected List<IWorkingSet> workingSets;
    private List<IProjectFactoryContributor> contributors;

    public ProjectFactory addBuilderIds(String ... builderIds) {
        if (this.builderIds == null) {
            this.builderIds = Lists.newArrayList();
        }
        this.builderIds.addAll(Arrays.asList(builderIds));
        return this;
    }

    public ProjectFactory addProjectNatures(String ... projectNatures) {
        if (this.projectNatures == null) {
            this.projectNatures = Lists.newArrayList();
        }
        this.projectNatures.addAll(Arrays.asList(projectNatures));
        return this;
    }

    public ProjectFactory setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public ProjectFactory setLocation(IPath location) {
        this.location = location;
        return this;
    }

    public ProjectFactory addFolders(List<String> folders) {
        if (this.folders == null) {
            this.folders = Lists.newArrayList();
        }
        this.folders.addAll(folders);
        return this;
    }

    public ProjectFactory addReferencedProjects(List<IProject> referencedProjects) {
        if (this.referencedProjects == null) {
            this.referencedProjects = Lists.newArrayList();
        }
        this.referencedProjects.addAll(referencedProjects);
        return this;
    }

    public ProjectFactory addWorkingSets(List<IWorkingSet> workingSets) {
        if (this.workingSets == null) {
            this.workingSets = Lists.newArrayList();
        }
        this.workingSets.addAll(workingSets);
        return this;
    }

    public void addContributor(IProjectFactoryContributor projectFactoryContributor) {
        if (this.contributors == null) {
            this.contributors = Lists.newArrayList();
        }
        this.contributors.add(projectFactoryContributor);
    }

    public IProject createProject(IProgressMonitor monitor, Shell shell) {
        IProject project = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IProjectDescription description = this.createProjectDescription();
            subMonitor.subTask(String.valueOf(Messages.ProjectFactory_0) + description.getName());
            project = this.workspace.getRoot().getProject(this.projectName);
            if (!this.deleteExistingProject(project, shell, subMonitor)) {
                return null;
            }
            try {
                project.create(description, (IProgressMonitor)subMonitor.newChild(1));
                project.open((IProgressMonitor)subMonitor.newChild(1));
                project.setDescription(description, (IProgressMonitor)subMonitor.newChild(1));
                this.createFolders(project, subMonitor, shell);
                this.enhanceProject(project, subMonitor, shell);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        finally {
            subMonitor.done();
        }
        return project;
    }

    protected void createFolders(IProject project, SubMonitor subMonitor, Shell shell) throws CoreException {
        if (this.folders != null) {
            for (String folderName : this.folders) {
                IFolder folder = project.getFolder(folderName);
                if (folder.exists()) continue;
                folder.create(false, true, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    protected void enhanceProject(final IProject project, final SubMonitor subMonitor, Shell shell) throws CoreException {
        if (this.workbench != null && this.workingSets != null) {
            this.workbench.getWorkingSetManager().addToWorkingSets((IAdaptable)project, this.workingSets.toArray(new IWorkingSet[this.workingSets.size()]));
        }
        if (this.contributors != null) {
            IProjectFactoryContributor.IFileCreator fileCreator = new IProjectFactoryContributor.IFileCreator(){

                public IFile writeToFile(CharSequence chars, String fileName) {
                    return ProjectFactory.this.writeToFile(chars, fileName, project, (IProgressMonitor)subMonitor);
                }
            };
            for (IProjectFactoryContributor contributor : this.contributors) {
                contributor.contributeFiles(project, fileCreator);
            }
        }
    }

    protected boolean deleteExistingProject(IProject project, final Shell theShell, SubMonitor subMonitor) throws CoreException {
        if (project.exists()) {
            final boolean[] result = new boolean[1];
            if (this.workbench != null && theShell != null) {
                this.workbench.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        result[0] = MessageDialog.openQuestion((Shell)theShell, (String)(String.valueOf(Messages.ProjectFactory_1) + ProjectFactory.this.projectName), (String)(String.valueOf(Messages.ProjectFactory_2) + ProjectFactory.this.projectName + Messages.ProjectFactory_3));
                    }
                });
            } else {
                result[0] = true;
            }
            if (result[0]) {
                project.delete(true, true, (IProgressMonitor)subMonitor.newChild(1));
            } else {
                return false;
            }
        }
        return true;
    }

    protected IProjectDescription createProjectDescription() {
        IProjectDescription projectDescription = this.workspace.newProjectDescription(this.projectName);
        if (this.location != null && !Platform.getLocation().equals((Object)this.location.removeLastSegments(1))) {
            projectDescription.setLocation(this.location);
        }
        if (this.referencedProjects != null && this.referencedProjects.size() != 0) {
            projectDescription.setReferencedProjects(this.referencedProjects.toArray(new IProject[this.referencedProjects.size()]));
        }
        if (this.projectNatures != null) {
            projectDescription.setNatureIds(this.projectNatures.toArray(new String[this.projectNatures.size()]));
        }
        if (this.builderIds != null) {
            this.setBuilder(projectDescription, this.builderIds.toArray(new String[this.builderIds.size()]));
        }
        return projectDescription;
    }

    protected void setBuilder(IProjectDescription projectDescription, String[] builders) {
        ArrayList commands = Lists.newArrayList();
        int i = 0;
        while (i < builders.length) {
            ICommand command = projectDescription.newCommand();
            command.setBuilderName(builders[i]);
            commands.add(command);
            ++i;
        }
        projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
    }

    protected IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        this.createRecursive(file.getParent());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1);
        try {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
                if (file.exists()) {
                    file.setContents((InputStream)stream, true, true, (IProgressMonitor)subMonitor.newChild(1));
                } else {
                    file.create((InputStream)stream, true, (IProgressMonitor)subMonitor.newChild(1));
                }
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
        return file;
    }

    protected IFile writeToFile(CharSequence chrSeq, String fileName, IProject project, IProgressMonitor progrMonitor) {
        return this.createFile(fileName, (IContainer)project, chrSeq.toString(), progrMonitor);
    }

    protected void createRecursive(IContainer resource) {
        if (!resource.exists()) {
            if (!resource.getParent().exists()) {
                this.createRecursive(resource.getParent());
            }
            if (resource instanceof IFolder) {
                try {
                    ((IFolder)resource).create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

