/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.documentation.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MultiLineCommentDocumentationProvider
implements IEObjectDocumentationProvider,
IEObjectDocumentationProviderExtension {
    public static final String RULE = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName";
    public static final String START_TAG = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.startTag";
    public static final String END_TAG = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.endTag";
    public static final String LINE_PREFIX = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePrefix";
    public static final String LINE_POSTFIX = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePostfix";
    public static final String WHITESPACE = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.whitespace";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName")
    protected String ruleName = "ML_COMMENT";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.startTag")
    protected String startTag = "/\\*\\*?";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.endTag")
    protected String endTag = "\\*/";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePrefix")
    protected String linePrefix = "\\** ?";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePostfix")
    protected String linePostfix = "\\**";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.whitespace")
    protected String whitespace = "( |\\t)*";

    protected String findComment(EObject o) {
        String returnValue = null;
        List<INode> documentationNodes = this.getDocumentationNodes(o);
        if (!documentationNodes.isEmpty()) {
            return documentationNodes.get(0).getText();
        }
        return returnValue;
    }

    @Override
    @NonNull
    public List<INode> getDocumentationNodes(@NonNull EObject object) {
        ICompositeNode node = NodeModelUtils.getNode(object);
        List<INode> result = Collections.emptyList();
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                String comment;
                if (!leafNode.isHidden()) break;
                if (!(leafNode.getGrammarElement() instanceof TerminalRule) || !this.ruleName.equalsIgnoreCase(((TerminalRule)leafNode.getGrammarElement()).getName()) || !(comment = leafNode.getText()).matches("(?s)" + this.startTag + ".*")) continue;
                result = Collections.singletonList(leafNode);
            }
        }
        return result;
    }

    @Override
    public String getDocumentation(EObject o) {
        String returnValue = this.findComment(o);
        if (returnValue != null) {
            returnValue = returnValue.replaceAll("\\A" + this.startTag, "");
            returnValue = returnValue.replaceAll(String.valueOf(this.endTag) + "\\z", "");
            returnValue = returnValue.replaceAll("(?m)^" + this.whitespace + this.linePrefix, "");
            returnValue = returnValue.replaceAll("(?m)" + this.whitespace + this.linePostfix + this.whitespace + "$", "");
            return returnValue.trim();
        }
        return null;
    }
}

