/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.typesystem.computation.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidateWithTypeParameter;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureLinkingCandidate
extends AbstractLinkingCandidateWithTypeParameter<IFeatureLinkingCandidate>
implements IFeatureLinkingCandidate {
    public FeatureLinkingCandidate(XAbstractFeatureCall featureCall, IEObjectDescription description, AbstractTypeComputationState state) {
        super(featureCall, description, state);
    }

    protected JvmTypeReference getReceiverType() {
        JvmTypeReference receiverType = null;
        if (this.getDescription() instanceof BucketedEObjectDescription) {
            receiverType = ((BucketedEObjectDescription)this.getDescription()).getReceiverType();
        }
        return receiverType;
    }

    @Override
    public int compareTo(IFeatureLinkingCandidate right) {
        int result = super.compareTo(right);
        if (result == 0) {
            return result;
        }
        return result;
    }

    @Override
    protected int compareByArityWith(IFeatureLinkingCandidate right) {
        int result = super.compareByArityWith(right);
        if (result == 0) {
            result = this.favorInstanceOverExtensions(right);
            if (result != 0) {
                return result;
            }
            if (right.getDeclaredParameters().size() > this.getDeclaredParameters().size()) {
                return 1;
            }
        }
        return result;
    }

    private int favorInstanceOverExtensions(IFeatureLinkingCandidate right) {
        if (!this.isStaticOrExtension(this) && this.isStaticOrExtension(right)) {
            return -1;
        }
        if (this.isStaticOrExtension(this) == this.isStaticOrExtension(right)) {
            return 0;
        }
        return 1;
    }

    protected boolean isStaticOrExtension(IFeatureLinkingCandidate candidate) {
        return candidate.isStatic() || candidate.isExtension();
    }

    @Override
    public boolean isExtension() {
        IEObjectDescription description = this.getDescription();
        if (description instanceof BucketedEObjectDescription) {
            return ((BucketedEObjectDescription)description).isExtensionDescription();
        }
        return false;
    }

    @Override
    public boolean isStatic() {
        IEObjectDescription description = this.getDescription();
        if (description instanceof BucketedEObjectDescription) {
            return ((BucketedEObjectDescription)description).isStaticDescription();
        }
        return false;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).getMemberCallArguments();
        }
        if (featureCall instanceof XFeatureCall) {
            return ((XFeatureCall)featureCall).getFeatureCallArguments();
        }
        return featureCall.getExplicitArguments();
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<JvmTypeReference> getTypeArguments() {
        return this.getFeatureCall().getTypeArguments();
    }

    @Override
    protected StackedResolvedTypes resolveArgumentType(XExpression argument, JvmTypeReference declaredType, AbstractTypeComputationState argumentState) {
        if (argument == this.getReceiver()) {
            JvmTypeReference receiverType = this.getReceiverType();
            StackedResolvedTypes resolvedTypes = new StackedResolvedTypes(this.getState().getResolvedTypes());
            resolvedTypes.acceptType(argument, null, receiverType, ConformanceHint.UNCHECKED, false);
            if (declaredType != null) {
                this.resolveAgainstActualType(declaredType, receiverType);
            }
            return resolvedTypes;
        }
        return super.resolveArgumentType(argument, declaredType, argumentState);
    }

    @Override
    protected Map<JvmTypeParameter, JvmTypeReference> getDeclaratorParameterMapping() {
        Map<JvmTypeParameter, JvmTypeReference> result;
        if (this.getDescription() instanceof BucketedEObjectDescription && (result = ((BucketedEObjectDescription)this.getDescription()).getReceiverTypeParameterMapping()) != null) {
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<JvmTypeParameter, JvmTypeReference> getFeatureTypeParameterMapping() {
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmTypeParameterDeclarator) {
            EList<JvmTypeReference> typeArguments = this.getFeatureCall().getTypeArguments();
            EList typeParameters = ((JvmTypeParameterDeclarator)feature).getTypeParameters();
            if (!typeArguments.isEmpty()) {
                int max = Math.min(typeArguments.size(), typeParameters.size());
                HashMap result = Maps.newHashMapWithExpectedSize((int)max);
                int i = 0;
                while (i < max) {
                    result.put((JvmTypeParameter)typeParameters.get(i), (JvmTypeReference)typeArguments.get(i));
                    ++i;
                }
                return result;
            }
        }
        return super.getFeatureTypeParameterMapping();
    }

    @Override
    protected JvmTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        if (feature instanceof JvmConstructor) {
            return this.getState().getTypeReferences().getTypeForName(Void.TYPE, (Notifier)feature, new JvmTypeReference[0]);
        }
        return super.getDeclaredType(feature);
    }
}

