/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescription;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureDescriptionWithImplicitReceiver;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiverFeatureScope
extends AbstractSessionBasedScope
implements IVisibilityHelper {
    private final TypeBucket bucket;
    private final OperatorMapping operatorMapping;
    private final LightweightTypeReference receiverType;
    private final XExpression receiver;
    private final boolean implicit;
    private final JvmIdentifiableElement receiverFeature;
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping;

    protected ReceiverFeatureScope(IScope parent, IFeatureScopeSession session, XExpression receiver, LightweightTypeReference receiverType, boolean implicit, XAbstractFeatureCall featureCall, TypeBucket bucket, JvmIdentifiableElement receiverFeature, OperatorMapping operatorMapping) {
        super(parent, session, featureCall);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.implicit = implicit;
        this.bucket = bucket;
        this.receiverFeature = receiverFeature;
        this.operatorMapping = operatorMapping;
    }

    @Override
    public boolean isVisible(@NonNull JvmMember member) {
        return this.getSession().isVisible(member, this.receiverFeature);
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        final LinkedHashSet allFeatures = Sets.newLinkedHashSet();
        this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

            public void accept(String simpleName, int order) {
                for (JvmType jvmType : ReceiverFeatureScope.this.bucket.getTypes()) {
                    if (!(jvmType instanceof JvmDeclaredType)) continue;
                    Iterable features = ReceiverFeatureScope.this.findAllFeaturesByName(jvmType, simpleName, ReceiverFeatureScope.this.bucket.getResolvedFeaturesProvider());
                    Iterable filtered = order == 1 ? features : Iterables.filter(features, JvmOperation.class);
                    Iterables.addAll((Collection)allFeatures, (Iterable)filtered);
                }
            }
        });
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allDescriptions = Lists.newArrayListWithCapacity((int)allFeatures.size());
        for (JvmFeature feature : allFeatures) {
            if (feature.isStatic()) continue;
            allDescriptions.add(this.createDescription(name, feature, this.bucket));
        }
        return allDescriptions;
    }

    @Override
    protected Iterable<JvmFeature> findAllFeaturesByName(JvmType type, String simpleName, IResolvedFeatures.Provider resolvedFeaturesProvider) {
        IResolvedFeatures resolvedFeatures = resolvedFeaturesProvider.getResolvedFeatures(type).getParameterizedView(this.receiverType);
        return resolvedFeatures.getAllFeatures(simpleName);
    }

    protected IEObjectDescription createDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        EnumSet<ConformanceHint> conformanceHints = bucket.getHints();
        if (this.implicit) {
            return new InstanceFeatureDescriptionWithImplicitReceiver(name, feature, this.receiver, this.receiverType, this.getReceiverTypeParameterMapping(), conformanceHints, bucket.getId(), this.isVisible((JvmMember)feature));
        }
        return new InstanceFeatureDescription(name, feature, this.receiver, this.receiverType, this.getReceiverTypeParameterMapping(), conformanceHints, bucket.getId(), this.isVisible((JvmMember)feature));
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getReceiverTypeParameterMapping() {
        if (this.receiverTypeParameterMapping == null) {
            this.receiverTypeParameterMapping = Collections.emptyMap();
            if (this.receiverType != null) {
                this.receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.receiverType);
            }
        }
        return this.receiverTypeParameterMapping;
    }

    @Override
    protected void processFeatureNames(QualifiedName name, AbstractSessionBasedScope.NameAcceptor acceptor) {
        QualifiedName methodName = this.operatorMapping.getMethodName(name);
        if (methodName != null) {
            acceptor.accept(methodName.toString(), 2);
        } else {
            super.processFeatureNames(name, acceptor);
            this.processAsPropertyNames(name, acceptor);
        }
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        LinkedHashSet allFeatures = Sets.newLinkedHashSet();
        for (JvmType jvmType : this.bucket.getTypes()) {
            if (!(jvmType instanceof JvmDeclaredType)) continue;
            Iterable features = ((JvmDeclaredType)jvmType).getAllFeatures();
            Iterables.addAll((Collection)allFeatures, (Iterable)features);
        }
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)allFeatures.size());
        for (JvmFeature feature : allFeatures) {
            QualifiedName featureName = QualifiedName.create((String)feature.getSimpleName());
            arrayList.add(this.createDescription(featureName, feature, this.bucket));
            QualifiedName operator = this.operatorMapping.getOperator(featureName);
            if (operator == null) continue;
            arrayList.add(this.createDescription(operator, feature, this.bucket));
        }
        return arrayList;
    }
}

