/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;

@NonNullByDefault
public abstract class AbstractClosureTypeHelper {
    private final XClosure closure;
    private final ITypeComputationState state;
    private final CommonTypeComputationServices services;
    private final ITypeExpectation expectation;

    protected AbstractClosureTypeHelper(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        this.closure = closure;
        this.expectation = expectation;
        this.state = state;
        this.services = state.getReferenceOwner().getServices();
    }

    protected ITypeComputationState getState() {
        return this.state;
    }

    protected ITypeExpectation getExpectation() {
        return this.expectation;
    }

    protected XClosure getClosure() {
        return this.closure;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected abstract void computeTypes();

    @Nullable
    public abstract FunctionTypeReference getExpectedClosureType();

    @Nullable
    public abstract JvmOperation getOperation();

    protected void deferredBindTypeArgument(@Nullable LightweightTypeReference declared, LightweightTypeReference actual, final BoundTypeArgumentSource source) {
        if (declared != null) {
            ExpectationTypeParameterHintCollector collector = new ExpectationTypeParameterHintCollector(this.expectation.getReferenceOwner()){

                protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                    LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                    if (source == BoundTypeArgumentSource.INFERRED_CONSTRAINT) {
                        wrapped = this.getStricterConstraint(typeParameter, wrapped);
                    }
                    typeParameter.acceptHint(wrapped, source, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                }

                protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
                    return new UnboundParameterizedTypeReferencePreserver();
                }

                protected AbstractTypeReferencePairWalker.ArrayTypeReferenceTraverser createArrayTypeReferenceTraverser() {
                    return new UnboundArrayTypeReferencePreserver();
                }

                class UnboundArrayTypeReferencePreserver
                extends ExpectationTypeParameterHintCollector.DeferredArrayTypeReferenceTraverser {
                    UnboundArrayTypeReferencePreserver() {
                        super(this);
                    }

                    public void doVisitUnboundTypeReference(UnboundTypeReference reference, ArrayTypeReference declaration) {
                        if (reference.internalIsResolved() || this.getOwner().isResolved(reference.getHandle())) {
                            reference.tryResolve();
                            this.outerVisit(reference, declaration);
                        } else {
                            this.addHint(reference, declaration);
                        }
                    }
                }

                class UnboundParameterizedTypeReferencePreserver
                extends ExpectationTypeParameterHintCollector.DeferredParameterizedTypeReferenceTraverser {
                    UnboundParameterizedTypeReferencePreserver() {
                        super(this);
                    }

                    public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
                        if (reference.internalIsResolved() || this.getOwner().isResolved(reference.getHandle())) {
                            reference.tryResolve();
                            this.outerVisit(reference, declaration);
                        } else {
                            this.addHint(reference, declaration);
                        }
                    }
                }
            };
            collector.processPairedReferences(declared, actual);
        }
    }
}

