/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ActualTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterAwareTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@NonNullByDefault
public class FunctionTypes {
    @Inject
    private TypeReferences typeReferences;

    public List<JvmTypeParameter> collectAllTypeParameters(LightweightTypeReference closureType, JvmOperation operation) {
        List<JvmType> rawTypes = closureType.getRawTypes();
        if (rawTypes.size() == 1 && operation.getTypeParameters().isEmpty()) {
            JvmType type = rawTypes.get(0);
            if (type instanceof JvmTypeParameterDeclarator) {
                return ((JvmTypeParameterDeclarator)type).getTypeParameters();
            }
            return Collections.emptyList();
        }
        ArrayList allTypeParameters = Lists.newArrayList();
        for (JvmType rawType : rawTypes) {
            if (!(rawType instanceof JvmTypeParameterDeclarator)) continue;
            allTypeParameters.addAll(((JvmTypeParameterDeclarator)rawType).getTypeParameters());
        }
        allTypeParameters.addAll(operation.getTypeParameters());
        return allTypeParameters;
    }

    public Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> getFunctionTypeParameterMapping(LightweightTypeReference functionType, JvmOperation operation, ActualTypeArgumentCollector typeArgumentCollector, ITypeReferenceOwner owner) {
        JvmParameterizedTypeReference operationTypeDeclarator = this.typeReferences.createTypeRef((JvmType)operation.getDeclaringType(), new JvmTypeReference[0]);
        LightweightTypeReference lightweightTypeReference = new OwnedConverter(owner).toLightweightReference((JvmTypeReference)operationTypeDeclarator);
        typeArgumentCollector.populateTypeParameterMapping(lightweightTypeReference, functionType);
        Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> typeParameterMapping = typeArgumentCollector.rawGetTypeParameterMapping();
        return typeParameterMapping;
    }

    @Nullable
    public JvmOperation findImplementingOperation(LightweightTypeReference functionType) {
        JvmGenericType castedRawType;
        JvmType rawType;
        List<JvmType> rawTypes = functionType.getRawTypes();
        if (rawTypes.size() == 1 && (rawType = rawTypes.get(0)).eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && !(castedRawType = (JvmGenericType)rawType).isFinal()) {
            Iterable features = castedRawType.getAllFeatures();
            JvmOperation result = null;
            for (JvmFeature feature : features) {
                JvmOperation op;
                if (feature.eClass() != TypesPackage.Literals.JVM_OPERATION || !this.isValidFunction(op = (JvmOperation)feature)) continue;
                if (result == null) {
                    result = op;
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private boolean isValidFunction(JvmOperation op) {
        if (op.isAbstract()) {
            if (Object.class.getName().equals(op.getDeclaringType().getIdentifier())) {
                return false;
            }
            String name = op.getSimpleName();
            if (name.equals("toString") && op.getParameters().isEmpty()) {
                return false;
            }
            if (name.equals("equals") && op.getParameters().size() == 1) {
                return false;
            }
            return !name.equals("hashCode") || !op.getParameters().isEmpty();
        }
        return false;
    }

    public boolean isFunctionAndProcedureAvailable(ITypeReferenceOwner owner) {
        JvmType type = this.typeReferences.findDeclaredType(Procedures.Procedure1.class, (Notifier)owner.getContextResourceSet());
        if (type == null) {
            return false;
        }
        if (type instanceof JvmTypeParameterDeclarator) {
            return !((JvmTypeParameterDeclarator)type).getTypeParameters().isEmpty();
        }
        return false;
    }

    public FunctionTypeReference createRawFunctionTypeRef(ITypeReferenceOwner owner, EObject context, int parameterCount, boolean procedure) {
        String simpleClassName = String.valueOf(procedure ? "Procedure" : "Function") + Math.min(6, parameterCount);
        Class<?> loadFunctionClass = this.loadFunctionClass(simpleClassName, procedure);
        JvmType declaredType = this.typeReferences.findDeclaredType(loadFunctionClass, (Notifier)context);
        if (declaredType == null || !(declaredType instanceof JvmTypeParameterDeclarator)) {
            throw new IllegalStateException("Cannot load raw function type ref");
        }
        FunctionTypeReference result = new FunctionTypeReference(owner, declaredType);
        return result;
    }

    public FunctionTypeReference createFunctionTypeRef(ITypeReferenceOwner owner, LightweightTypeReference functionType, List<LightweightTypeReference> parameterTypes, @Nullable LightweightTypeReference returnType) {
        JvmType type = functionType.getType();
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        FunctionTypeReference result = new FunctionTypeReference(owner, type);
        if (functionType instanceof ParameterizedTypeReference) {
            for (LightweightTypeReference typeArgument : ((ParameterizedTypeReference)functionType).getTypeArguments()) {
                result.addTypeArgument(typeArgument.copyInto(owner));
            }
        }
        for (LightweightTypeReference parameterType : parameterTypes) {
            result.addParameterType(parameterType.copyInto(owner));
        }
        if (returnType != null) {
            result.setReturnType(returnType.copyInto(owner));
        }
        return result;
    }

    private Class<?> loadFunctionClass(String simpleFunctionName, boolean procedure) {
        try {
            if (!procedure) {
                return Functions.class.getClassLoader().loadClass(String.valueOf(Functions.class.getCanonicalName()) + "$" + simpleFunctionName);
            }
            return Procedures.class.getClassLoader().loadClass(String.valueOf(Procedures.class.getCanonicalName()) + "$" + simpleFunctionName);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public FunctionTypeKind getFunctionTypeKind(ParameterizedTypeReference typeReference) {
        JvmDeclaredType outerType;
        JvmType type = typeReference.getType();
        if (type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && (outerType = ((JvmGenericType)type).getDeclaringType()) != null) {
            if (Procedures.class.getName().equals(outerType.getIdentifier())) {
                return FunctionTypeKind.PROCEDURE;
            }
            if (Functions.class.getName().equals(outerType.getIdentifier())) {
                return FunctionTypeKind.FUNCTION;
            }
        }
        return FunctionTypeKind.NONE;
    }

    @Nullable
    protected FunctionTypeReference tryConvertToFunctionTypeReference(ParameterizedTypeReference typeReference, boolean rawType) {
        JvmOperation operation = this.findImplementingOperation(typeReference);
        if (operation == null) {
            return null;
        }
        OwnedConverter converter = new OwnedConverter(typeReference.getOwner());
        LightweightTypeReference declaredReturnType = converter.toLightweightReference(operation.getReturnType());
        if (rawType) {
            FunctionTypeReference result = this.createRawFunctionTypeRef(typeReference.getOwner(), (EObject)operation, operation.getParameters().size(), declaredReturnType.isPrimitiveVoid());
            TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(Collections.<JvmTypeParameter, LightweightMergedBoundTypeArgument>emptyMap(), typeReference.getOwner());
            for (JvmFormalParameter parameter : operation.getParameters()) {
                LightweightTypeReference lightweight = substitutor.substitute(converter.toLightweightReference(parameter.getParameterType()));
                LightweightTypeReference lowerBound = lightweight.getLowerBoundSubstitute();
                if (lowerBound instanceof AnyTypeReference) {
                    return null;
                }
                result.addParameterType(lowerBound);
            }
            result.setReturnType(substitutor.substitute(declaredReturnType));
            return result;
        }
        List<JvmTypeParameter> allTypeParameters = this.collectAllTypeParameters(typeReference, operation);
        UnboundTypeParameterAwareTypeArgumentCollector typeArgumentCollector = new UnboundTypeParameterAwareTypeArgumentCollector(allTypeParameters, BoundTypeArgumentSource.CONSTRAINT, typeReference.getOwner());
        Map<JvmTypeParameter, List<LightweightBoundTypeArgument>> typeParameterMapping = this.getFunctionTypeParameterMapping(typeReference, operation, typeArgumentCollector, typeReference.getOwner());
        LinkedHashMap mergedTypeParameterMapping = Maps.newLinkedHashMap();
        for (Map.Entry<JvmTypeParameter, List<LightweightBoundTypeArgument>> mapping : typeParameterMapping.entrySet()) {
            mergedTypeParameterMapping.put(mapping.getKey(), typeReference.getServices().getBoundTypeArgumentMerger().merge((Collection<LightweightBoundTypeArgument>)mapping.getValue(), typeReference.getOwner()));
        }
        UnboundTypeParameterPreservingSubstitutor substitutor = new UnboundTypeParameterPreservingSubstitutor(mergedTypeParameterMapping, typeReference.getOwner()){

            @Override
            @Nullable
            protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
                LightweightMergedBoundTypeArgument boundTypeArgument = this.getTypeParameterMapping().get(type);
                if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
                    LightweightTypeReference boundReference = boundTypeArgument.getTypeReference();
                    if (boundTypeArgument.getVariance() == VarianceInfo.OUT) {
                        WildcardTypeReference wildcard = new WildcardTypeReference(this.getOwner());
                        wildcard.addUpperBound(boundReference);
                        boundReference = wildcard;
                    }
                    return boundReference.accept(this, visiting);
                }
                return null;
            }
        };
        ArrayList parameterTypes = Lists.newArrayListWithCapacity((int)operation.getParameters().size());
        for (JvmFormalParameter parameter : operation.getParameters()) {
            LightweightTypeReference lightweight = substitutor.substitute(converter.toLightweightReference(parameter.getParameterType()));
            LightweightTypeReference lowerBound = lightweight.getLowerBoundSubstitute();
            if (lowerBound instanceof AnyTypeReference) {
                return null;
            }
            parameterTypes.add(lowerBound);
        }
        LightweightTypeReference returnType = substitutor.substitute(declaredReturnType);
        FunctionTypeReference result = this.createFunctionTypeRef(typeReference.getOwner(), typeReference, parameterTypes, returnType.getUpperBoundSubstitute());
        return result;
    }

    @Nullable
    public FunctionTypeReference getAsFunctionTypeReference(ParameterizedTypeReference typeReference) {
        FunctionTypeKind functionTypeKind = typeReference.getFunctionTypeKind();
        if (functionTypeKind == FunctionTypeKind.PROCEDURE) {
            return this.getAsProcedureOrNull(typeReference);
        }
        if (functionTypeKind == FunctionTypeKind.FUNCTION) {
            return this.getAsFunctionOrNull(typeReference);
        }
        return null;
    }

    @Nullable
    protected FunctionTypeReference getAsFunctionOrNull(ParameterizedTypeReference typeReference) {
        if (typeReference.isRawType()) {
            return null;
        }
        FunctionTypeReference functionType = new FunctionTypeReference(typeReference.getOwner(), typeReference.getType());
        List<LightweightTypeReference> allTypeArguments = typeReference.getTypeArguments();
        if (!this.tryAssignTypeArguments(allTypeArguments.subList(0, allTypeArguments.size() - 1), functionType)) {
            return null;
        }
        LightweightTypeReference lastTypeArgument = allTypeArguments.get(allTypeArguments.size() - 1);
        functionType.addTypeArgument(lastTypeArgument);
        LightweightTypeReference returnType = lastTypeArgument.getUpperBoundSubstitute();
        functionType.setReturnType(returnType);
        return functionType;
    }

    @Nullable
    protected FunctionTypeReference getAsProcedureOrNull(ParameterizedTypeReference typeReference) {
        ITypeReferenceOwner owner = typeReference.getOwner();
        JvmType type = typeReference.getType();
        FunctionTypeReference functionType = new FunctionTypeReference(owner, type);
        if (!this.tryAssignTypeArguments(typeReference.getTypeArguments(), functionType)) {
            return null;
        }
        JvmType voidType = (JvmType)owner.getContextResourceSet().getEObject(URIHelperConstants.PRIMITIVES_URI.appendFragment("void"), true);
        functionType.setReturnType(new ParameterizedTypeReference(owner, voidType));
        return functionType;
    }

    protected boolean tryAssignTypeArguments(List<LightweightTypeReference> typeArguments, FunctionTypeReference result) {
        for (LightweightTypeReference typeArgument : typeArguments) {
            result.addTypeArgument(typeArgument);
            LightweightTypeReference lowerBound = typeArgument.getLowerBoundSubstitute();
            if (lowerBound instanceof AnyTypeReference) {
                return false;
            }
            result.addParameterType(lowerBound);
        }
        return true;
    }
}

