/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.SwitchConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XSwitchExpressions {
    @Inject
    @Extension
    private IBatchTypeResolver _iBatchTypeResolver;
    @Inject
    @Extension
    private SwitchConstantExpressionsInterpreter _switchConstantExpressionsInterpreter;

    public boolean isJavaSwitchExpression(XSwitchExpression it) {
        XExpression _switch;
        boolean _xblockexpression = false;
        IResolvedTypes resolvedTypes = this._iBatchTypeResolver.resolveTypes(it);
        LightweightTypeReference switchType = resolvedTypes.getActualType(_switch = it.getSwitch());
        boolean _equals = Objects.equal((Object)switchType, null);
        if (_equals) {
            return false;
        }
        boolean _isSubtypeOf = switchType.isSubtypeOf(Integer.TYPE);
        if (_isSubtypeOf) {
            return true;
        }
        boolean _isSubtypeOf_1 = switchType.isSubtypeOf(Enum.class);
        if (_isSubtypeOf_1) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean isJavaCaseExpression(XSwitchExpression it, XCasePart casePart) {
        boolean _not;
        boolean _notEquals;
        boolean _xblockexpression = false;
        JvmTypeReference _typeGuard = casePart.getTypeGuard();
        boolean bl = _notEquals = !Objects.equal((Object)_typeGuard, null);
        if (_notEquals) {
            return false;
        }
        XExpression case_ = casePart.getCase();
        boolean _equals = Objects.equal((Object)case_, null);
        if (_equals) {
            return false;
        }
        IResolvedTypes resolvedTypes = this._iBatchTypeResolver.resolveTypes(it);
        LightweightTypeReference caseType = resolvedTypes.getActualType(case_);
        boolean _equals_1 = Objects.equal((Object)caseType, null);
        if (_equals_1) {
            return false;
        }
        XExpression _switch = it.getSwitch();
        LightweightTypeReference switchType = resolvedTypes.getActualType(_switch);
        boolean _isAssignableFrom = switchType.isAssignableFrom(caseType);
        boolean bl2 = _not = !_isAssignableFrom;
        if (_not) {
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public boolean isConstant(XExpression it) {
        boolean _equals = Objects.equal((Object)it, null);
        if (_equals) {
            return false;
        }
        try {
            this._switchConstantExpressionsInterpreter.evaluate(it);
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

