/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.findrefs;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.jvmmodel.AnonymousClassUtil;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.DefaultReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendReferenceFinder
extends DefaultReferenceFinder
implements IReferenceFinder {
    private IQualifiedNameConverter nameConverter;
    @Inject
    @Extension
    private StaticallyImportedMemberProvider _staticallyImportedMemberProvider;
    @Inject
    @Extension
    private AnonymousClassUtil _anonymousClassUtil;

    @Inject
    public XtendReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry, IQualifiedNameConverter nameConverter) {
        super(indexData, serviceProviderRegistry);
        this.nameConverter = nameConverter;
    }

    public void findReferences(final Set<URI> targetURIs, final IResourceDescription resourceDescription, final IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor, IReferenceFinder.ILocalResourceAccess localResourceAccess) {
        Functions.Function1<URI, Boolean> _function_1;
        Functions.Function1<URI, URI> _function = new Functions.Function1<URI, URI>(){

            public URI apply(URI it) {
                return it.trimFragment();
            }
        };
        Iterable _map = IterableExtensions.map(targetURIs, (Functions.Function1)_function);
        boolean _exists = IterableExtensions.exists((Iterable)_map, (Functions.Function1)(_function_1 = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                URI _uRI = resourceDescription.getURI();
                return Objects.equal((Object)it, (Object)_uRI);
            }
        }));
        if (_exists) {
            return;
        }
        final HashSet names = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        for (final URI uri : targetURIs) {
            IUnitOfWork<Object, ResourceSet> _function_2 = new IUnitOfWork<Object, ResourceSet>(){

                public Object exec(ResourceSet it) throws Exception {
                    boolean _notEquals;
                    Object _xblockexpression = null;
                    EObject _eObject = it.getEObject(uri, true);
                    JvmType obj = (JvmType)EcoreUtil2.getContainerOfType((EObject)_eObject, JvmType.class);
                    boolean bl = _notEquals = !Objects.equal((Object)obj, null);
                    if (_notEquals) {
                        String _identifier = obj.getIdentifier();
                        QualifiedName _qualifiedName = XtendReferenceFinder.this.nameConverter.toQualifiedName(_identifier);
                        QualifiedName _lowerCase = _qualifiedName.toLowerCase();
                        names.add(_lowerCase);
                        String _qualifiedName_1 = obj.getQualifiedName('.');
                        QualifiedName _qualifiedName_2 = XtendReferenceFinder.this.nameConverter.toQualifiedName(_qualifiedName_1);
                        QualifiedName _lowerCase_1 = _qualifiedName_2.toLowerCase();
                        names.add(_lowerCase_1);
                    }
                    _xblockexpression = null;
                    return _xblockexpression;
                }
            };
            localResourceAccess.readOnly(uri, (IUnitOfWork)_function_2);
        }
        Iterable _importedNames = resourceDescription.getImportedNames();
        final Set importedNames = IterableExtensions.toSet((Iterable)_importedNames);
        Functions.Function1<QualifiedName, Boolean> _function_3 = new Functions.Function1<QualifiedName, Boolean>(){

            public Boolean apply(QualifiedName it) {
                return importedNames.contains(it);
            }
        };
        boolean _exists_1 = IterableExtensions.exists((Iterable)names, (Functions.Function1)_function_3);
        if (_exists_1) {
            URI _uRI = resourceDescription.getURI();
            IUnitOfWork<Object, ResourceSet> _function_4 = new IUnitOfWork<Object, ResourceSet>(){

                public Object exec(ResourceSet resourceSet) throws Exception {
                    URI _uRI = resourceDescription.getURI();
                    Resource _resource = resourceSet.getResource(_uRI, true);
                    IAcceptor<IReferenceDescription> _function = new IAcceptor<IReferenceDescription>(){

                        public void accept(IReferenceDescription it) {
                            acceptor.accept((Object)it);
                        }
                    };
                    XtendReferenceFinder.this.findLocalReferencesInResource(targetURIs, _resource, (IAcceptor)_function);
                    return null;
                }
            };
            localResourceAccess.readOnly(_uRI, (IUnitOfWork)_function_4);
        }
    }

    protected void findLocalReferencesFromElement(Set<URI> targetURISet, EObject sourceCandidate, Resource localResource, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI, Map<EObject, URI> exportedElementsMap) {
        boolean _not;
        boolean _isStatic;
        boolean _and;
        boolean _isPackageFragment;
        boolean _matched = false;
        if (!_matched && sourceCandidate instanceof XAbstractFeatureCall && (_isPackageFragment = ((XAbstractFeatureCall)sourceCandidate).isPackageFragment())) {
            _matched = true;
            return;
        }
        super.findLocalReferencesFromElement(targetURISet, sourceCandidate, localResource, acceptor, currentExportedContainerURI, exportedElementsMap);
        boolean _matched_1 = false;
        if (!_matched_1 && sourceCandidate instanceof XImportDeclaration) {
            boolean _isWildcard;
            _and = false;
            _isStatic = ((XImportDeclaration)sourceCandidate).isStatic();
            _and = !_isStatic ? false : (_not = !(_isWildcard = ((XImportDeclaration)sourceCandidate).isWildcard()));
            if (_and) {
                _matched_1 = true;
                this.addReferenceToFeatureFromStaticImport((XImportDeclaration)sourceCandidate, targetURISet, acceptor, currentExportedContainerURI);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof XFeatureCall) {
            boolean _isStatic2;
            _and = false;
            XExpression _actualReceiver = ((XFeatureCall)sourceCandidate).getActualReceiver();
            boolean _equals = Objects.equal((Object)_actualReceiver, null);
            _and = !_equals ? false : (_isStatic2 = ((XFeatureCall)sourceCandidate).isStatic());
            if (_and) {
                _matched_1 = true;
                this.addReferenceToTypeFromStaticImport((XAbstractFeatureCall)sourceCandidate, targetURISet, acceptor, currentExportedContainerURI);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof XMemberFeatureCall) {
            boolean _isStaticWithDeclaringType;
            _matched_1 = true;
            _and = false;
            _isStatic = ((XMemberFeatureCall)sourceCandidate).isStatic();
            _and = !_isStatic ? false : (_not = !(_isStaticWithDeclaringType = ((XMemberFeatureCall)sourceCandidate).isStaticWithDeclaringType()));
            if (_and) {
                this.addReferenceToTypeFromStaticImport((XAbstractFeatureCall)sourceCandidate, targetURISet, acceptor, currentExportedContainerURI);
            }
        }
        if (!_matched_1 && sourceCandidate instanceof AnonymousClass) {
            _matched_1 = true;
            this.addReferencesToSuper((AnonymousClass)sourceCandidate, targetURISet, acceptor, currentExportedContainerURI);
        }
    }

    protected void addReferencesToSuper(AnonymousClass anonymousClass, Set<URI> targetURISet, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI) {
        JvmConstructor superConstructor;
        XConstructorCall constructorCall = anonymousClass.getConstructorCall();
        JvmGenericType superType = this._anonymousClassUtil.getSuperType(anonymousClass);
        if (superType != null) {
            this.addReferenceIfTarget((EObject)superType, targetURISet, (EObject)constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, acceptor, currentExportedContainerURI);
        }
        if ((superConstructor = this._anonymousClassUtil.getSuperTypeConstructor(anonymousClass)) != null) {
            this.addReferenceIfTarget((EObject)superConstructor, targetURISet, (EObject)constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, acceptor, currentExportedContainerURI);
        }
    }

    protected void addReferenceToFeatureFromStaticImport(final XImportDeclaration importDeclaration, final Set<URI> targetURISet, final IAcceptor<IReferenceDescription> acceptor, final URI currentExportedContainerURI) {
        Iterable _allFeatures = this._staticallyImportedMemberProvider.getAllFeatures(importDeclaration);
        Procedures.Procedure1<JvmFeature> _function = new Procedures.Procedure1<JvmFeature>(){

            public void apply(JvmFeature it) {
                XtendReferenceFinder.this.addReferenceIfTarget((EObject)it, targetURISet, (EObject)importDeclaration, XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, (IAcceptor<IReferenceDescription>)acceptor, currentExportedContainerURI);
            }
        };
        IterableExtensions.forEach((Iterable)_allFeatures, (Procedures.Procedure1)_function);
    }

    protected void addReferenceToTypeFromStaticImport(XAbstractFeatureCall sourceCandidate, Set<URI> targetURISet, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI) {
        JvmIdentifiableElement feature = sourceCandidate.getFeature();
        if (feature instanceof JvmMember) {
            JvmDeclaredType type = ((JvmMember)feature).getDeclaringType();
            this.addReferenceIfTarget((EObject)type, targetURISet, (EObject)sourceCandidate, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor, currentExportedContainerURI);
        }
    }

    protected void addReferenceIfTarget(EObject candidate, Set<URI> targetURISet, EObject sourceElement, EReference reference, IAcceptor<IReferenceDescription> acceptor, URI currentExportedContainerURI) {
        URI candidateURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)candidate);
        boolean _contains = targetURISet.contains(candidateURI);
        if (_contains) {
            URI sourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)sourceElement);
            DefaultReferenceDescription _defaultReferenceDescription = new DefaultReferenceDescription(sourceURI, candidateURI, reference, -1, currentExportedContainerURI);
            acceptor.accept((Object)_defaultReferenceDescription);
        }
    }
}

