/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.ByteExtensions;
import org.eclipse.xtext.xbase.lib.CharacterExtensions;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.FloatExtensions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.LongExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.ReassignFirstArgument;
import org.eclipse.xtext.xbase.lib.ShortExtensions;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XExpressionHelper {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private OperatorMapping operatorMapping;

    public boolean hasSideEffects(XExpression expr) {
        if (expr instanceof XClosure || expr instanceof XStringLiteral || expr instanceof XTypeLiteral || expr instanceof XBooleanLiteral || expr instanceof XNumberLiteral || expr instanceof XNullLiteral || expr instanceof XAnnotation) {
            return false;
        }
        if (expr instanceof XCollectionLiteral) {
            for (XExpression element : ((XCollectionLiteral)expr).getElements()) {
                if (!this.hasSideEffects(element)) continue;
                return true;
            }
            return false;
        }
        if (expr instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expr;
            return this.hasSideEffects(featureCall, true);
        }
        if (expr instanceof XConstructorCall) {
            XConstructorCall constrCall = (XConstructorCall)expr;
            return this.findPureAnnotation((JvmExecutable)constrCall.getConstructor()) == null;
        }
        return true;
    }

    public boolean hasSideEffects(XAbstractFeatureCall featureCall, boolean inspectContents) {
        XBinaryOperation binaryOperation;
        if (featureCall instanceof XBinaryOperation && (binaryOperation = (XBinaryOperation)featureCall).isReassignFirstArgument()) {
            return true;
        }
        if (featureCall instanceof XAssignment) {
            return true;
        }
        if (featureCall.isPackageFragment() || featureCall.isTypeLiteral()) {
            return false;
        }
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature == null || feature.eIsProxy()) {
            return true;
        }
        if (feature instanceof JvmConstructor) {
            return true;
        }
        if (feature instanceof JvmOperation) {
            JvmOperation jvmOperation = (JvmOperation)feature;
            if (this.findPureAnnotation((JvmExecutable)jvmOperation) == null) {
                return true;
            }
            if (inspectContents) {
                for (XExpression param : featureCall.getActualArguments()) {
                    if (!this.hasSideEffects(param)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public JvmAnnotationReference findInlineAnnotation(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        return this.findInlineAnnotation(feature);
    }

    public JvmAnnotationReference findInlineAnnotation(JvmIdentifiableElement feature) {
        if (feature instanceof JvmAnnotationTarget) {
            return this.findAnnotation((JvmAnnotationTarget)feature, Inline.class.getName());
        }
        return null;
    }

    public JvmAnnotationReference findCompoundAssignmentAnnotation(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        return this.findReassignFirstArgumentAnnotation(feature);
    }

    public JvmAnnotationReference findReassignFirstArgumentAnnotation(JvmIdentifiableElement feature) {
        if (feature instanceof JvmAnnotationTarget) {
            return this.findAnnotation((JvmAnnotationTarget)feature, ReassignFirstArgument.class.getName());
        }
        return null;
    }

    public JvmAnnotationReference findPureAnnotation(JvmExecutable featureCall) {
        return this.findAnnotation((JvmAnnotationTarget)featureCall, Pure.class.getName());
    }

    protected JvmAnnotationReference findAnnotation(JvmAnnotationTarget feature, String annotationType) {
        if (feature == null) {
            return null;
        }
        if (annotationType == null) {
            throw new NullPointerException();
        }
        EList annotations = feature.getAnnotations();
        for (JvmAnnotationReference annotation : annotations) {
            if (!annotationType.equals(annotation.getAnnotation().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    public String getAndOperator() {
        return "&&";
    }

    public String getOrOperator() {
        return "||";
    }

    public String getElvisOperator() {
        return "?:";
    }

    public boolean isGetAndAssign(XAbstractFeatureCall featureCall) {
        if (!(featureCall instanceof XPostfixOperation)) {
            return false;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, DoubleExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, DoubleExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, FloatExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, FloatExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, LongExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, LongExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, IntegerExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, IntegerExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, ShortExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, ShortExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, CharacterExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, CharacterExtensions.class)) {
            return true;
        }
        if (this.isOperatorFromExtension(featureCall, OperatorMapping.MINUS_MINUS, ByteExtensions.class)) {
            return true;
        }
        return this.isOperatorFromExtension(featureCall, OperatorMapping.PLUS_PLUS, ByteExtensions.class);
    }

    public boolean isShortCircuitOperation(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XBinaryOperation) {
            if (this.isOperatorFromExtension(featureCall, OperatorMapping.ELVIS, ObjectExtensions.class)) {
                return true;
            }
            return this.isOperatorFromExtension(featureCall, OperatorMapping.AND, BooleanExtensions.class) || this.isOperatorFromExtension(featureCall, OperatorMapping.OR, BooleanExtensions.class);
        }
        return false;
    }

    public boolean isOperatorFromExtension(XExpression expression, QualifiedName operatorSymbol, Class<?> definingExtensionClass) {
        return expression instanceof XAbstractFeatureCall && this.isOperatorFromExtension((XAbstractFeatureCall)expression, operatorSymbol, definingExtensionClass);
    }

    public boolean isOperatorFromExtension(XAbstractFeatureCall featureCall, QualifiedName operatorSymbol, Class<?> definingExtensionClass) {
        if (!Strings.equal((String)featureCall.getConcreteSyntaxFeatureName(), (String)operatorSymbol.getLastSegment())) {
            return false;
        }
        List<QualifiedName> methodNames = this.getMethodNames(featureCall, operatorSymbol);
        Iterator<QualifiedName> iterator = methodNames.iterator();
        if (iterator.hasNext()) {
            QualifiedName methodName = iterator.next();
            JvmDeclaredType definingJvmType = (JvmDeclaredType)this.typeReferences.findDeclaredType(definingExtensionClass, (Notifier)featureCall);
            if (definingJvmType == null) {
                return false;
            }
            Iterable operatorImplementations = definingJvmType.findAllFeaturesByName(methodName.getLastSegment());
            return Iterables.contains((Iterable)operatorImplementations, (Object)featureCall.getFeature());
        }
        return false;
    }

    protected List<QualifiedName> getMethodNames(XAbstractFeatureCall featureCall, QualifiedName operatorSymbol) {
        QualifiedName simpleOperator;
        XBinaryOperation binaryOperation;
        ArrayList<QualifiedName> methodNames = new ArrayList<QualifiedName>();
        methodNames.add(this.operatorMapping.getMethodName(operatorSymbol));
        if (featureCall instanceof XBinaryOperation && (binaryOperation = (XBinaryOperation)featureCall).isReassignFirstArgument() && (simpleOperator = this.operatorMapping.getSimpleOperator(operatorSymbol)) != null) {
            methodNames.add(this.operatorMapping.getMethodName(simpleOperator));
        }
        return methodNames;
    }

    public boolean isInlined(XAbstractFeatureCall call) {
        return this.findInlineAnnotation(call) != null;
    }
}

