/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.junit.editor.cursorHandling;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.junit.editor.AbstractEditorTest;
import org.eclipse.xtext.ui.junit.util.IResourcesSetupUtil;

public abstract class AbstractCursorHandlingTest
extends AbstractEditorTest {
    private List<IFile> files = Lists.newArrayList();

    protected abstract String getFileExtension();

    protected void setUp() throws Exception {
        super.setUp();
        this.closeWelcomePage();
    }

    protected void tearDown() throws Exception {
        this.files.clear();
        this.closeEditors();
        super.tearDown();
    }

    protected XtextEditor openEditor(String content) throws Exception {
        int cursor = content.indexOf(124);
        String fileExtension = this.getFileExtension();
        IFile file = IResourcesSetupUtil.createFile("foo/myfile" + this.files.size() + "." + fileExtension, content.replace("|", ""));
        this.files.add(file);
        XtextEditor editor = this.openEditor(file);
        editor.getInternalSourceViewer().setSelectedRange(cursor, 0);
        editor.getInternalSourceViewer().getTextWidget().setFocus();
        return editor;
    }

    protected void assertState(String string, XtextEditor editor) {
        int cursor = string.indexOf(124);
        AbstractCursorHandlingTest.assertEquals((String)string.replace("|", ""), (String)editor.getDocument().get());
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        AbstractCursorHandlingTest.assertEquals((String)"unexpected cursor position:", (int)cursor, (int)selection.getOffset());
    }

    protected void navigateLeft(XtextEditor editor) {
        IAction action = editor.getAction("org.eclipse.ui.edit.text.goto.wordPrevious");
        action.run();
    }

    protected void navigateRight(XtextEditor editor) {
        IAction action = editor.getAction("org.eclipse.ui.edit.text.goto.wordNext");
        action.run();
    }

    protected void toLineStart(XtextEditor editor) {
        IAction action = editor.getAction("org.eclipse.ui.edit.text.goto.lineStart");
        action.run();
    }
}

