/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.navigation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.DefaultHyperlinkDetector;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.resource.JvmElementAtOffsetHelper;
import org.eclipse.xtext.xbase.ui.navigation.JvmImplementationOpener;
import org.eclipse.xtext.xbase.ui.navigation.XbaseImplementatorsHyperlink;

public class XbaseHyperlinkDetector
extends DefaultHyperlinkDetector {
    @Inject
    private JvmElementAtOffsetHelper jvmElementAtOffsetHelper;
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private JvmImplementationOpener implOpener;

    public IHyperlink[] detectHyperlinks(final ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList links = Lists.newArrayList();
        Object[] detectedHyperlinks = super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        IHyperlink implementatorLink = null;
        if (canShowMultipleHyperlinks) {
            implementatorLink = (IHyperlink)((IXtextDocument)textViewer.getDocument()).priorityReadOnly((IUnitOfWork)new IUnitOfWork<IHyperlink, XtextResource>(){

                public IHyperlink exec(XtextResource resource) throws Exception {
                    IRegion word = JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)region.getOffset());
                    JvmIdentifiableElement jvmIdentifiableElement = XbaseHyperlinkDetector.this.jvmElementAtOffsetHelper.getJvmIdentifiableElement(resource, region.getOffset());
                    if (jvmIdentifiableElement != null && word != null) {
                        return this.createHyperlink(textViewer, jvmIdentifiableElement, word);
                    }
                    return null;
                }

                private IHyperlink createHyperlink(ITextViewer textViewer2, JvmIdentifiableElement candidate, IRegion word) {
                    IJavaElement javaElement = XbaseHyperlinkDetector.this.javaElementFinder.findExactElementFor(candidate);
                    if (javaElement != null && javaElement.getElementType() == 9 && this.canBeOverridden((IMethod)javaElement)) {
                        return new XbaseImplementatorsHyperlink(javaElement, word, textViewer2, XbaseHyperlinkDetector.this.implOpener);
                    }
                    return null;
                }

                private boolean canBeOverridden(IMethod method) {
                    try {
                        return !JdtFlags.isPrivate((IMember)method) && !JdtFlags.isFinal((IMember)method) && !JdtFlags.isStatic((IMember)method) && !method.isConstructor() && !JdtFlags.isFinal((IMember)((IMember)method.getParent()));
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((Throwable)e);
                        return false;
                    }
                }
            });
        }
        if (detectedHyperlinks == null && implementatorLink == null) {
            return null;
        }
        if (detectedHyperlinks != null && detectedHyperlinks.length > 0) {
            links.addAll(Lists.newArrayList((Object[])detectedHyperlinks));
        }
        if (implementatorLink != null) {
            links.add(implementatorLink);
        }
        return (IHyperlink[])Iterables.toArray((Iterable)links, IHyperlink.class);
    }
}

